----------------------------------------------------------------------------
-- MISCELLANEOUS FUNCTIONS
----------------------------------------------------------------------------

create or replace function wb_rt_version return varchar2 is

  l_result varchar2(64);
  l_clob clob;
  l_amount binary_integer := 64;  
begin
  select 
    property_value into l_clob 
  from 
    wb_rt_platform_properties  
  where
    property_path = 'property.RuntimePlatform.0.version';
    
  dbms_lob.read(l_clob, l_amount, 1, l_result);
  
  return l_result;
end;
/

create or replace function wb_rt_is_platform_repository return number authid current_user is

  l_result number;
  l_count number;
begin
  select 
    count(*) 
  into
    l_count
  from 
    user_tables 
  where 
    table_name = 'WB_RT_PLATFORM_PROPERTIES';

  if l_count <> 0
  then
    l_result := 1;
  else
    l_result := 0;
  end if;
  
  return l_result;
end;
/

create or replace function wb_rt_integer_version_number(p_version in varchar2) return number
is
  l_component_1 number;
  l_component_2 number;
  l_component_3 number;
  l_component_4 number;
  l_component_5 number;
  l_compare_start number;
  l_compare_end number;
  l_component varchar2(16);
  l_result number;
begin
  l_compare_start := 1;
  l_compare_end := instr(p_version, '.', l_compare_start);
  l_component_1 := to_number(substr(p_version, l_compare_start, (l_compare_end - l_compare_start)));

  l_compare_start := l_compare_end + 1;
  l_compare_end := instr(p_version, '.', l_compare_start);
  l_component_2 := to_number(substr(p_version, l_compare_start, (l_compare_end - l_compare_start)));

  l_compare_start := l_compare_end + 1;
  l_compare_end := instr(p_version, '.', l_compare_start);
  l_component_3 := to_number(substr(p_version, l_compare_start, (l_compare_end - l_compare_start)));

  l_compare_start := l_compare_end + 1;
  l_compare_end := instr(p_version, '.', l_compare_start);
  l_component_4 := to_number(substr(p_version, l_compare_start, (l_compare_end - l_compare_start)));

  l_compare_start := l_compare_end + 1;
  l_compare_end := instr(p_version, '.', l_compare_start);
  l_component_5 := to_number(substr(p_version, l_compare_start));

  l_result := l_component_5 + 100*(l_component_4 + 100*(l_component_3 + 100*(l_component_2 + 100*l_component_1)));

  return l_result;
end;
/

create or replace function owbrtps_key_to_instance(p_key in varchar2) return number
is
  l_start number;
  l_end number;
  l_result number;
begin
  l_start := instr(p_key, '[') + 1;
  if l_start > 1
  then
    l_end := instr(p_key, ']') - 1;
    l_result := to_number(substr(p_key, l_start, (l_end - l_start + 1)));
  end if;
  return l_result;

exception
  when others
  then
    return null;
end;
/

create or replace function owbrtps_key_to_version(p_key in varchar2) return number
is
  l_end number;
begin
  l_end := instr(p_key, '[') - 1;
  if l_end < 0
  then
    l_end := length(p_key);
  end if;
  return owbsys.wb_rt_integer_version_number(substr(p_key, 1, l_end));

exception
  when others
  then
    return null;
end;
/

create or replace function owbrtps_key_to_version_string(p_key in varchar2) return varchar2
is
  l_end number;
begin
  l_end := instr(p_key, '[') - 1;
  if l_end < 0
  then
    l_end := length(p_key);
  end if;
  return substr(p_key, 1, l_end);

exception
  when others
  then
    return null;
end;
/

create or replace function wb_rt_minimum_service_version return varchar2 is
  l_result varchar2(64);
  l_clob clob;
  l_amount binary_integer := 64;  
begin
  select 
    property_value into l_clob 
  from 
    wb_rt_platform_properties  
  where
    property_path = 'property.RuntimePlatform.0.min_service_version';
    
  dbms_lob.read(l_clob, l_amount, 1, l_result);
  
  return l_result;
end;
/


create or replace function wb_rt_platform_repository return varchar2 is
begin
  return upper('%user');
end;
/

