Rem
Rem Copyright (c) 2000, 2007, Oracle. All rights reserved.  
Rem

----------------------------------------------------------------------------
-- SEQUENCES
----------------------------------------------------------------------------

create sequence wb_rt_platform_catalog_seq start with 1 increment by 1 order;
create sequence wb_rt_platform_task_seq start with 1 increment by 1 order;
create sequence wb_rt_platform_file_seq start with 1 increment by 1 order;

----------------------------------------------------------------------------
-- REPOSITORY CONFIG TABLE
----------------------------------------------------------------------------

create table owb$wb_rt_platform_config
(
  value varchar2(4000),
  enterprise_mode number(1),
  notm number(11),
  workspace_id number(11) DEFAULT sys_context('owb_workspace', 'workspaceId')
);

----------------------------------------------------------------------------
-- CLIENT VALUES TABLE
----------------------------------------------------------------------------

create table owb$wb_rt_client_values
(
  client_value_id number(22) not null,
  uoid varchar2(32) not null,
  user_id number(10) not null,
  access_restricted number(1) DEFAULT 1 not null,
  value varchar2(4000) null,
  workspace_id number(11) DEFAULT sys_context('owb_workspace', 'workspaceId') not null
);

----------------------------------------------------------------------------
-- CATALOG TABLES: STORES 
----------------------------------------------------------------------------
CREATE TABLE OWB$WB_RT_STORES
(
STORE_ID NUMBER(22) NOT NULL,
STORE_TYPE_ID NUMBER(22) NOT NULL,
STORE_UOID VARCHAR2(32) NOT NULL,
STORE_NAME VARCHAR2(64) NOT NULL,
VERSION_TAG VARCHAR2(80),
IS_DEPLOYMENT_TARGET NUMBER(1) NOT NULL,
OWNER_UOID VARCHAR2(32),
REPOS_UOID VARCHAR2(32),
IS_LOCAL_TO_REPOS NUMBER(1) DEFAULT 0,
WORKSPACE_ID NUMBER(22) DEFAULT sys_context('owb_workspace', 'workspaceId')
)
;

CREATE TABLE OWB$WB_RT_STORE_PARAMS
(
STORE_PARAMETER_ID NUMBER(22) NOT NULL,
STORE_ID NUMBER(22) NOT NULL,
PARAMETER_NAME VARCHAR2(64) NOT NULL,
PARAMETER_VALUE VARCHAR2(4000),
WORKSPACE_ID NUMBER(22) DEFAULT sys_context('owb_workspace', 'workspaceId') NOT NULL
)
;

CREATE TABLE OWB$WB_RT_WAREHOUSE_OBJECTS
(
WAREHOUSE_OBJECT_ID NUMBER(22) NOT NULL,
STORE_ID NUMBER(22) NOT NULL,
TGT_STORE_ID NUMBER(22),
OBJECT_TYPE_ID NUMBER(22) NOT NULL,
OBJECT_TYPE_NAME VARCHAR2(64) NOT NULL,
IMPL_TYPE_NAME VARCHAR2(64),
PARENT_OBJECT_ID NUMBER(22),
OBJECT_UOID VARCHAR2(32) NOT NULL,
OBJECT_NAME VARCHAR2(64),
OBJECT_QNAME VARCHAR2(4000),
VERSION_TAG VARCHAR2(80),
CREATION_SCRIPT CLOB,
CREATION_SCRIPT_BINARY BLOB,
SCRIPT_MIME_TYPE VARCHAR2(64),
SCRIPT_ENCODING_TYPE VARCHAR2(64),
CLIENT_INFO CLOB,
METADATA_INFO CLOB,
OBJECT_STATUS NUMBER(8) NOT NULL,
SUB_OBJECTS_VALID NUMBER(1) NOT NULL,
RELATED_OBJECTS_VALID NUMBER(1),
DEPLOYMENT_REPOS_VERSION VARCHAR2(32) NOT NULL,
UPGRADE_INCOMPATIBILITY NUMBER(1) NOT NULL,
LAST_AUDIT_OBJECT_ID NUMBER(22),
LAST_AUDIT_SCRIPT_RUN_ID NUMBER(22),
CREATED_ON DATE NOT NULL,
CREATED_BY VARCHAR2(30) DEFAULT user NOT NULL,
UPDATED_ON DATE,
WORKSPACE_ID NUMBER(22) DEFAULT sys_context('owb_workspace', 'workspaceId') NOT NULL
)
;

CREATE TABLE OWB$WB_RT_USER_VALUES
(
USER_VALUE_ID NUMBER(22) NOT NULL,
STORE_PARAMETER_ID NUMBER(22) NOT NULL,
USER_ID NUMBER(10) NOT NULL,
ACCESS_RESTRICTED NUMBER(1) DEFAULT 1 NOT NULL,
PARAMETER_VALUE VARCHAR2(4000),
WORKSPACE_ID NUMBER(22) DEFAULT sys_context('owb_workspace', 'workspaceId') NOT NULL
)
;

CREATE TABLE OWB$WB_RT_TASKS
(
TASK_ID NUMBER(22) NOT NULL,
WAREHOUSE_OBJECT_ID NUMBER(22) NOT NULL,
EXECUTION_STORE_UOID VARCHAR2(32) NOT NULL,
EXECUTION_OPERATOR_ID NUMBER(22) NOT NULL,
EXECUTION_OBJECT_UOID VARCHAR2(32),
EXECUTION_OBJECT_TYPE_ID NUMBER(22),
EXECUTION_OBJECT_STORE_UOID VARCHAR2(32),
EXECUTION_OBJECT_STORE_TYPE_ID NUMBER(22),
TASK_NAME VARCHAR2(64),
TASK_INPUT CLOB,
TASK_INPUT_BINARY BLOB,
TASK_INPUT_MIME_TYPE VARCHAR2(64),
TASK_INPUT_ENCODING_TYPE VARCHAR2(64),
WORKSPACE_ID NUMBER(22) DEFAULT sys_context('owb_workspace', 'workspaceId') NOT NULL
)
;

CREATE TABLE OWB$WB_RT_TASK_CUSTOM_PARAMS
(
CUSTOM_PARAMETER_ID NUMBER(22) NOT NULL,
TASK_ID NUMBER(22),
PARAMETER_UOID VARCHAR2(32) NOT NULL,
PARAMETER_NAME VARCHAR2(64) NOT NULL,
PARAMETER_TYPE NUMBER(8) NOT NULL,
PARAMETER_MODE NUMBER(8) NOT NULL,
PARAMETER_SCOPE NUMBER(8),
IS_FIXED NUMBER(1) NOT NULL,
IS_REQUIRED NUMBER(1) NOT NULL,
TYPE_LENGTH NUMBER(10),
TYPE_SCALE NUMBER(10),
TYPE_PRECISION NUMBER(10),
WORKSPACE_ID NUMBER(22) DEFAULT sys_context('owb_workspace', 'workspaceId') NOT NULL
)
;

CREATE TABLE OWB$WB_RT_STATE_VARIABLES
(
STATE_VARIABLE_ID NUMBER(22) NOT NULL,
WAREHOUSE_OBJECT_ID NUMBER(22) NOT NULL,
VARIABLE_UOID VARCHAR2(32) NOT NULL,
VARIABLE_NAME VARCHAR2(64) NOT NULL,
VARIABLE_TYPE NUMBER(8) NOT NULL,
VALUE_KIND NUMBER(8) NOT NULL,
CLOB_VALUE CLOB,
TYPE_LENGTH NUMBER(10),
TYPE_SCALE NUMBER(10),
TYPE_PRECISION NUMBER(10),
WORKSPACE_ID NUMBER(22) DEFAULT sys_context('owb_workspace', 'workspaceId') NOT NULL
)
;

CREATE TABLE "OWB$WB_RT_TASK_PARAM_DEFAULTS"
(
"TASK_PARAMETER_DEFAULT_ID" NUMBER(22) NOT NULL,
"TASK_ID" NUMBER(22) NOT NULL,
"CUSTOM_PARAMETER_ID" NUMBER(22),
"SYSTEM_PARAMETER_ID" NUMBER(22),
"BOUND_TO_NAME" VARCHAR2(64),
"BOUND_TO_KIND" NUMBER(8),
"BOUND_TO_SCOPE" NUMBER(8),
"VALUE_KIND" NUMBER(8) NOT NULL,
"CLOB_VALUE" CLOB,
"WORKSPACE_ID" NUMBER(22) DEFAULT sys_context('owb_workspace', 'workspaceId')
)
;

CREATE VIEW WB_RT_STORES AS select STORE_ID,STORE_TYPE_ID,STORE_UOID,STORE_NAME,VERSION_TAG,IS_DEPLOYMENT_TARGET,OWNER_UOID,REPOS_UOID,IS_LOCAL_TO_REPOS,WORKSPACE_ID from OWB$WB_RT_STORES where (workspace_id = wb_workspace_management.get_workspace_id or workspace_id = 0 or workspace_id is null) and wb_workspace_management.has_system_privilege_int('CONTROL_CENTER_VIEW') != 0;

CREATE VIEW WB_RT_STORE_PARAMETERS AS select STORE_PARAMETER_ID,STORE_ID,PARAMETER_NAME,PARAMETER_VALUE,WORKSPACE_ID from OWB$WB_RT_STORE_PARAMS where (workspace_id = wb_workspace_management.get_workspace_id or workspace_id = 0 or workspace_id is null) and wb_workspace_management.has_system_privilege_int('CONTROL_CENTER_VIEW') != 0;

CREATE VIEW WB_RT_TASKS AS select TASK_ID,WAREHOUSE_OBJECT_ID,EXECUTION_STORE_UOID,EXECUTION_OPERATOR_ID,EXECUTION_OBJECT_UOID,EXECUTION_OBJECT_TYPE_ID,EXECUTION_OBJECT_STORE_UOID,EXECUTION_OBJECT_STORE_TYPE_ID,TASK_NAME,TASK_INPUT,TASK_INPUT_BINARY,TASK_INPUT_MIME_TYPE,TASK_INPUT_ENCODING_TYPE,WORKSPACE_ID from OWB$WB_RT_TASKS where (workspace_id = wb_workspace_management.get_workspace_id or workspace_id = 0 or workspace_id is null) and wb_workspace_management.has_system_privilege_int('CONTROL_CENTER_VIEW') != 0;

CREATE VIEW WB_RT_TASK_CUSTOM_PARAMETERS AS select CUSTOM_PARAMETER_ID,TASK_ID,PARAMETER_UOID,PARAMETER_NAME,PARAMETER_TYPE,PARAMETER_MODE,PARAMETER_SCOPE,IS_FIXED,IS_REQUIRED,TYPE_LENGTH,TYPE_SCALE,TYPE_PRECISION,WORKSPACE_ID from OWB$WB_RT_TASK_CUSTOM_PARAMS where (workspace_id = wb_workspace_management.get_workspace_id or workspace_id = 0 or workspace_id is null) and wb_workspace_management.has_system_privilege_int('CONTROL_CENTER_VIEW') != 0;

CREATE VIEW WB_RT_USER_VALUES AS select USER_VALUE_ID,STORE_PARAMETER_ID,USER_ID,ACCESS_RESTRICTED,PARAMETER_VALUE,WORKSPACE_ID from OWB$WB_RT_USER_VALUES where (workspace_id = wb_workspace_management.get_workspace_id or workspace_id = 0 or workspace_id is null) and wb_workspace_management.has_system_privilege_int('CONTROL_CENTER_VIEW') != 0;

CREATE VIEW WB_RT_CLIENT_VALUES AS select CLIENT_VALUE_ID,UOID,USER_ID,ACCESS_RESTRICTED,VALUE,WORKSPACE_ID from OWB$WB_RT_CLIENT_VALUES where (workspace_id = wb_workspace_management.get_workspace_id or workspace_id = 0 or workspace_id is null);

CREATE VIEW WB_RT_WAREHOUSE_OBJECTS AS select WAREHOUSE_OBJECT_ID,STORE_ID,TGT_STORE_ID,OBJECT_TYPE_ID,OBJECT_TYPE_NAME,IMPL_TYPE_NAME,PARENT_OBJECT_ID,OBJECT_UOID,OBJECT_NAME,OBJECT_QNAME,VERSION_TAG,CREATION_SCRIPT,CREATION_SCRIPT_BINARY,SCRIPT_MIME_TYPE,SCRIPT_ENCODING_TYPE,CLIENT_INFO,METADATA_INFO,OBJECT_STATUS,SUB_OBJECTS_VALID,RELATED_OBJECTS_VALID,DEPLOYMENT_REPOS_VERSION,UPGRADE_INCOMPATIBILITY,LAST_AUDIT_OBJECT_ID,LAST_AUDIT_SCRIPT_RUN_ID,CREATED_ON,CREATED_BY,UPDATED_ON,WORKSPACE_ID from OWB$WB_RT_WAREHOUSE_OBJECTS where (workspace_id = wb_workspace_management.get_workspace_id or workspace_id = 0 or workspace_id is null) and wb_workspace_management.has_system_privilege_int('CONTROL_CENTER_VIEW') != 0;

CREATE VIEW WB_RT_STATE_VARIABLES AS select STATE_VARIABLE_ID,WAREHOUSE_OBJECT_ID,VARIABLE_UOID,VARIABLE_NAME,VARIABLE_TYPE,VALUE_KIND,CLOB_VALUE,cast(DBMS_LOB.substr(CLOB_VALUE, 4000, 1) AS VARCHAR2(4000)) AS VALUE,TYPE_LENGTH,TYPE_SCALE,TYPE_PRECISION,WORKSPACE_ID from OWB$WB_RT_STATE_VARIABLES where (workspace_id = wb_workspace_management.get_workspace_id or workspace_id = 0 or workspace_id is null) and wb_workspace_management.has_system_privilege_int('CONTROL_CENTER_VIEW') != 0;

CREATE VIEW "WB_RT_TASK_PARAMETER_DEFAULTS" AS SELECT 
    OWB$WB_RT_TASK_PARAM_DEFAULTS.TASK_PARAMETER_DEFAULT_ID TASK_PARAMETER_DEFAULT_ID, 
    OWB$WB_RT_TASK_PARAM_DEFAULTS.TASK_ID TASK_ID, 
    OWB$WB_RT_TASK_PARAM_DEFAULTS.CUSTOM_PARAMETER_ID CUSTOM_PARAMETER_ID, 
    OWB$WB_RT_TASK_PARAM_DEFAULTS.SYSTEM_PARAMETER_ID SYSTEM_PARAMETER_ID, 
    OWB$WB_RT_TASK_PARAM_DEFAULTS.BOUND_TO_NAME BOUND_TO_NAME, 
    OWB$WB_RT_TASK_PARAM_DEFAULTS.BOUND_TO_KIND BOUND_TO_KIND, 
    OWB$WB_RT_TASK_PARAM_DEFAULTS.BOUND_TO_SCOPE BOUND_TO_SCOPE, 
    OWB$WB_RT_TASK_PARAM_DEFAULTS.VALUE_KIND VALUE_KIND, 
    OWB$WB_RT_TASK_PARAM_DEFAULTS.CLOB_VALUE CLOB_VALUE,
    cast (DBMS_LOB.substr(OWB$WB_RT_TASK_PARAM_DEFAULTS.CLOB_VALUE, 4000, 1) AS VARCHAR2(4000)) VALUE
FROM 
    OWB$WB_RT_TASK_PARAM_DEFAULTS
where (workspace_id = wb_workspace_management.get_workspace_id or workspace_id = 0 or workspace_id is null) and wb_workspace_management.has_system_privilege_int('CONTROL_CENTER_VIEW') != 0;

-- hide null workspace rows as these are only used internally by the service to hold the password value
CREATE VIEW WB_RT_PLATFORM_CONFIG  AS select value, enterprise_mode, notm, workspace_id from owb$wb_rt_platform_config where (workspace_id = wb_workspace_management.get_workspace_id) and wb_workspace_management.has_system_privilege_int('CONTROL_CENTER_VIEW') != 0;

ALTER TABLE OWB$WB_RT_STORES
ADD CONSTRAINT CS_PK PRIMARY KEY
(
STORE_ID
)
 ENABLE
;

ALTER TABLE OWB$WB_RT_STORES
ADD CONSTRAINT CS_UK_NAME UNIQUE
(
WORKSPACE_ID,
STORE_NAME
)
 ENABLE
;

ALTER TABLE OWB$WB_RT_STORES
ADD CONSTRAINT CS_UK_UOID UNIQUE
(
WORKSPACE_ID,
STORE_UOID
)
 ENABLE
;

ALTER TABLE OWB$WB_RT_STORE_PARAMS
ADD CONSTRAINT CSP_PK PRIMARY KEY
(
STORE_PARAMETER_ID
)
 ENABLE
;

ALTER TABLE OWB$WB_RT_STORE_PARAMS
ADD CONSTRAINT CSP_UK_NAME UNIQUE
(
STORE_ID,
PARAMETER_NAME
)
 ENABLE
;

ALTER TABLE OWB$WB_RT_WAREHOUSE_OBJECTS
ADD CONSTRAINT CO_PK PRIMARY KEY
(
WAREHOUSE_OBJECT_ID
)
 ENABLE
;

ALTER TABLE OWB$WB_RT_WAREHOUSE_OBJECTS
ADD CONSTRAINT CO_UK_NAME UNIQUE
(
PARENT_OBJECT_ID,
OBJECT_QNAME,
STORE_ID,
OBJECT_TYPE_NAME,
WORKSPACE_ID
)
 ENABLE
;

ALTER TABLE OWB$WB_RT_WAREHOUSE_OBJECTS
ADD CONSTRAINT CO_UK_UOID UNIQUE
(
OBJECT_UOID,
STORE_ID,
OBJECT_TYPE_NAME,
WORKSPACE_ID
)
 ENABLE
;

ALTER TABLE OWB$WB_RT_USER_VALUES
ADD CONSTRAINT UV_PK PRIMARY KEY
(
USER_VALUE_ID
)
 ENABLE
;

ALTER TABLE OWB$WB_RT_USER_VALUES
ADD CONSTRAINT UV_UK UNIQUE
(
STORE_PARAMETER_ID,
USER_ID
)
 ENABLE
;

ALTER TABLE OWB$WB_RT_CLIENT_VALUES
ADD CONSTRAINT CV_PK PRIMARY KEY
(
CLIENT_VALUE_ID
)
 ENABLE
;

ALTER TABLE OWB$WB_RT_CLIENT_VALUES
ADD CONSTRAINT CV_UK UNIQUE
(
UOID,
USER_ID,
WORKSPACE_ID
)
 ENABLE
;

ALTER TABLE OWB$WB_RT_TASKS
ADD CONSTRAINT ET_PK PRIMARY KEY
(
TASK_ID
)
 ENABLE
;

ALTER TABLE OWB$WB_RT_TASKS
ADD CONSTRAINT ET_UK UNIQUE
(
WAREHOUSE_OBJECT_ID,
EXECUTION_STORE_UOID,
TASK_NAME
)
 ENABLE
;

ALTER TABLE OWB$WB_RT_TASKS
ADD CONSTRAINT "ET_FK_DEO" FOREIGN KEY 
(
EXECUTION_OPERATOR_ID
)
REFERENCES WB_RT_DEF_EXECUTION_OPERATORS 
(
EXECUTION_OPERATOR_ID
)
ENABLE
;


ALTER TABLE OWB$WB_RT_TASK_CUSTOM_PARAMS
ADD CONSTRAINT TCP_PK PRIMARY KEY
(
CUSTOM_PARAMETER_ID
)
 ENABLE
;

ALTER TABLE OWB$WB_RT_STATE_VARIABLES
ADD CONSTRAINT TSV_PK PRIMARY KEY
(
STATE_VARIABLE_ID
)
 ENABLE
;

ALTER TABLE OWB$WB_RT_STATE_VARIABLES
ADD CONSTRAINT TSV_UK UNIQUE
(
WAREHOUSE_OBJECT_ID,
VARIABLE_UOID
)
 ENABLE
;

ALTER TABLE OWB$WB_RT_STATE_VARIABLES
ADD CONSTRAINT TSV_UK_NAME UNIQUE
(
WAREHOUSE_OBJECT_ID,
VARIABLE_NAME
)
 ENABLE
;

ALTER TABLE OWB$WB_RT_STORE_PARAMS
ADD CONSTRAINT CSP_FK_CS FOREIGN KEY
(
STORE_ID
)
REFERENCES OWB$WB_RT_STORES
(
STORE_ID
)
ON DELETE CASCADE ENABLE
;

ALTER TABLE OWB$WB_RT_WAREHOUSE_OBJECTS
ADD CONSTRAINT CO_FK_LSR FOREIGN KEY
(
LAST_AUDIT_SCRIPT_RUN_ID
)
REFERENCES OWB$WB_RT_AUDIT_SCRIPT_RUNS
(
AUDIT_SCRIPT_RUN_ID
)
ON DELETE SET NULL ENABLE
;

ALTER TABLE OWB$WB_RT_WAREHOUSE_OBJECTS
ADD CONSTRAINT CO_FK_LAO FOREIGN KEY
(
LAST_AUDIT_OBJECT_ID
)
REFERENCES OWB$WB_RT_AUDIT_OBJECTS
(
AUDIT_OBJECT_ID
)
ON DELETE SET NULL ENABLE
;

ALTER TABLE OWB$WB_RT_WAREHOUSE_OBJECTS
ADD CONSTRAINT CO_FK_TS FOREIGN KEY
(
TGT_STORE_ID
)
REFERENCES OWB$WB_RT_STORES
(
STORE_ID
)
ON DELETE CASCADE ENABLE
;

ALTER TABLE OWB$WB_RT_WAREHOUSE_OBJECTS
ADD CONSTRAINT CO_FK_CS FOREIGN KEY
(
STORE_ID
)
REFERENCES OWB$WB_RT_STORES
(
STORE_ID
)
ON DELETE CASCADE ENABLE
;

ALTER TABLE OWB$WB_RT_WAREHOUSE_OBJECTS
ADD CONSTRAINT CO_FK_PARENT_CO FOREIGN KEY
(
PARENT_OBJECT_ID
)
REFERENCES OWB$WB_RT_WAREHOUSE_OBJECTS
(
WAREHOUSE_OBJECT_ID
)
ON DELETE CASCADE ENABLE
;

ALTER TABLE OWB$WB_RT_USER_VALUES
ADD CONSTRAINT UV_FK_SP FOREIGN KEY
(
STORE_PARAMETER_ID
)
REFERENCES OWB$WB_RT_STORE_PARAMS
(
STORE_PARAMETER_ID
)
ON DELETE CASCADE ENABLE
;

ALTER TABLE OWB$WB_RT_TASKS
ADD CONSTRAINT ET_FK_CO FOREIGN KEY
(
WAREHOUSE_OBJECT_ID
)
REFERENCES OWB$WB_RT_WAREHOUSE_OBJECTS
(
WAREHOUSE_OBJECT_ID
)
ON DELETE CASCADE ENABLE
;

ALTER TABLE OWB$WB_RT_TASK_CUSTOM_PARAMS
ADD CONSTRAINT TCP_FK_T FOREIGN KEY
(
TASK_ID
)
REFERENCES OWB$WB_RT_TASKS
(
TASK_ID
)
ON DELETE CASCADE ENABLE
;

ALTER TABLE OWB$WB_RT_STATE_VARIABLES
ADD CONSTRAINT TSV_FK_CO FOREIGN KEY
(
WAREHOUSE_OBJECT_ID
)
REFERENCES OWB$WB_RT_WAREHOUSE_OBJECTS
(
WAREHOUSE_OBJECT_ID
)
ON DELETE CASCADE ENABLE
;


ALTER TABLE "OWB$WB_RT_TASK_PARAM_DEFAULTS"
ADD CONSTRAINT "TPD_PK" PRIMARY KEY
(
"TASK_PARAMETER_DEFAULT_ID"
)
 ENABLE
;

ALTER TABLE OWB$WB_RT_TASK_PARAM_DEFAULTS
ADD CONSTRAINT "TPD_FK_T" FOREIGN KEY
(
TASK_ID
)
REFERENCES OWB$WB_RT_TASKS 
(
TASK_ID
) 
ON DELETE CASCADE ENABLE
;

ALTER TABLE OWB$WB_RT_TASK_PARAM_DEFAULTS
ADD CONSTRAINT "TPD_FK_CP" FOREIGN KEY 
(
CUSTOM_PARAMETER_ID
)
REFERENCES OWB$WB_RT_TASK_CUSTOM_PARAMS 
(
CUSTOM_PARAMETER_ID
)
ENABLE
;
 
ALTER TABLE OWB$WB_RT_TASK_PARAM_DEFAULTS
ADD CONSTRAINT "TPD_FK_SP" FOREIGN KEY 
(
SYSTEM_PARAMETER_ID
)
REFERENCES OWB$WB_RT_DEF_SYSTEM_PARAMS 
(
SYSTEM_PARAMETER_ID
)
ENABLE
;



CREATE INDEX WB_RT_IDX_SP_S ON OWB$WB_RT_STORE_PARAMS (STORE_ID ASC) TABLESPACE %tndex;
CREATE INDEX WB_RT_IDX_SP_W_S ON OWB$WB_RT_STORE_PARAMS (WORKSPACE_ID ASC, STORE_ID ASC) TABLESPACE %tndex;

CREATE INDEX WB_RT_IDX_WO_TS ON OWB$WB_RT_WAREHOUSE_OBJECTS (TGT_STORE_ID ASC) TABLESPACE %tndex;
CREATE INDEX WB_RT_IDX_WO_S ON OWB$WB_RT_WAREHOUSE_OBJECTS (STORE_ID ASC) TABLESPACE %tndex;
CREATE INDEX WB_RT_IDX_WO_PWO ON OWB$WB_RT_WAREHOUSE_OBJECTS (PARENT_OBJECT_ID ASC) TABLESPACE %tndex;
CREATE INDEX WB_RT_IDX_WO_W_TS ON OWB$WB_RT_WAREHOUSE_OBJECTS (WORKSPACE_ID ASC, TGT_STORE_ID ASC) TABLESPACE %tndex;
CREATE INDEX WB_RT_IDX_WO_W_S ON OWB$WB_RT_WAREHOUSE_OBJECTS (WORKSPACE_ID ASC, STORE_ID ASC) TABLESPACE %tndex;
CREATE INDEX WB_RT_IDX_WO_W_PWO ON OWB$WB_RT_WAREHOUSE_OBJECTS (WORKSPACE_ID ASC, PARENT_OBJECT_ID ASC) TABLESPACE %tndex;
CREATE INDEX WB_RT_IDX_WO_N ON OWB$WB_RT_WAREHOUSE_OBJECTS (PARENT_OBJECT_ID ASC,OBJECT_NAME ASC,STORE_ID ASC,OBJECT_TYPE_NAME ASC) TABLESPACE %tndex;

CREATE INDEX WB_RT_IDX_T_WO ON OWB$WB_RT_TASKS (WAREHOUSE_OBJECT_ID ASC) TABLESPACE %tndex;

CREATE INDEX WB_RT_IDX_T_EO ON OWB$WB_RT_TASKS (EXECUTION_OPERATOR_ID ASC) TABLESPACE %tndex;

CREATE INDEX WB_RT_IDX_TCP_T ON OWB$WB_RT_TASK_CUSTOM_PARAMS (TASK_ID ASC) TABLESPACE %tndex;

CREATE INDEX WB_RT_IDX_SV_T ON OWB$WB_RT_STATE_VARIABLES (WAREHOUSE_OBJECT_ID ASC) TABLESPACE %tndex;

CREATE INDEX "WB_RT_IDX_TPD_TCP" ON "OWB$WB_RT_TASK_PARAM_DEFAULTS" (CUSTOM_PARAMETER_ID ASC) TABLESPACE %tndex;

CREATE INDEX "WB_RT_IDX_TPD_DSP" ON "OWB$WB_RT_TASK_PARAM_DEFAULTS" (SYSTEM_PARAMETER_ID ASC) TABLESPACE %tndex;

CREATE UNIQUE INDEX WB_RT_PC_WS ON OWB$WB_RT_PLATFORM_CONFIG(workspace_id);


----------------------------------------------------------------------------
-- PLATFORM DEPLOYED FILES
----------------------------------------------------------------------------

create table owb$wb_rt_platform_files
(
  platform_file_id number(22) not null,
  object_uoid varchar2(32) not null,
  object_type_id number(22) not null,
  text clob,
  binary_data blob,
  mime_type varchar2(64) not null,
  encoding_type varchar2(64) not null,
  constraint pf_pk primary key (platform_file_id) using index tablespace %tndex,
  constraint pf_fk_dot foreign key (object_type_id) 
    references wb_rt_def_object_types (object_type_id),
  workspace_id number(11) DEFAULT sys_context('owb_workspace', 'workspaceId')
);

create index wb_rt_idx_pf_dot on owb$wb_rt_platform_files (object_type_id) tablespace %tndex;
create index wb_rt_idx_pf_wot on owb$wb_rt_platform_files (workspace_id, object_type_id) tablespace %tndex;

create view wb_rt_platform_files as select platform_file_id, object_uoid, object_type_id, text, binary_data, mime_type, encoding_type, workspace_id from owb$wb_rt_platform_files
where (workspace_id = wb_workspace_management.get_workspace_id or workspace_id = 0 or workspace_id is null) and wb_workspace_management.has_system_privilege_int('CONTROL_CENTER_VIEW') != 0;
  

----------------------------------------------------------------------------
-- INSERT SCHEMA TYPE PROPERTY
----------------------------------------------------------------------------

insert into wb_rt_platform_properties
(
  property_id,
  property_path,
  property_value,
  is_mutable
)
values
(
  wb_rt_platform_properties_seq.nextval,
  'property.RuntimePlatform.0.platform',
  'TRUE',
  0
);
