CREATE OR REPLACE PACKAGE wb_rt_profile_service AUTHID CURRENT_USER AS

COLUMNTYPE     NUMBER:= 0;
TABLETYPE      NUMBER:= 1;
PROFILETYPE    NUMBER:= 2;
BUSRULETYPE    NUMBER:= 3;

REGULARCOL     NUMBER:= 0;
RANKCOL        NUMBER:= 1;
DRANKCOL       NUMBER:= 2;
PATTERNCOL     NUMBER:= 3;
DATATYPECOL    NUMBER:= 4;
COMMONFORMAT   NUMBER:= 5;
LENGTHCOL      NUMBER:= 6;
PRECISIONCOL   NUMBER:= 7;
SCALECOL       NUMBER:= 8;

NULLVALUE      NUMBER:= 2;

type floatType is table of FLOAT index by BINARY_INTEGER;
type numberType is table of NUMBER index by BINARY_INTEGER;
type rowidType is table of VARCHAR2(2000) index by BINARY_INTEGER;
type varcharType is table of VARCHAR2(4000) index by BINARY_INTEGER;

PROCEDURE setupFKStructures(prfID IN NUMBER);
PROCEDURE doLoadingOperations(prfUOID IN VARCHAR2,prfID IN NUMBER,
  tabID IN NUMBER,auditID IN NUMBER);
PROCEDURE analyzeDomains(prfID IN NUMBER,tabID IN NUMBER,auditID IN NUMBER);
PROCEDURE analyzePatterns(prfID IN NUMBER,tabID IN NUMBER,auditID IN NUMBER);
FUNCTION getPropertyValue(propName IN VARCHAR2,objectID IN NUMBER,
  objectType IN NUMBER) RETURN VARCHAR2;
FUNCTION getNumberPropertyValue(propName IN VARCHAR2,objectID IN NUMBER,
  objectType IN NUMBER) RETURN NUMBER;
PROCEDURE deriveFunctionalDependencies(prfID IN NUMBER,tabID IN NUMBER);
PROCEDURE analyzeColumns(prfUOID IN VARCHAR2,prfID IN NUMBER,tabID IN NUMBER,
  auditID IN NUMBER);
FUNCTION createSample(tblID IN NUMBER,sampleSize IN NUMBER,type IN NUMBER) 
  RETURN VARCHAR2;
PROCEDURE createFKPartitions(prfID IN NUMBER);
PROCEDURE analyzeStructure(prfID IN NUMBER,tabID IN NUMBER,auditID IN NUMBER);
PROCEDURE analyzeProfileStructure(prfID IN NUMBER,fkreprofile IN NUMBER);
PROCEDURE createFKResults(datatypeStr IN VARCHAR2,prfID IN NUMBER);
PROCEDURE debugMsg(prfID IN NUMBER,msg IN CLOB);
PROCEDURE deriveRedundantColumns(prfID IN NUMBER);
PROCEDURE createPartitionedTables(prfID IN NUMBER);
PROCEDURE processFoundFDs(prfID IN NUMBER,tblID IN NUMBER);
PROCEDURE analyzeBusinessRules(prfUOID IN VARCHAR2,tabID IN NUMBER,
  auditID IN NUMBER);
PROCEDURE deriveCompositeForeignKeys(prfID IN NUMBER,tblID IN NUMBER);
FUNCTION executeStmt(stmt IN VARCHAR2,expectedRows IN NUMBER) RETURN NUMBER;
PROCEDURE derivePerfectForeignKeys(datatypeStr IN VARCHAR2,prfID IN NUMBER);
PROCEDURE testUKConstraints(prfUOID IN VARCHAR2,tblId IN NUMBER,error IN NUMBER);
PROCEDURE testFKConstraints(prfUOID IN VARCHAR2,tblId IN NUMBER,error IN NUMBER);
FUNCTION isDebug(prfID IN NUMBER) RETURN BOOLEAN;
END wb_rt_profile_service;
/
