Rem
Rem Copyright (c) 2000, 2008, Oracle and/or its affiliates.
Rem All rights reserved. 
Rem

----------------------------------------------------------------------------
-- PUBLIC DEPLOYMENT AUDIT VIEWS
----------------------------------------------------------------------------

create or replace view all_rt_audit_deployments
as
  select
    d.audit_deployment_id as deployment_audit_id,
    d.deployment_name as deployment_audit_name,
    d.number_of_units as number_of_units,
    d.runtime_version as runtime_version,
    d.client_version as client_version,
    d.client_repository as client_repository,
    d.client_repository_version as client_repository_version,
    d.client_repository_user as repository_user,
    d.generation_time as generation_time,
    wb_rt_constants.to_string(d.audit_status) as deployment_audit_status,
    d.number_of_script_errors as number_script_run_errors,
    d.number_of_script_warnings as number_script_run_warnings,
    d.creation_date as created_on,
    d.created_by as created_by,
    d.last_update_date as updated_on,
    d.last_updated_by as updated_by
  from      
    wb_rt_audit_deployments d
  with read only;


create or replace view all_rt_audit_locations
as
  select
    u.audit_unit_id as location_audit_id,
    d.runtime_version as runtime_version,
    d.client_version as client_version,
    d.client_repository as client_repository,
    d.client_repository_version as client_repository_version,
    d.client_repository_user as repository_user,
    d.generation_time as generation_time,
    d.audit_deployment_id as deployment_audit_id,
    u.unit_number as deployment_sequence_number,
    d.deployment_name as deployment_audit_name,
    u.unit_name as location_audit_name,
    wb_rt_constants.to_string(d.audit_status) as deployment_audit_status,
    wb_rt_constants.to_string(u.audit_status) as location_audit_status,
    u.store_uoid as location_uoid,
    u.store_name as location_name,
    st.store_type_name as location_type,
    decode(st.store_type_version, '0', null, st.store_type_version) as location_type_version,
    u.number_of_script_errors as number_script_run_errors,
    u.number_of_script_warnings as number_script_run_warnings,
    u.creation_date as created_on,
    u.created_by as created_by,
    u.last_update_date as updated_on,
    u.last_updated_by as updated_by
  from      
    wb_rt_audit_deployments d,
    wb_rt_audit_units u,
    wb_rt_def_deployment_adapters da,
    wb_rt_def_store_types st
  where
    d.audit_deployment_id = u.audit_deployment_id and
    u.deployment_adapter_id = da.deployment_adapter_id and
    da.store_type_id = st.store_type_id
  with read only;


create or replace view all_rt_audit_location_messages
as
  select
    m.audit_message_id as message_audit_id,
    m.audit_unit_id as location_audit_id,
    wb_rt_constants.to_string(m.severity) as message_severity,
    ml.line_number as message_line_number,
    decode(ml.plain_text, null, ml.nls_key, ml.plain_text) as message_text,
    m.creation_date as created_on,
    m.created_by as created_by
  from
    wb_rt_audit_messages m,
    wb_rt_audit_message_lines ml
  where
    m.audit_unit_id is not null and
    m.audit_message_id = ml.audit_message_id
  with read only;


create or replace view all_rt_audit_location_files
as
  select
    f.audit_file_id as file_audit_id,
    f.audit_unit_id as location_audit_id,
    ft.file_type_name as file_type,
    file_text as file_text,
    file_binary as file_binary,
    wb_rt_constants.FORMAT_TYPE(mime_type, encoding_type) as format,
    mime_type as mime_type,
    encoding_type as encoding_type,
    creation_date as created_on,
    created_by as created_by
  from
    wb_rt_audit_files f,
    wb_rt_def_file_types ft
  where
    f.audit_unit_id is not null and
    f.file_type_id = ft.file_type_id
  with read only;


create or replace view all_rt_audit_objects
as
  select
    o.audit_object_id as object_audit_id,
    o.parent_audit_object_id as parent_object_audit_id,
    o.audit_unit_id as location_audit_id,
    o.object_number as location_sequence_number,
    o.object_uoid as object_uoid,
    o.object_name as object_name,
    o.tgt_store_uoid as tgt_store_uoid,
    o.tgt_store_name as tgt_store_name,
    do.object_type_name as object_type,
    o.object_version_tag as version_tag,
    o.number_of_script_errors as number_script_run_errors,
    o.number_of_script_warnings as number_script_run_warnings,
    wb_rt_constants.to_string(o.final_object_status) as status_when_deployed,
    o.creation_date as created_on,
    o.created_by as created_by,
    o.last_update_date as updated_on,
    o.last_updated_by as updated_by
  from
    wb_rt_audit_objects o,
    wb_rt_def_object_types do
  where
    o.object_type_id = do.object_type_id
  with read only;


create or replace view all_rt_audit_script_runs
as
  select
    sr.audit_script_run_id as script_run_audit_id,
    decode(s.audit_unit_id, null, o.audit_unit_id, s.audit_unit_id) as location_audit_id,
    o.audit_object_id as object_audit_id,
    wb_rt_constants.to_string(sr.audit_status) as script_run_audit_status,
    wb_rt_constants.to_string(sr.operation) as operation,
    wb_rt_constants.to_string(s.action) as script_action,
    s.script as script,
    s.script_binary as script_binary,
    wb_rt_constants.FORMAT_TYPE(s.mime_type, s.encoding_type) as script_format,
    s.mime_type as script_mime_type,
    s.encoding_type as script_encoding_type,
    s.generation_time as script_generation_time,
    decode(ec.error_count, null, 0, ec.error_count) as number_script_run_errors,
    decode(wc.warning_count, null, 0, wc.warning_count) as number_script_run_warnings,
    sr.elapse as elapse_time,
    sr.external_audit_id as external_audit_id,
    sr.creation_date as created_on,
    sr.created_by as created_by,
    sr.last_update_date as updated_on,
    sr.last_updated_by as updated_by
  from
    wb_rt_audit_objects o,
    wb_rt_audit_scripts s,
    wb_rt_audit_script_runs sr,
    ( select 
        m.audit_script_run_id,
        count(*) as error_count
      from 
        wb_rt_audit_messages m
      where
        m.severity in (wb_rt_constants.SEVERITY_ERROR, wb_rt_constants.SEVERITY_RECOVERY)
      group by
        m.audit_script_run_id) ec,
    ( select 
        m.audit_script_run_id,
        count(*) as warning_count
      from 
        wb_rt_audit_messages m
      where
        m.severity in (wb_rt_constants.SEVERITY_WARNING)
      group by
        m.audit_script_run_id) wc            
  where
    o.audit_object_id(+) = s.audit_object_id and
    s.audit_script_id = sr.audit_script_id and
    ec.audit_script_run_id(+) = sr.audit_script_run_id and
    wc.audit_script_run_id(+) = sr.audit_script_run_id
  with read only;


create or replace view all_rt_audit_script_messages
as
  select
    m.audit_message_id as message_audit_id,
    m.audit_script_run_id as script_run_audit_id,
    wb_rt_constants.to_string(m.severity) as message_severity,
    ml.line_number as message_line_number,
    decode(ml.plain_text, null, ml.nls_key, ml.plain_text) as message_text,
    m.creation_date as created_on,
    m.created_by as created_by
  from
    wb_rt_audit_messages m,
    wb_rt_audit_message_lines ml
  where
    m.audit_script_run_id is not null and
    m.audit_message_id = ml.audit_message_id
  with read only;


create or replace view all_rt_audit_script_files
as
  select
    f.audit_file_id as file_audit_id,
    f.audit_script_run_id as script_run_audit_id,
    ft.file_type_name as file_type,
    file_text as file_text,
    file_binary as file_binary,
    wb_rt_constants.FORMAT_TYPE(mime_type, encoding_type) as format,
    mime_type as mime_type,
    encoding_type as encoding_type,
    creation_date as created_on,
    created_by as created_by
  from
    wb_rt_audit_files f,
    wb_rt_def_file_types ft
  where
    f.audit_script_run_id is not null and
    f.file_type_id = ft.file_type_id
  with read only;


----------------------------------------------------------------------------
-- PUBLIC EXECUTION AUDIT VIEWS
----------------------------------------------------------------------------

create or replace view all_rt_audit_executions
as
  select
    e.audit_execution_id as execution_audit_id,
    e.parent_audit_execution_id as parent_execution_audit_id,
    e.top_level_audit_execution_id as top_level_execution_audit_id,
    e.scope_audit_execution_id as scope_execution_audit_id,
    e.execution_name as execution_name,
    e.task_name as task_name,
    eo.operator_name as task_type,
    e.task_input as task_input,    
    e.task_input_binary as task_input_binary,
    e.task_input_mime_type as task_input_mime_type,
    e.task_input_encoding_type as task_input_encoding_type,
    e.execution_store_uoid as exec_location_uoid,
    e.execution_store_name as exec_location_name,
    eost.store_type_name as exec_location_type,
    decode(eost.store_type_version, '0', null, eost.store_type_version) as exec_location_type_version,
    e.execution_object_uoid as object_uoid,
    e.execution_object_name as object_name,
    eot.object_type_name as object_type,
    e.execution_object_store_uoid as object_location_uoid,
    e.execution_object_store_name as object_location_name,
    est.store_type_name as object_location_type,
    decode(est.store_type_version, '0', null, est.store_type_version) as object_location_type_version,
    e.return_result as return_result,
    e.return_result_number as return_result_number,
    e.return_code as return_code,
    wb_rt_constants.to_string(e.audit_status) as execution_audit_status,
    e.elapse as elapse_time,    
    e.number_of_task_errors as number_task_errors,
    e.number_of_task_warnings as number_task_warnings,    
    e.external_audit_id as external_audit_id,
    e.request_audit_id as request_audit_id,
    e.creation_date as created_on,
    e.created_by as created_by,
    e.last_update_date as updated_on,
    e.last_updated_by as updated_by
  from
    wb_rt_audit_executions e,
    wb_rt_def_object_types tot,
    wb_rt_def_store_types tst,
    wb_rt_def_execution_operators eo,
    wb_rt_def_execution_adapters ea,
    wb_rt_def_store_types eost,
    wb_rt_def_object_types eot,
    wb_rt_def_store_types est
  where
    e.task_object_type_id = tot.object_type_id(+) and
    e.task_object_store_type_id = tst.store_type_id(+) and
    e.execution_operator_id = eo.execution_operator_id(+) and
    eo.execution_adapter_id = ea.execution_adapter_id(+) and
    ea.store_type_id = eost.store_type_id(+) and
    e.execution_object_type_id = eot.object_type_id(+) and
    e.execution_object_store_type_id = est.store_type_id(+)
  with read only;


create or replace view all_rt_audit_execution_params
as
  select
    audit_parameter_id as parameter_audit_id,
    audit_execution_id as execution_audit_id,
    parameter_uoid as custom_parameter_uoid,
    parameter_name as parameter_name,
    wb_rt_constants.to_string(parameter_type) as parameter_type,
    wb_rt_constants.to_string(parameter_kind) as parameter_kind,
    wb_rt_constants.to_string(parameter_mode) as parameter_mode,
    wb_rt_constants.to_string(parameter_scope) as parameter_scope,
    decode(value_mode, wb_rt_constants.PARAM_VALUE_INPUT, 'INPUT_VALUE',
      wb_rt_constants.PARAM_VALUE_OUTPUT, 'OUTPUT_VALUE', null) as value_kind,
    value as value,
    clob_value as clob_value
  from
    wb_rt_audit_parameters
  with read only;


create or replace view all_rt_audit_exec_messages
as
  select
    m.audit_message_id as message_audit_id,
    m.audit_execution_id as execution_audit_id,
    wb_rt_constants.to_string(m.severity) as message_severity,
    ml.line_number as message_line_number,
    decode(ml.plain_text, null, ml.nls_key, ml.plain_text) as message_text,
    m.creation_date as created_on,
    m.created_by as created_by
  from
    wb_rt_audit_messages m,
    wb_rt_audit_message_lines ml
  where
    m.audit_execution_id is not null and
    m.audit_message_id = ml.audit_message_id
  with read only;


create or replace view all_rt_audit_exec_files
as
  select
    f.audit_file_id as file_audit_id,
    f.audit_execution_id as execution_audit_id,
    ft.file_type_name as file_type,
    file_text as file_text,
    file_binary as file_binary,
    wb_rt_constants.FORMAT_TYPE(mime_type, encoding_type) as format,
    mime_type as mime_type,
    encoding_type as encoding_type,
    creation_date as created_on,
    created_by as created_by
  from
    wb_rt_audit_files f,
    wb_rt_def_file_types ft
  where
    f.audit_execution_id is not null and
    f.file_type_id = ft.file_type_id
  with read only;

create or replace view all_rt_audit_map_runs
as
  select
    a.rta_iid as map_run_id,
    a.rte_id as execution_audit_id,
    a.rta_lob_uoid as map_uoid,
    replace(a.rta_lob_name,'"') as map_name,
    a.rta_type as map_type,
    a.creation_date as start_time,
    a.creation_date + (a.rta_elapse/86400) as end_time,
    a.rta_elapse as elapse_time,
    decode(a.rta_status, 0, 'RUNNING', 2, 'FAILURE', 'COMPLETE') as run_status,
    a.rta_physical_name as physical_name,
    a.rta_load_date as load_date,
    a.rta_load_time as load_time,
    replace(a.rta_primary_source,'"') as source_list,
    replace(a.rta_primary_target,'"') as target_list,
    decode(a.rta_errors, null, 0, a.rta_errors) as number_errors,
    decode(a.rta_logical_errors, null, 0, a.rta_logical_errors) as number_logical_errors,
    a.rta_select as number_records_selected,
    a.rta_insert as number_records_inserted,
    a.rta_update as number_records_updated,
    a.rta_delete as number_records_deleted,
    a.rta_discarded as number_records_discarded,
    a.rta_merge as number_records_merged,
    a.rta_corrections as number_records_corrected,
    a.creation_date as created_on,
    a.created_by as created_by,
    a.last_update_date as updated_on,
    a.last_updated_by as updated_by
  from
    wb_rt_audit a
  with read only;

create or replace view all_rt_audit_map_run_sources
as
  select
    a.rta_iid as map_run_id,
    decode(instr(s.xx,'@'),0,s.xx,substr(s.xx,1,instr(s.xx,'@')-1)) as source_name,
    decode(instr(s.xx,'@'),0,null,substr(s.xx,instr(s.xx,'@')+1)) as source_dblink
  from
    wb_rt_audit a,
    (select rta_iid as id,
            replace(substr(rta_primary_source,1,decode(instr(rta_primary_source,','),0,
                    length(rta_primary_source),instr(rta_primary_source,',')-1)),'"') as xx
     from wb_rt_audit
     where rta_primary_source is not null
     UNION
     select rta_iid as id,
            replace(substr(rta_primary_source,instr(rta_primary_source,',')+1,
                    decode(instr(rta_primary_source,',',1,2),0,length(rta_primary_source),
                    instr(rta_primary_source,',',1,2)-1) - instr(rta_primary_source,',')),'"') as xx
     from wb_rt_audit
     where instr(rta_primary_source,',') != 0
     UNION
     select rta_iid as id,
            replace(substr(rta_primary_source,instr(rta_primary_source,',',1,2)+1,
                    decode(instr(rta_primary_source,',',1,3),0,length(rta_primary_source),
                    instr(rta_primary_source,',',1,3)-1) - instr(rta_primary_source,',',1,2)),'"') as xx
     from wb_rt_audit
     where instr(rta_primary_source,',',1,2) != 0
     UNION
     select rta_iid as id,
            replace(substr(rta_primary_source,instr(rta_primary_source,',',1,3)+1,
                    decode(instr(rta_primary_source,',',1,4),0,length(rta_primary_source),
                    instr(rta_primary_source,',',1,4)-1) - instr(rta_primary_source,',',1,3)),'"') as xx
     from wb_rt_audit
     where instr(rta_primary_source,',',1,3) != 0
     UNION
     select rta_iid as id,
            replace(substr(rta_primary_source,instr(rta_primary_source,',',1,4)+1,
                    decode(instr(rta_primary_source,',',1,5),0,length(rta_primary_source),
                    instr(rta_primary_source,',',1,5)-1) - instr(rta_primary_source,',',1,4)),'"') as xx
     from wb_rt_audit
     where instr(rta_primary_source,',',1,4) != 0
    ) s
  where
    s.id = a.rta_iid
  with read only;

create or replace view all_rt_audit_map_run_targets
as
  select
    a.rta_iid as map_run_id,
    decode(instr(t.xx,'@'),0,t.xx,substr(t.xx,1,instr(t.xx,'@')-1)) as target_name
  from
    wb_rt_audit a,
    (select rta_iid as id,
        replace(substr(rta_primary_target,1,decode(instr(rta_primary_target,','),0,
                length(rta_primary_target),instr(rta_primary_target,',')-1)),'"') as xx
     from wb_rt_audit
     where rta_primary_target is not null
     UNION
     select rta_iid as id,
            replace(substr(rta_primary_target,instr(rta_primary_target,',')+1,
                    decode(instr(rta_primary_target,',',1,2),0,length(rta_primary_target),
                    instr(rta_primary_target,',',1,2)-1) - instr(rta_primary_target,',')),'"') as xx
     from wb_rt_audit
     where instr(rta_primary_target,',') != 0
     UNION
     select rta_iid as id,
            replace(substr(rta_primary_target,instr(rta_primary_target,',',1,2)+1,
                    decode(instr(rta_primary_target,',',1,3),0,length(rta_primary_target),
                    instr(rta_primary_target,',',1,3)-1) - instr(rta_primary_target,',',1,2)),'"') as xx
     from wb_rt_audit
     where instr(rta_primary_target,',',1,2) != 0
     UNION
     select rta_iid as id,
            replace(substr(rta_primary_target,instr(rta_primary_target,',',1,3)+1,
                    decode(instr(rta_primary_target,',',1,4),0,length(rta_primary_target),
                    instr(rta_primary_target,',',1,4)-1) - instr(rta_primary_target,',',1,3)),'"') as xx
     from wb_rt_audit
     where instr(rta_primary_target,',',1,3) != 0
     UNION
     select rta_iid as id,
            replace(substr(rta_primary_target,instr(rta_primary_target,',',1,4)+1,
                    decode(instr(rta_primary_target,',',1,5),0,length(rta_primary_target),
                    instr(rta_primary_target,',',1,5)-1) - instr(rta_primary_target,',',1,4)),'"') as xx
     from wb_rt_audit
     where instr(rta_primary_target,',',1,4) != 0
    ) t
  where
    t.id = a.rta_iid
  with read only;

create or replace view all_rt_audit_step_runs
as
  select
    d.rtd_iid as step_id,
    d.rta_iid as map_run_id,
    d.rtd_step as map_step,
    replace(decode(instr(d.rtd_name,'_',-1),0,d.rtd_name,
                   decode(rtrim(substr(d.rtd_name,instr(d.rtd_name,'_',-1)),'" '),
                          '_Bat',substr(d.rtd_name,1,instr(d.rtd_name,'_',-1)-1),
                          '_p',substr(d.rtd_name,1,instr(d.rtd_name,'_',-1)-1),
                          '_t',substr(d.rtd_name,1,instr(d.rtd_name,'_',-1)-1),d.rtd_name)),'"') as step_name,
    decode(instr(d.rtd_name,'_',-1),0,null,
           decode(rtrim(substr(d.rtd_name,instr(d.rtd_name,'_',-1)),'" '),
                  '_Bat','Set-based','_p','Row-based','_t','Row-based (target)',null)) as step_type,
    d.creation_date as start_time,
    d.creation_date + (d.rtd_elapse/86400) as end_time,
    d.rtd_elapse as elapse_time,
    decode(d.rtd_status, 0, 'RUNNING', 'COMPLETE') as run_status,
    replace(d.rtd_source,'"') as source_list,
    replace(d.rtd_target,'"') as target_list,
    decode(d.rtd_errors, null, 0 ,d.rtd_errors) as number_errors,
    decode(d.rtd_logical_errors, null, 0 ,d.rtd_logical_errors) as number_logical_errors,
    d.rtd_select as number_records_selected,
    d.rtd_insert as number_records_inserted,
    d.rtd_update as number_records_updated,
    d.rtd_delete as number_records_deleted,
    d.rtd_discarded as number_records_discarded,
    d.rtd_merge as number_records_merged,
    d.rtd_corrections as number_records_corrected,
    d.creation_date as created_on,
    d.created_by as created_by,
    d.last_update_date as updated_on,
    d.last_updated_by as updated_by
  from
    wb_rt_audit_detail d
  with read only;

create or replace view all_rt_audit_step_run_sources
as
  select
    d.rtd_iid as step_id,
    d.rta_iid as map_run_id,
    d.rtd_step as map_step,
    decode(instr(s.xx,'@'),0,s.xx,substr(s.xx,1,instr(s.xx,'@')-1)) as source_name,
    decode(instr(s.xx,'@'),0,null,substr(s.xx,instr(s.xx,'@')+1)) as source_dblink
  from
    wb_rt_audit_detail d,
    (select rtd_iid as id,
            replace(substr(rtd_source,1,decode(instr(rtd_source,','),0,
                    length(rtd_source),instr(rtd_source,',')-1)),'"') as xx
     from wb_rt_audit_detail
     where rtd_source is not null
     UNION
     select rtd_iid as id,
            replace(substr(rtd_source,instr(rtd_source,',')+1,
                    decode(instr(rtd_source,',',1,2),0,length(rtd_source),
                    instr(rtd_source,',',1,2)-1) - instr(rtd_source,',')),'"') as xx
     from wb_rt_audit_detail
     where instr(rtd_source,',') != 0
     UNION
     select rtd_iid as id,
            replace(substr(rtd_source,instr(rtd_source,',',1,2)+1,
                    decode(instr(rtd_source,',',1,3),0,length(rtd_source),
                    instr(rtd_source,',',1,3)-1) - instr(rtd_source,',',1,2)),'"') as xx
     from wb_rt_audit_detail
     where instr(rtd_source,',',1,2) != 0
     UNION
     select rtd_iid as id,
            replace(substr(rtd_source,instr(rtd_source,',',1,3)+1,
                    decode(instr(rtd_source,',',1,4),0,length(rtd_source),
                    instr(rtd_source,',',1,4)-1) - instr(rtd_source,',',1,3)),'"') as xx
     from wb_rt_audit_detail
     where instr(rtd_source,',',1,3) != 0
     UNION
     select rtd_iid as id,
            replace(substr(rtd_source,instr(rtd_source,',',1,4)+1,
                    decode(instr(rtd_source,',',1,5),0,length(rtd_source),
                    instr(rtd_source,',',1,5)-1) - instr(rtd_source,',',1,4)),'"') as xx
     from wb_rt_audit_detail
     where instr(rtd_source,',',1,4) != 0
    ) s
  where
    s.id = d.rtd_iid
  with read only;

create or replace view all_rt_audit_step_run_targets
as
  select
    d.rtd_iid as step_id,
    d.rta_iid as map_run_id,
    d.rtd_step as map_step,
    decode(instr(t.xx,'@'),0,t.xx,substr(t.xx,1,instr(t.xx,'@')-1)) as target_name
  from
    wb_rt_audit_detail d,
    (select rtd_iid as id,
        replace(substr(rtd_target,1,decode(instr(rtd_target,','),0,
                length(rtd_target),instr(rtd_target,',')-1)),'"') as xx
     from wb_rt_audit_detail
     where rtd_target is not null
     UNION
     select rtd_iid as id,
            replace(substr(rtd_target,instr(rtd_target,',')+1,
                    decode(instr(rtd_target,',',1,2),0,length(rtd_target),
                    instr(rtd_target,',',1,2)-1) - instr(rtd_target,',')),'"') as xx
     from wb_rt_audit_detail
     where instr(rtd_target,',') != 0
     UNION
     select rtd_iid as id,
            replace(substr(rtd_target,instr(rtd_target,',',1,2)+1,
                    decode(instr(rtd_target,',',1,3),0,length(rtd_target),
                    instr(rtd_target,',',1,3)-1) - instr(rtd_target,',',1,2)),'"') as xx
     from wb_rt_audit_detail
     where instr(rtd_target,',',1,2) != 0
     UNION
     select rtd_iid as id,
            replace(substr(rtd_target,instr(rtd_target,',',1,3)+1,
                    decode(instr(rtd_target,',',1,4),0,length(rtd_target),
                    instr(rtd_target,',',1,4)-1) - instr(rtd_target,',',1,3)),'"') as xx
     from wb_rt_audit_detail
     where instr(rtd_target,',',1,3) != 0
     UNION
     select rtd_iid as id,
            replace(substr(rtd_target,instr(rtd_target,',',1,4)+1,
                    decode(instr(rtd_target,',',1,5),0,length(rtd_target),
                    instr(rtd_target,',',1,5)-1) - instr(rtd_target,',',1,4)),'"') as xx
     from wb_rt_audit_detail
     where instr(rtd_target,',',1,4) != 0
    ) t
  where
    t.id = d.rtd_iid
  with read only;

create or replace view all_rt_audit_step_run_structs
as
  select
    t.rtt_iid as struct_id,
    t.rtd_iid as step_id,
    d.rta_iid as map_run_id,
    t.rtt_parent_operator_uoid as parent_operator_uoid,
    t.rtt_parent_object_uoid as parent_object_uoid,
    t.rtt_parent_object_type as parent_object_type,
    t.rtt_parent_object_loc_uoid as parent_object_location_uoid,
    t.rtt_parent_object_name as parent_object_name,
    t.rtt_object_uoid as object_uoid,
    t.rtt_object_type as object_type,
    t.rtt_object_loc_uoid as object_location_uoid,
    t.rtt_object_name as object_name,
    t.creation_date as created_on,
    t.created_by as created_by,
    t.last_update_date as updated_on,
    t.last_updated_by as updated_by
  from
    wb_rt_audit_struct t, wb_rt_audit_detail d
  where t.rtd_iid = d.rtd_iid
  with read only;

create or replace view all_rt_audit_proc_run_errors
as
  select
    e.rte_iid as run_error_id,
    e.rta_iid as map_run_id,
    e.rte_rowkey as cursor_rowkey,
    e.rte_sqlerr as run_error_number,
    e.rte_sqlerrm as run_error_message,
    replace(decode(instr(e.rte_dest_table,'@'),0,e.rte_dest_table,
            substr(e.rte_dest_table,1,instr(e.rte_dest_table,'@')-1)),'"') as target_name,
    replace(e.rte_dest_column,'"') as target_column,
    e.rte_statement as statement,
    e.creation_date as created_on,
    e.created_by as created_by,
    e.last_update_date as updated_on,
    e.last_updated_by as updated_by
  from
    wb_rt_errors e
  where
    e.rtd_iid is null
  with read only;

create or replace view all_rt_audit_map_run_errors
as
  select
    e.rte_iid as run_error_id,
    e.rtd_iid as step_id,
    e.rta_iid as map_run_id,
    e.rta_step as map_step,
    e.rte_rowkey as cursor_rowkey,
    e.rte_sqlerr as run_error_number,
    e.rte_sqlerrm as run_error_message,
    replace(decode(instr(e.rte_dest_table,'@'),0,e.rte_dest_table,
            substr(e.rte_dest_table,1,instr(e.rte_dest_table,'@')-1)),'"') as target_name,
    replace(e.rte_dest_column,'"') as target_column,
    e.rte_statement as statement,
    e.creation_date as created_on,
    e.created_by as created_by,
    e.last_update_date as updated_on,
    e.last_updated_by as updated_by
  from
    wb_rt_errors e
  where
    e.rtd_iid is not null
  with read only;  

create or replace view all_rt_audit_map_run_trace
as
  select
    f.rtf_iid as trace_id,
    f.rta_iid as map_run_id,
    f.rtf_step as map_step,
    f.rte_rowkey as cursor_rowkey,
    f.rte_status as type,
    f.rtf_role as role,
    f.rtf_action as action,
    replace(decode(instr(f.rtf_table_name,'@'),0,f.rtf_table_name,
            substr(f.rtf_table_name,1,instr(f.rtf_table_name,'@')-1)),'"') as table_name,
    f.creation_date as created_on,
    f.created_by as created_by,
    f.last_update_date as updated_on,
    f.last_updated_by as updated_by
  from
    wb_rt_feedback f
  with read only;

