Rem
Rem Copyright (c) 2000, 2009, Oracle and/or its affiliates.
Rem All rights reserved. 
Rem

create or replace package wb_rt_script_util as
  TYPE START_SERVICE_REC IS RECORD
  (
    available number(22),
    message varchar2(4000)
  );

  TYPE LIST_REQUESTS_REC IS RECORD
  (
    audit_id varchar2(30),
    audit_status varchar2(30),
    job_name varchar2(64),
    job_date varchar2(30),
    job_owner varchar2(30)
  );

  TYPE LIST_REQUESTS_TAB IS TABLE OF
    LIST_REQUESTS_REC
    INDEX BY BINARY_INTEGER;

  TYPE RTREPOS_LOCATIONS_REC IS RECORD
  (
    loc_name varchar2(64),
    loc_type_version varchar2(130),
    loc_connection varchar2(4000),
    deploy_type varchar2(10),
    workspace varchar(255)
  );

  TYPE RTREPOS_LOCATIONS_TAB IS TABLE OF
    RTREPOS_LOCATIONS_REC
    INDEX BY BINARY_INTEGER;

  TYPE RTREPOS_NODES_REC IS RECORD
  (
    rt_version varchar2(4000),
    rt_connection varchar2(526),
    server_side_home varchar2(4000),
    install_home varchar2(255)
  );

  TYPE RTREPOS_NODES_TAB IS TABLE OF
    RTREPOS_NODES_REC
    INDEX BY BINARY_INTEGER;

  procedure abort_exec_request
  (
    p_audit_id in number
  );

  procedure abort_unit_request
  (
    p_audit_id in number
  );

  function count_job_queue_processes
  return number;

  function count_nls_messages
  return number;

  function count_platform_locations
  return number;

  function count_platform_properties
  return number;

  function count_user_errors
  return number;

  procedure deactivate_all
  ;

  procedure deactivate_deployment
  (
    p_audit_id in number
  );

  procedure deactivate_execution
  (
    p_audit_id in number
  );

  procedure delete_warehouse_object
  (
    p_object_name in varchar2,
    p_location_name in varchar2
  );

  procedure expedite_exec_request
  (
    p_audit_id in number,
    p_return_number number,
    p_return_code number
  );

  function get_platform_property
  (
    p_property_name in varchar2
  )
  return clob;

  function get_rtrepos_locations
  return RTREPOS_LOCATIONS_TAB;

  function get_rtrepos_nodes
  return RTREPOS_NODES_TAB;

  function list_deployment_requests
  return LIST_REQUESTS_TAB;

  function list_execution_requests
  return LIST_REQUESTS_TAB;

  function list_unit_requests
  return LIST_REQUESTS_TAB;

  function purge_audit_data
  (
    p_audit_type in varchar2,
    p_sql_predicate in varchar2,
    p_start_date in date,
    p_end_date in date,
    p_date_mask in varchar2
  )
  return varchar2;

  procedure reset_repository
  (
    p_password in varchar2
  );

  function run_task
  (
    p_location_name in varchar2,
    p_task_type in varchar2,
    p_task_name in varchar2,
    p_custom_params in varchar2 default null,
    p_system_params in varchar2 default null,
    p_oem_friendly in number default 0,
    p_owb_background in number default 0
  )
  return number;

  procedure set_ccs_home
  (
    p_instance in number,
    p_version in varchar2,
    p_ss_home in varchar2
  );

  procedure set_platform_property
  (
    p_property_name in varchar2,
    p_property_value in varchar2
  );

  procedure set_repository_password
  (
    p_password in varchar2
  );

  procedure set_workspace
  (
    p_workspace_name in varchar2
  );

  function show_service
  return number;

  function start_service
  return START_SERVICE_REC;

  function start_service_nv
  return START_SERVICE_REC;

  function stop_service
  return number;

  function service_status
  return varchar2;

  function get_platform_uoid
  return varchar2;

end wb_rt_script_util;
/

