Rem
Rem Copyright (c) 2000, 2007, Oracle. All rights reserved.  
Rem

create or replace package wb_rt_service_control is

  procedure initialize_platform
  (
    p_active_node in number,
    p_clean_queues in number
  );

  procedure prepare_unit_done
  (
    p_audit_unit_id in number,
    p_ops_enabled in number
  );
  
  procedure unprepare_unit_done
  (
    p_audit_unit_id in number,
    p_ops_enabled in number
  );
  
  procedure deploy_unit_done
  (
    p_audit_unit_id in number,
    p_ops_enabled in number
  );
  
  procedure undo_unit_done
  (
    p_audit_unit_id in number,
    p_ops_enabled in number
  );
  
  procedure finalize_unit_done
  (
    p_audit_unit_id in number
  ); 
    
  procedure set_current_unit_op_aborted
  (
    p_audit_unit_id in number
  ); 
    
  procedure force_deployment_deactivation
  (
    p_audit_deployment_id in number
  );
  
  function get_parent_execution
  (
    p_audit_execution_id in number
  ) return number;

  procedure execute_done
  (
    p_audit_execution_id in number
  );
    
  procedure set_current_execution_aborted
  (
    p_audit_execution_id in number
  ); 

  procedure force_execute_deactivation
  (
    p_audit_execution_id in number
  );

  procedure wait
  (
    p_request_type out number, 
    p_focus_id out number,
    p_timeout in number
  );

  function encrypt_to_hex
  (
    p_data in varchar2, 
    p_key in varchar2
  ) return varchar2;

  function decrypt_from_hex
  (
    p_data in varchar2, 
    p_key in varchar2
  ) return varchar2;

end wb_rt_service_control;
/

