Rem
Rem Copyright (c) 2000 by Oracle Corporation
Rem

create or replace package wb_rt_service_management is

  function is_rac return number;
  
  function get_platform_net_service_name return varchar2;
  
  procedure set_platform_net_service_name
  (
    p_new_value in varchar2
  );
  
  procedure remove_node
  (
    p_node_id in number
  );

  function add_node
  (
    p_instance_number in number
  ) return number;

  procedure enable_all
  (
    p_startup_type in number := wb_rt_constants.STARTUP_KIND_MANUAL
  );

  procedure enable_node
  (
    p_node_id in number,
    p_startup_type in number := wb_rt_constants.STARTUP_KIND_MANUAL
  );

  procedure disable_all;

  procedure disable_node
  (
    p_node_id in number
  );

  procedure client_mode_closedown;

  procedure set_instance_number
  (
    p_node_id in number, 
    p_instance_number in number
  );

  procedure set_connect_spec
  (
    p_node_id in number, 
    p_connect_spec in varchar2
  );

  function get_host
  (
    p_node_id in number
  ) return varchar2;

  function get_port
  (
    p_node_id in number
  ) return varchar2;

  function get_service_name
  (
    p_node_id in number
  ) return varchar2;

  procedure set_server_side_home
  (
    p_node_id in number, 
    p_server_side_home in varchar2
  );

end wb_rt_service_management;
/


