Rem
Rem Copyright (c) 2000, 2008, Oracle and/or its affiliates. All rights reserved.
Rem

----------------------------------------------------------------------------
-- PLATFORM DEFINITION VIEWS
----------------------------------------------------------------------------

create or replace view wb_rtv_binary_context_attrs
as
  select
    audit_id,
    upper(attr_name) as attr_name,
    attr_value
  from
    wb_rt_binary_context_attrs
  with read only;

create or replace view wb_rtv_textual_context_attrs
as
  select
    audit_id,
    upper(attr_name) as attr_name,
    attr_value
  from
    wb_rt_textual_context_attrs
  with read only;

----------------------------------------------------------------------------
-- SERVICE NODES
----------------------------------------------------------------------------
          
create or replace view wb_rtv_service_nodes
as
  select 
    n.node_id,
    n.instance_number,
    i.inst_name as instance_name,
    n.connect_spec,
    wb_rt_service_management.get_host(n.node_id) as host,
    wb_rt_service_management.get_port(n.node_id) as port,
    wb_rt_service_management.get_service_name(n.node_id) as service_name,
    n.enabled,
    n.runtime_version,
    n.server_side_home,
    decode(f.active_node, n.node_id, 1, 0) as currently_active
  from
    wb_rt_service_nodes n,
    wb_rt_service_control_flags f,
    v$active_instances i
  where
    n.instance_number = i.inst_number (+);

create or replace view wb_rtv_installed_services
as
  select
    owbsys.owbrtps_key_to_instance(r.key) as instance_number,
    i.inst_name as instance_name,    
    owbsys.owbrtps_key_to_version_string(r.key) as runtime_version
  from
    owbsys.owbrtps r,
    v$active_instances i
  where
    owbsys.owbrtps_key_to_instance(r.key) = i.inst_number (+);
    
----------------------------------------------------------------------------
-- SERVICE RELATED FUNCTIONS/PROCEDURES
----------------------------------------------------------------------------

create or replace procedure service_available(l_available out number) as

  l_lockhandle varchar2(128);
  l_status number;
  l_timeout integer := 0;
  l_platform varchar2(30);
begin

  select sys_context('USERENV', 'CURRENT_USER') into l_platform from dual;
  dbms_lock.allocate_unique('WBLK_' || l_platform, l_lockhandle);
  l_status := dbms_lock.request(l_lockhandle, dbms_lock.x_mode, l_timeout, true);
  if l_status = 0
  then
    l_status := dbms_lock.release(l_lockhandle);
    l_available := 0;

  else
    l_available := 1;
  end if;

end;
/

