Rem
Rem Copyright (c) 2000, 2008, Oracle and/or its affiliates.
Rem All rights reserved. 
Rem

create or replace package wb_rt_store_registration is

  function register_store
  (
    p_store_type_id in number,
    p_store_uoid in varchar2,
    p_store_name in varchar2,
    p_deployment_target in number,
    p_owner_uoid in varchar2 := null,
    p_version_tag in varchar2 := null
  ) 
  return number;
    
  procedure update_store_uoids
  (
    p_store_id in number,
    p_store_uoid in varchar2,
    p_owner_uoid in varchar2
  );
  
  procedure update_local_flag
  (
    p_store_id in number,
    p_is_local in number
  );
  
  procedure update_target_flag
  (
    p_store_id in number,
    p_is_target in number
  );
    
  procedure register_store_parameter
  (
    p_store_id in number,
    p_parameter_name in varchar2,
    p_parameter_value in varchar2,
    p_force in number := 0
  );
  
  function is_user_value_registered
  (
    p_store_id in number,
    p_parameter_name in varchar2
  )
  return number;
  
  function get_user_value
  (
    p_store_id in number,
    p_parameter_name in varchar2
  )
  return varchar2;
  
  function check_user_value
  (
    p_store_id in number,
    p_parameter_name in varchar2,
    p_value in varchar2
  )
  return number;
  
  procedure unregister_store
  (
    p_store_id in number
  );

  procedure database_store_global_name
  (
    p_store_name in varchar2, 
    p_global_name out varchar2
  );

  procedure valid_net_service_name
  (
    p_net_service_name in varchar2, 
    p_user in varchar2,
    p_password in varchar2,
    p_result out number
  );
  
  function getRegWorkspaceForLocalSchema
  (
    p_schema in varchar2
  )
  return varchar2;  
  
  function getReposUOID
  return varchar2;

  function get_store_parameter_value
  (
    p_store_id in number, 
    p_parameter_name in varchar2 
  ) return varchar2; 

  function get_store_parameter_value
  (
    p_store_uoid in varchar2, 
    p_parameter_name in varchar2 
  ) return varchar2; 

  procedure remove_user_value
  (
    p_store_id in number,
    p_parameter_name in varchar2
  );

  procedure remove_user_values
  (
    p_store_id in number
  );

end wb_rt_store_registration;
/

