Rem
Rem Copyright (c) 2000, 2006, Oracle. All rights reserved.  
Rem

----------------------------------------------------------------------------
-- SEQUENCES
----------------------------------------------------------------------------

create sequence wb_rt_system_metadata_seq start with 1 increment by 1 order;

----------------------------------------------------------------------------
-- PLATFORM DEFINITION TABLES
----------------------------------------------------------------------------

create table wb_rt_def_store_types
(
  store_type_id number(22) not null,
  store_type_name varchar2(64) not null,
  store_type_version varchar2(64) null, 
  display_name varchar2(64) not null,
  constraint dst_pk primary key (store_type_id) using index tablespace %tndex,
  constraint dst_uk unique (store_type_name, store_type_version) using index tablespace %tndex
);

create table wb_rt_def_store_type_params
(
  store_type_param_id number(22) not null,
  store_type_id number(22) not null,
  parameter_name varchar2(64) not null,
  display_name varchar2(64) not null,
  access_restricted number(1) not null,
  force_upper_case number(1) not null,
  mutable_when_not_empty number(1) not null,
  access_mode number(8) not null,
  constraint dstp_pk primary key (store_type_param_id) using index tablespace %tndex,
  constraint dstp_fk_dst foreign key (store_type_id) 
    references wb_rt_def_store_types (store_type_id) on delete cascade, 
  constraint dstp_uk unique (store_type_id, parameter_name) using index tablespace %tndex
);

create index wb_rt_idx_stp_st on wb_rt_def_store_type_params (store_type_id) tablespace %tndex;

create table wb_rt_def_deployment_adapters
(
  deployment_adapter_id number(22) not null,
  store_type_id number(22) not null,
  adapter_name varchar2(64) not null,
  does_undo number(1) not null,
  does_upgrade number(1) not null,
  minimum_compatible_version varchar2(32) not null,
  constraint dda_pk primary key (deployment_adapter_id) using index tablespace %tndex,
  constraint dda_fk_dst foreign key (store_type_id) 
    references wb_rt_def_store_types (store_type_id) on delete cascade, 
  constraint dda_uk unique (store_type_id, adapter_name) using index tablespace %tndex
);

create index wb_rt_idx_da_st on wb_rt_def_deployment_adapters (store_type_id) tablespace %tndex;

create table wb_rt_def_object_type_defs
(
  object_type_def_id number(22) not null,
  store_type_id number(22) not null,
  object_type_name varchar2(64) not null,
  default_exists_action number(8) null,
  default_not_exists_action number(8) null,
  default_create_adapter number(22) null,
  default_upgrade_adapter number(22) null,
  default_drop_adapter number(22) null,
  constraint ddd_pk primary key (object_type_def_id) using index tablespace %tndex,
  constraint dddd_fk_dst foreign key (store_type_id) 
    references wb_rt_def_store_types (store_type_id) on delete cascade, 
  constraint ddd_fk_create_dda foreign key (default_create_adapter) 
    references wb_rt_def_deployment_adapters (deployment_adapter_id) on delete set null,
  constraint ddd_fk_upgrade_dda foreign key (default_upgrade_adapter) 
    references wb_rt_def_deployment_adapters (deployment_adapter_id) on delete set null,
  constraint ddd_fk_drop_dda foreign key (default_drop_adapter) 
    references wb_rt_def_deployment_adapters (deployment_adapter_id) on delete set null,
  constraint ddd_uk unique (store_type_id, object_type_name) using index tablespace %tndex
);    

create index wb_rt_idx_dotd_st on wb_rt_def_object_type_defs (store_type_id) tablespace %tndex;

create table wb_rt_def_object_types
(
  object_type_id number(22) not null,
  deployment_adapter_id number(22) not null,
  parent_object_type_id number(22) null,
  object_type_name varchar2(64) not null,
  adapter_creates number(1) not null,
  adapter_upgrades number(1) not null,
  adapter_drops number(1) not null,
  is_create_repeatable number(1) not null,
  is_data_object number(1) not null,
  constraint ddo_pk primary key (object_type_id) using index tablespace %tndex,
  constraint ddo_fk_dda foreign key (deployment_adapter_id) 
    references wb_rt_def_deployment_adapters (deployment_adapter_id) on delete cascade,
  constraint ddo_fk_parent_ddo foreign key (parent_object_type_id) 
    references wb_rt_def_object_types (object_type_id) on delete cascade,
  constraint ddo_uk unique (deployment_adapter_id, parent_object_type_id, object_type_name) using index tablespace %tndex
);

create index wb_rt_idx_dot_dda on wb_rt_def_object_types (deployment_adapter_id) tablespace %tndex;

create table wb_rt_def_impl_types
(
  impl_type_id number(22) not null,
  object_type_id number(22) not null,
  impl_type_name varchar2(64) not null,
  constraint ddi_pk primary key (impl_type_id) using index tablespace %tndex,
  constraint ddi_fk_ddo foreign key (object_type_id) 
    references wb_rt_def_object_types (object_type_id) on delete cascade,
  constraint ddi_uk unique (object_type_id, impl_type_name) using index tablespace %tndex
);

create index wb_rt_idx_ddi_ddo on wb_rt_def_impl_types (object_type_id) tablespace %tndex;
    
create table wb_rt_def_execution_adapters
(
  execution_adapter_id number(22) not null,
  store_type_id number(22) not null,
  adapter_name varchar2(64) not null,  
  minimum_compatible_version varchar2(32) not null,
  constraint dea_pk primary key (execution_adapter_id) using index tablespace %tndex,
  constraint dea_fk_dst foreign key (store_type_id) 
    references wb_rt_def_store_types (store_type_id) on delete cascade, 
  constraint dea_uk unique (store_type_id, adapter_name) using index tablespace %tndex
);

create index wb_rt_idx_dea_st on wb_rt_def_execution_adapters (store_type_id) tablespace %tndex;

create table wb_rt_def_execution_operators
(
  execution_operator_id number(22) not null,
  execution_adapter_id number(22) not null,
  operator_name varchar2(64) not null,
  is_process number(1) not null,  
  minimum_compatible_version varchar2(32) not null,
  constraint deo_pk primary key (execution_operator_id) using index tablespace %tndex,
  constraint deo_fk_dea foreign key (execution_adapter_id) 
    references wb_rt_def_execution_adapters (execution_adapter_id) on delete cascade,  
  constraint deo_uk unique (execution_adapter_id, operator_name) using index tablespace %tndex
);

create index wb_rt_idx_deo_dea on wb_rt_def_execution_operators (execution_adapter_id) tablespace %tndex;

create table wb_rt_def_operator_results
(
  operator_result_id number(22) not null,
  execution_operator_id number(22) not null,
  return_result varchar2(64) not null,
  return_result_number number(10) not null,
  result_category number(8) not null,  
  constraint dor_pk primary key (operator_result_id) using index tablespace %tndex,
  constraint dor_fk_deo foreign key (execution_operator_id) 
    references wb_rt_def_execution_operators (execution_operator_id) on delete cascade,
  constraint dor_uk_nam unique (execution_operator_id, return_result) using index tablespace %tndex,
  constraint dor_uk_val unique (execution_operator_id, return_result_number) using index tablespace %tndex
);

create index wb_rt_idx_der_deo on wb_rt_def_operator_results (execution_operator_id) tablespace %tndex;
create index wb_rt_idx_der_dct on wb_rt_def_operator_results (execution_operator_id, result_category) tablespace %tndex;

create table owb$wb_rt_def_system_params
(
  system_parameter_id number(22) not null,
  execution_adapter_id number(22) null,
  execution_operator_id number(22) null,
  parameter_name varchar2(64) not null,
  parameter_type number(8) not null,
  parameter_mode number(8) not null,
  parameter_scope number(8) null,
  bound_to_name varchar2(64) null,
  bound_to_kind number(8) null,
  bound_to_scope number(8) null,
  is_fixed number(1) not null,
  is_required number(1) not null,
  type_length number(10) null,
  type_scale number(10) null,
  type_precision number(10) null,
  default_value_kind number(8) not null,
  default_clob_value clob null,  
  constraint dsp_pk primary key (system_parameter_id) using index tablespace %tndex,
  constraint dsp_fk_dea foreign key (execution_adapter_id) 
    references wb_rt_def_execution_adapters (execution_adapter_id) on delete cascade,
  constraint dsp_fk_deo foreign key (execution_operator_id) 
    references wb_rt_def_execution_operators (execution_operator_id) on delete cascade,
  constraint dsp_uk unique (parameter_name, execution_adapter_id, execution_operator_id) using index tablespace %tndex
);

create index wb_rt_idx_dsp_dea on owb$wb_rt_def_system_params (execution_adapter_id) tablespace %tndex;
create index wb_rt_idx_dsp_deo on owb$wb_rt_def_system_params (execution_operator_id) tablespace %tndex;

create view wb_rt_def_system_parameters as select system_parameter_id, execution_adapter_id, execution_operator_id, parameter_name, parameter_type, parameter_mode, parameter_scope, bound_to_name, bound_to_kind, bound_to_scope, is_fixed, is_required, type_length, type_scale, type_precision, default_value_kind, default_clob_value, cast (dbms_lob.substr(default_clob_value, 4000, 1) as varchar2(4000)) default_value from owb$wb_rt_def_system_params;

create table wb_rt_def_file_types
(
  file_type_id number(22) not null,
  deployment_adapter_id number(22) null,
  execution_operator_id number(22) null,
  file_attachment number(8) not null,
  file_type_name varchar2(64) not null,
  constraint dft_pk primary key (file_type_id) using index tablespace %tndex,
  constraint dft_uk unique (file_type_name, file_attachment, deployment_adapter_id, execution_operator_id) using index tablespace %tndex,
  constraint dft_fk_dda foreign key (deployment_adapter_id) 
    references wb_rt_def_deployment_adapters (deployment_adapter_id) on delete cascade,
  constraint dft_fk_deo foreign key (execution_operator_id) 
    references wb_rt_def_execution_operators (execution_operator_id) on delete cascade
);

create index wb_rt_idx_dft_dda on wb_rt_def_file_types (deployment_adapter_id) tablespace %tndex;
create index wb_rt_idx_dft_dea on wb_rt_def_file_types (execution_operator_id) tablespace %tndex;
