Rem
Rem Copyright (c) 2000 by Oracle Corporation
Rem

----------------------------------------------------------------------------
-- PLATFORM DEFINITION VIEWS
----------------------------------------------------------------------------

create or replace view wb_rtv_def_store_types
as
  select
    store_type_id,
    store_type_name,
    store_type_version,
    display_name
  from
    wb_rt_def_store_types
  with read only;

create or replace view wb_rtv_def_store_type_params
as
  select
    store_type_param_id,
    store_type_id,
    parameter_name,
    display_name,
    access_restricted,
    mutable_when_not_empty,
    access_mode
  from
    wb_rt_def_store_type_params
  with read only;

create or replace view wb_rtv_def_deployment_adapters
as
  select
    deployment_adapter_id,
    store_type_id,
    adapter_name,
    does_undo,
    does_upgrade
  from
    wb_rt_def_deployment_adapters
  with read only;

create or replace view wb_rtv_def_object_type_defs
as
  select
    d.object_type_def_id,
    d.store_type_id,
    d.object_type_name,
    d.default_exists_action,
    d.default_not_exists_action,
    d.default_create_adapter,
    d.default_upgrade_adapter,
    d.default_drop_adapter,
    o.is_create_repeatable as is_default_create_repeatable 
  from
    wb_rt_def_object_type_defs d,
    wb_rt_def_object_types o
  where
    o.deployment_adapter_id (+) = d.default_create_adapter and
    o.object_type_name (+) = d.object_type_name
  with read only;


create or replace view wb_rtv_def_object_types
as
  select
    object_type_id,
    deployment_adapter_id,
    parent_object_type_id,
    object_type_name,
    adapter_creates,
    adapter_upgrades,
    adapter_drops,
    is_create_repeatable,
    is_data_object
  from
    wb_rt_def_object_types
  with read only;


create or replace view wb_rtv_def_impl_types
as
  select
    impl_type_id,
    object_type_id,
    impl_type_name
  from 
    wb_rt_def_impl_types
  with read only;
  

create or replace view wb_rtv_def_execution_adapters
as
  select
    execution_adapter_id,
    store_type_id,
    adapter_name
  from
    wb_rt_def_execution_adapters
  with read only;

create or replace view wb_rtv_def_execution_operators
as
  select
    execution_operator_id,
    execution_adapter_id,
    operator_name,
    is_process
  from
    wb_rt_def_execution_operators
  with read only;

create or replace view wb_rtv_def_operator_results
as
  select
    operator_result_id,
    execution_operator_id,
    return_result,
    return_result_number,
    result_category
  from
    wb_rt_def_operator_results
  with read only;

create or replace view wb_rtv_def_system_parameters
as
  select
    system_parameter_id,
    execution_adapter_id,
    execution_operator_id,
    parameter_name,
    parameter_type,
    parameter_mode,
    parameter_scope,
    bound_to_name,
    bound_to_kind,
    bound_to_scope,
    is_fixed,
    is_required,
    type_length,
    type_scale,
    type_precision,
    default_value_kind,
    default_clob_value,
    default_value
  from
    wb_rt_def_system_parameters
  with read only;

create or replace view wb_rtv_def_file_types
as
  select
    file_type_id,
    deployment_adapter_id,
    execution_operator_id,
    file_attachment,
    file_type_name
  from
    wb_rt_def_file_types
  with read only;


