-- ========================================================
-- 
-- (PACKAGED VERSION OWB_TIMESERIES.SQL)
-- HISTORY 
-- 	SROYCHOW,   August 11, 2003,  Created.
--  SROYCHOW,   August 18, 2003,  add code for Fiscal Year. (with 544 + 445) 
--
-- ========================================================

CREATE OR REPLACE PACKAGE OWB_TIMESERIES IS 

 FUNCTION DAY_GENERATOR_TFN  (  
   START_DATE                IN VARCHAR2,
   YEARS                     IN NUMBER,
   FISCAL_TYPE               IN NUMBER, 
   FY_START_DATE             IN VARCHAR2,
   START_DAY_OF_FISCAL_WEEK  IN NUMBER
 ) RETURN DAY_TYPE_TABLE PIPELINED;

 FUNCTION CAL_YEAR_GENERATOR_TFN ( 
   INPUT_ROWS IN SYS_REFCURSOR
 ) RETURN CAL_YEAR_TYPE_TABLE PIPELINED;

 FUNCTION CAL_QUARTER_GENERATOR_TFN ( 
   INPUT_ROWS IN SYS_REFCURSOR
 ) RETURN CAL_QUARTER_TYPE_TABLE PIPELINED;

 FUNCTION CAL_MONTH_GENERATOR_TFN ( 
   INPUT_ROWS IN SYS_REFCURSOR
 ) RETURN CAL_MONTH_TYPE_TABLE PIPELINED;

 FUNCTION CAL_WEEK_GENERATOR_TFN ( 
   INPUT_ROWS IN SYS_REFCURSOR
 ) RETURN CAL_WEEK_TYPE_TABLE PIPELINED;

 --
 -- FISCAL TABLE FUNCTIONS
 -- 
 FUNCTION FISCAL_YEAR_GENERATOR_TFN ( 
   INPUT_ROWS IN SYS_REFCURSOR
 ) RETURN FISCAL_YEAR_TYPE_TABLE PIPELINED;

 FUNCTION FISCAL_WEEK_GENERATOR_TFN ( 
   INPUT_ROWS IN SYS_REFCURSOR
 ) RETURN FISCAL_WEEK_TYPE_TABLE PIPELINED;

 FUNCTION FISCAL_MONTH_GENERATOR_TFN ( 
   INPUT_ROWS IN SYS_REFCURSOR
 ) RETURN FISCAL_MONTH_TYPE_TABLE PIPELINED;

 FUNCTION FISCAL_QUARTER_GENERATOR_TFN ( 
   INPUT_ROWS IN SYS_REFCURSOR
 ) RETURN FISCAL_QUARTER_TYPE_TABLE PIPELINED;

END OWB_TIMESERIES;
/

-- ========================================================
-- END CREATING PACKAGE SPECIFICATION OWB_TIMESERIES
-- ========================================================
