Rem
Rem Copyright (c) 2000 by Oracle Corporation
Rem

create or replace package wb_rt_upgrade is  function get_sequence_value
  (
     p_schema_name in varchar2,
     p_seq_name in varchar2,
     p_remote in int
  ) return number;
  
   procedure setup(p_orig_repos in varchar2, p_orig_version in varchar2, p_remote in int);
   procedure setup(p_orig_version in varchar2);
   
   procedure perform(p_orig_version in varchar2, p_wkspc_name in varchar2, p_phase in int);
   
   procedure perform(p_orig_version in varchar2, p_wkspc_name in varchar2);
   
   procedure upgrade_all(p_orig_repos in varchar2, p_orig_version in varchar2, p_remote in int,
                           p_workspace_id in int);
                           
   procedure tidyup(p_orig_version in varchar2);
   
   procedure reset_upgrade_incompatibility(p_store_id in number);

   function iscompatible(p_store_id in number) return number;

   procedure set_mode(p_orig_version in varchar2, p_mode in integer);
   
   function get_mode return number;
   
   function get_property_value(p_prop_key varchar2) return clob;

   procedure grant_owb_user(p_user in varchar2);

   procedure grant_owf_privilege(p_user in varchar2);
   
   procedure grant_workspace_user(p_user in varchar2, p_is_wk_admin number);

   procedure assoc_users(p_orig_repos in varchar2);
   
   procedure set_store_version(p_act_version in varchar2, p_reg_version in varchar2,
                               p_location_type in varchar2,
                               p_location_name in varchar2);
   
   procedure set_is_local_to_repos(p_repos_uoid varchar2, p_store_id varchar2);

   procedure create_db_link(p_orig_repos in varchar2, p_orig_pwd in varchar2,
         p_orig_host in varchar2, p_orig_port in varchar2,
         p_orig_service in varchar2, p_db_link_name in varchar2:=null);
         
   procedure remove_db_link(p_orig_repos in varchar2);
         
end;
/
