Rem
Rem Copyright (c) 2000 by Oracle Corporation
Rem

create or replace package wb_rt_upgrade_actions is  function objectAccessor(p_orig_repos in varchar2, p_obj_name in varchar2, p_remote int)
      return varchar2;
      
   procedure set_db_link_name(p_db_link_name in varchar2);

   function get_db_link_name(p_orig_repos in varchar2,
                             p_db_link_name in varchar2:=null) return varchar2;
  
   function get_sequence_value
   (
     p_seq_name in varchar2
   ) return number;
  
   procedure do_wb_rt_audit(p_orig_repos in varchar2, p_orig_version varchar2,
                            p_remote in int, p_workspace_id in int);
                            
   procedure do_wb_rt_audit_amounts(p_orig_repos in varchar2, p_orig_version varchar2,
                            p_remote in int, p_workspace_id in int);
                            
   procedure do_wb_rt_audit_custom_params(p_orig_repos in varchar2, p_orig_version varchar2,
                            p_remote in int, p_workspace_id in int);
                            
   procedure do_wb_rt_audit_deployments(p_orig_repos in varchar2, p_orig_version varchar2,
                            p_remote in int, p_workspace_id in int);
                            
   procedure do_wb_rt_audit_detail(p_orig_repos in varchar2, p_orig_version varchar2,
                            p_remote in int, p_workspace_id in int);
                            
   procedure do_wb_rt_audit_executions(p_orig_repos in varchar2, p_orig_version varchar2,
                            p_remote in int, p_workspace_id in int);
                            
   procedure do_wb_rt_audit_files(p_orig_repos in varchar2, p_orig_version varchar2,
                            p_remote in int, p_workspace_id in int);
                            
   procedure do_wb_rt_audit_messages(p_orig_repos in varchar2, p_orig_version varchar2,
                            p_remote in int, p_workspace_id in int);
   
   procedure do_wb_rt_audit_message_lines(p_orig_repos in varchar2, p_orig_version varchar2,
                            p_remote in int, p_workspace_id in int);

   
   procedure do_wb_rt_audit_message_params(p_orig_repos in varchar2, p_orig_version varchar2,
                            p_remote in int, p_workspace_id in int);

   
   procedure do_wb_rt_audit_objects(p_orig_repos in varchar2, p_orig_version varchar2,
                            p_remote in int, p_workspace_id in int);

   
   procedure do_wb_rt_audit_parameters(p_orig_repos in varchar2, p_orig_version varchar2,
                            p_remote in int, p_workspace_id in int);

   
   procedure do_wb_rt_audit_parameter_defs(p_orig_repos in varchar2, p_orig_version varchar2,
                            p_remote in int, p_workspace_id in int);

   
   procedure do_wb_rt_audit_scripts(p_orig_repos in varchar2, p_orig_version varchar2,
                            p_remote in int, p_workspace_id in int);

   
   procedure do_wb_rt_audit_script_runs(p_orig_repos in varchar2, p_orig_version varchar2,
                            p_remote in int, p_workspace_id in int);

   
   procedure do_wb_rt_audit_tasks(p_orig_repos in varchar2, p_orig_version varchar2,
                            p_remote in int, p_workspace_id in int);

   
   procedure do_wb_rt_audit_units(p_orig_repos in varchar2, p_orig_version varchar2,
                            p_remote in int, p_workspace_id in int);

   
   procedure do_wb_rt_errors(p_orig_repos in varchar2, p_orig_version varchar2,
                            p_remote in int, p_workspace_id in int);

   
   procedure do_wb_rt_error_rows(p_orig_repos in varchar2, p_orig_version varchar2,
                            p_remote in int, p_workspace_id in int);

   
   procedure do_wb_rt_error_sources(p_orig_repos in varchar2, p_orig_version varchar2,
                            p_remote in int, p_workspace_id in int);

   
   procedure do_wb_rt_feedback(p_orig_repos in varchar2, p_orig_version varchar2,
                            p_remote in int, p_workspace_id in int);

   
   procedure do_wb_rt_operator(p_orig_repos in varchar2, p_orig_version varchar2,
                            p_remote in int, p_workspace_id in int);

   
   procedure do_wb_rt_stores(p_orig_repos in varchar2, p_orig_version varchar2,
                            p_remote in int, p_workspace_id in int);

   
   procedure do_wb_rt_store_parameters(p_orig_repos in varchar2, p_orig_version varchar2,
                            p_remote in int, p_workspace_id in int);

   
   procedure do_wb_rt_tasks(p_orig_repos in varchar2, p_orig_version varchar2,
                            p_remote in int, p_workspace_id in int);

   
   procedure do_wb_rt_task_custom_params(p_orig_repos in varchar2, p_orig_version varchar2,
                            p_remote in int, p_workspace_id in int);

   
   procedure do_wb_rt_task_parameter_defs(p_orig_repos in varchar2, p_orig_version varchar2,
                            p_remote in int, p_workspace_id in int);

   
   procedure do_wb_rt_platform_files(p_orig_repos in varchar2, p_orig_version varchar2,
                            p_remote in int, p_workspace_id in int);

   
   procedure do_wb_rt_state_variables(p_orig_repos in varchar2, p_orig_version varchar2,
                            p_remote in int, p_workspace_id in int);

   
   procedure do_wb_rt_user_values(p_orig_version varchar2);
   
   procedure do_wb_rt_audit_struct(p_orig_repos in varchar2, p_orig_version varchar2,
                            p_remote in int, p_workspace_id in int);

   
   procedure do_wb_rt_warehouse_objects(p_orig_repos in varchar2, p_orig_version varchar2,
                            p_remote in int, p_workspace_id in int);


   procedure do_fixup_store_parameters(p_workspace_id in int);
   
   procedure do_set_store_version(p_act_version in varchar2, p_reg_version in varchar2,
                               p_location_type in varchar2,
                               p_location_name in varchar2);
   
   function do_sync_dbloc_parameters(p_old_host in varchar2,
                                     p_old_port in varchar2,
                                     p_old_service in varchar2,
                                     p_new_host in varchar2, 
                                     p_new_port in varchar2, 
                                     p_new_service in varchar2)
            return number;
            
   TYPE blob_text_row is record (
         id number,
         table_tag varchar2(32),
         offset number,
         length number,
         blob_text varchar2(1024));
         
   TYPE blob_bin_row is record (
         id number,
         table_tag varchar2(32),
         offset number,
         length number,
         blob_bin raw(2000));

   TYPE blob_text_row_set is table of blob_text_row;  

   function export_blob_column(p_table_tag varchar2,
                               p_src_table varchar2,
                               p_blob_col  varchar2,
                               p_id_col    varchar2) return blob_text_row_set pipelined;
                               
   TYPE c_blob_bin_row IS REF CURSOR;
   TYPE c_blob_text_row IS REF CURSOR;
   
   procedure load_blob_column(p_table_tag varchar2,
                     p_tgt_table varchar2,
                     p_blob_col  varchar2,
                     p_id_col    varchar2,
                     p_seq_name  varchar2);
                     
end wb_rt_upgrade_actions;
/
