Rem
Rem Copyright (c) 2000 by Oracle Corporation
Rem

create or replace package wb_rti_notification is

  function create_stream
  (
    p_timeout number
  ) 
  return number;
  
  procedure drop_stream
  (
    p_stream_id in number
  );

  procedure drop_notifications
  (
    p_audit_id in number
  );
  
  procedure set_ack_type
  (
    p_stream_id in number,
    p_audit_id in number,
    p_ack_type in number
  );
  
  procedure clear_ack_type
  (
    p_stream_id in number,
    p_audit_id in number
  );

  procedure ack
  (
    p_stream_id in number,
    p_audit_id in number,
    p_command in number
  );

  function number_of_interests
  (
    p_audit_id in number,
    p_event_type in number
  )
  return number;
  
  procedure register_interest
  (
    p_stream_id in number,
    p_audit_id in number,
    p_event_type in number
  );
  
  procedure unregister_interest
  (
    p_stream_id in number,
    p_audit_id in number,
    p_event_type in number
  );

  function notify_deployment
  (
    p_event_type in number,
    p_audit_unit_id in number,
    p_focus_id in number,
    p_end_of_chain in number := 0,
    p_commit in number := 1

  )
  return number;
  
  function notify_execution
  (
    p_event_type in number,
    p_audit_execution_id in number,
    p_focus_id in number,
    p_commit in number := 1
  )
  return number;
  
  procedure wait
  (
    p_stream_id in number,
    p_timeout in number,
    p_event_type out number,
    p_audit_id out number,
    p_focus_id out number,
    p_end_of_chain out number
  );
  
end wb_rti_notification;
/

