Rem
Rem Copyright (c) 2000 by Oracle Corporation
Rem

create or replace package wb_rti_queues is

  procedure clean_queues;

  procedure start_queues;
  
  procedure stop_queues;
  
  procedure enq_service_request
  (
    p_request_type in number,
    p_focus_id in number
  );
  
  procedure deq_service_request
  (
    p_request_type out number, 
    p_focus_id out number,
    p_timeout in number
  );
  
  function is_service_request_queue_empty
  return number;
  
  procedure enq_notification
  (
    p_stream_id in number,
    p_timeout in number,
    p_event_type in number,
    p_audit_id in number,
    p_focus_id in number,
    p_end_of_chain in number := 0
  );
  
  procedure deq_notification
  (
    p_stream_id in number,
    p_timeout in number,
    p_event_type out number,
    p_audit_id out number,
    p_focus_id out number,
    p_end_of_chain out number
  );
  
  procedure enq_acknowledgement
  (
    p_audit_id in number,
    p_command in number   
  );
  
  procedure deq_acknowledgement
  (
    p_audit_id in number,
    p_command out number    
  );
  
end wb_rti_queues;
/

