Rem
Rem Copyright (c) 2000 by Oracle Corporation
Rem

create or replace package wb_rti_service_deployment is

  function reserve_deployment
  (
    p_audit_deployment_id in number
  ) 
  return number;
  
  procedure unreserve_deployment
  (
    p_audit_deployment_id in number
  );

  procedure prepare_unit
  (
    p_audit_unit_id in number,
    p_stream_id in number,
    p_ack_type in number
  );
    
  procedure prepare_unit_done
  (
    p_audit_unit_id in number,
    p_ops_enabled in number
  );
  
  procedure unprepare_unit
  (
    p_audit_unit_id in number,
    p_stream_id in number,
    p_ack_type in number
  );
    
  procedure unprepare_unit_done
  (
    p_audit_unit_id in number,
    p_ops_enabled in number
  );
  
  procedure deploy_unit
  (
    p_audit_unit_id in number,
    p_stream_id in number,
    p_ack_type in number,
    p_job_mode in number
  );
  
  procedure deploy_unit_done
  (
    p_audit_unit_id in number,
    p_ops_enabled in number
  );
  
  procedure undo_unit
  (
    p_audit_unit_id in number,
    p_stream_id in number,
    p_ack_type in number,
    p_job_mode in number
  );
  
  procedure undo_unit_done
  (
    p_audit_unit_id in number,
    p_ops_enabled in number
  );
  
  procedure finalize_unit
  (
    p_audit_unit_id in number,
    p_stream_id in number,
    p_ack_type in number,
    p_job_mode in number
  );
  
  procedure finalize_unit_done
  (
    p_audit_unit_id in number
  );
    
  procedure set_current_unit_op_aborted
  (
    p_audit_unit_id in number
  ); 

  procedure on_dequeue_deployment
  (
    p_audit_unit_id in number
  );

  procedure on_dequeue_deployment_done
  (
    p_audit_unit_id in number,
    p_stream_id in number
  );

  procedure acknowledge
  (
    p_audit_unit_id in number,
    p_stream_id in number,
    p_command in number
  );
    
  procedure abort
  (
    p_audit_unit_id in number
  );

end wb_rti_service_deployment;
/

