Rem
Rem Copyright (c) 2000, 2007, Oracle. All rights reserved.  
Rem

create or replace package wb_rti_service_execution is

  procedure execute
  (
    p_audit_execution_id in number,
    p_stream_id in number,
    p_ack_type in number,
    p_job_mode in number := wb_rt_constants.JOB_MODE_NORMAL
  );
  
  procedure execute_background
  (
    p_audit_execution_id in number
  );
  
  procedure execute_child
  (
    p_audit_execution_id in number,
    p_stream_id in number
  );
    
  procedure on_dequeue_execute
  (
    p_audit_execution_id in number
  );
  
  function lookup_binding
  (
    p_audit_execution_id in number,
    p_bound_to_name in varchar2,
    p_max_ascents in number := 1,
    p_bound_to_scope in number := null,
    p_bound_from_scope in number := null,
    p_bound_to_kind in number := null,
    p_bound_from_kind in number := null,
    p_prefered_mode in number := null
  ) return number;

  procedure execute_done
  (
    p_audit_execution_id in number
  );
    
  procedure on_dequeue_execute_done
  (
    p_audit_execution_id in number,
    p_stream_id in number
  );

  procedure acknowledge
  (
    p_audit_execution_id in number,
    p_stream_id in number,
    p_command in number
  );
    
  procedure abort
  (
    p_audit_execution_id in number
  );

  procedure expedite
  (
    p_audit_execution_id in number
  );

  procedure set_current_execution_aborted
  (
    p_audit_execution_id in number
  ); 

  function get_parent_execution
  (
    p_audit_execution_id in number
  ) return number;

  procedure check_map_audit_status
  (
    p_audit_execution_id in number
  );
    
  end wb_rti_service_execution;
/

