create or replace package wb_rti_util as
  function exec_runtime_service
  (
    p_command in varchar2,
    p_input in varchar2
  ) 
  return number; 
  
  function oracle_home 
  return varchar2; 
  
  function operating_system 
  return varchar2; 
  
  function server_version 
  return varchar2; 
  
  procedure set_key; 

  function get_platform_config 
  return varchar2; 

  procedure set_platform_config
  (
    p_value in varchar2
  ); 

  function get_user_value
  (
    p_store_parameter_id in number, 
    p_user_id in number := uid,
    p_enterprise_mode in number := null
  ) return varchar2; 

  function check_user_value
  (
    p_store_parameter_id in number, 
    p_value in varchar2,
    p_user_id in number := uid,
    p_restriction_mode in number := null,
    p_enterprise_mode in number := null
  ) return number;

  procedure set_user_value
  (
    p_store_parameter_id in number, 
    p_value in varchar2,
    p_user_id in number := uid,
    p_restriction_mode in number := null,
    p_enterprise_mode in number := null
  );

  procedure propagate_user_values
  (
    p_to_user_id in number,
    p_from_user_id in number,
    p_enterprise_mode in number := null
  );

  function has_user_value
  (
    p_store_parameter_id in number, 
    p_user_id in number := uid,
    p_enterprise_mode in number := null
  ) return number; 

  procedure remove_user_value
  (
    p_store_parameter_id in number, 
    p_user_id in number := uid,
    p_enterprise_mode in number := null
  );

  procedure purge_user_values
  (
    p_user_id in number
  );

  procedure purge_user_values
  (
    p_store_id in number
  );

  procedure housekeep_user_values
  (
    p_purge_departmental_values in number := 0,
    p_purge_enterprise_values in number := 0
  );
  
  function get_client_value
  (
    p_uoid in varchar2, 
    p_user_id in number := uid,
    p_enterprise_mode in number := null
  ) return varchar2; 

  procedure set_client_value
  (
    p_uoid in varchar2, 
    p_value in varchar2,
    p_user_id in number := uid,
    p_restriction_mode in number := null,
    p_enterprise_mode in number := null
  );

  procedure propagate_client_values
  (
    p_to_user_id in number,
    p_from_user_id in number,
    p_enterprise_mode in number := null
  );

  function has_client_value
  (
    p_uoid in varchar2, 
    p_user_id in number := uid,
    p_enterprise_mode in number := null
  ) return number; 

  procedure remove_client_value
  (
    p_uoid in varchar2, 
    p_user_id in number := uid,
    p_enterprise_mode in number := null
  );

  procedure purge_client_values
  (
    p_user_id in number
  );

  procedure purge_client_values
  (
    p_uoid in varchar2
  );

  procedure housekeep_client_values
  (
    p_purge_departmental_values in number := 0,
    p_purge_enterprise_values in number := 0
  );
  
  procedure reset
  (
    p_value in varchar2
  );
  
  procedure check_execute_access;
  
  procedure check_deploy_access;

  procedure check_admin_access;
  
  procedure check_repos_admin_access; 

  procedure set_session_mode
  (
    p_enterprise_mode in number
  );
  
  function get_session_mode return number;
  
  procedure set_mode
  (
    p_enterprise_mode in number,
    p_purge_departmental_values in number := 1,
    p_purge_enterprise_values in number := 1
  );
  
  function is_in_enterprise_mode 
  (
    p_enterprise_mode in number := null
  ) 
  return number;
  
  function is_managed_value
  (
    p_restriction_mode in number,
    p_access_mode in number := wb_rt_constants.ACCESS_MODE_DEFAULT
  )
  return number;
  
  function get_user_value_user_id
  (
    p_user_id in number,
    p_restriction_mode in number,
    p_access_mode in number := wb_rt_constants.ACCESS_MODE_DEFAULT,
    p_enterprise_mode in number := null
  )
  return number;
  
  function is_departmental_user_id
  (
    p_user_id in number := uid
  )
  return number;

end wb_rti_util;
/

