create or replace package wb_rti_workflow_util is
  procedure initialize;
  
  function define_execution
  (
    p_task_id in number,
    p_execution_name in varchar2
  ) 
  return number;

  function define_execution
  (
    p_task_id in number,
    p_parent_audit_execution_id in number,
    p_execution_name in varchar2
  ) 
  return number;

  procedure override_input_parameter
  (
    p_audit_execution_id in number,
    p_parameter_name in varchar2,
    p_parameter_kind in number,
    p_value in varchar2,
    p_value_kind in number := null,
    p_parameter_scope in number := null
  ); 

  procedure override_input_parameter
  (
    p_audit_execution_id in number,
    p_parameter_name in varchar2,
    p_parameter_kind in number,
    p_value in clob,
    p_value_kind in number := null,
    p_parameter_scope in number := null
  ); 

  procedure set_output_parameter
  (
    p_audit_execution_id in number,
    p_parameter_name in varchar2,
    p_parameter_kind in number,
    p_value in varchar2,
    p_parameter_scope in number := null
  ); 
 
  procedure set_output_parameter
  (
    p_audit_execution_id in number,
    p_parameter_name in varchar2,
    p_parameter_kind in number,
    p_value in clob,
    p_parameter_scope in number := null
  ); 
 
  procedure activate_execution
  (
    p_audit_execution_id in number
  );

  procedure deactivate_execution
  (
    p_audit_execution_id in number
  );

  procedure execute
  (
    p_audit_execution_id in number,
    p_stream_id in number,
    p_ack_type in number
  );

  procedure execute_background
  (
    p_audit_execution_id in number
  );

  function execute_in_background_and_wait
  (
    p_audit_execution_id number,
    p_wait_timeout in number
  )
  return number;
  
  procedure execute_child
  (
    p_audit_execution_id in number,
    p_stream_id in number
  );
	
  procedure notify_execution_start
  (
    p_audit_execution_id in number,
    p_stream_id in number,
    p_ack_type in number
  );

  procedure notify_child_execution_start
  (
    p_audit_execution_id in number,
    p_stream_id in number
  );
  
  procedure notify_execution_complete
  (
    p_audit_execution_id in number,
    p_return_result in number,
    p_return_code in number,
    p_commit in number := 0
  );

  procedure abort
  (
    p_audit_execution_id in number
  );

  procedure expedite
  (
    p_audit_execution_id in number,
    p_return_result in number,
    p_return_code in number
  );

  procedure create_textual_attr
  (
    p_audit_id in number,
    p_attr_name in varchar2,
    p_attr_value in varchar2
  );

  function get_textual_attr
  (
    p_audit_id in number,
    p_attr_name in varchar2
  )
  return varchar2;

  function PARAM_KIND_SYSTEM 
  return number;
  
  function PARAM_KIND_CUSTOM 
  return number;
  
  function SEVERITY_INFORMATIONAL 
  return number;
  
  function SEVERITY_WARNING 
  return number;
  
  function SEVERITY_ERROR 
  return number;
  
  function SEVERITY_RECOVERY 
  return number;
  
  function ACK_TYPE_NONE 
  return number;
  
  function RESULT_CATEGORY_SUCCESS
  return number;
  
  function RESULT_CATEGORY_WARNING
  return number;
  
  function RESULT_CATEGORY_FAILURE 
  return number;
  
  function RESULT_SUCCESS
  return varchar2;
  
  function RESULT_WARNING
  return varchar2;
  
  function RESULT_FAILURE
  return varchar2;
  
  function RESULT_NUMBER_SUCCESS
  return number;
  
  function RESULT_NUMBER_WARNING
  return number;
  
  function RESULT_NUMBER_FAILURE
  return number;
    
  function create_stream
  (
    p_timeout in number := null
  ) 
  return number;
  
  function task_message
  (
    p_audit_execution_id in number,
    p_severity in number
  ) 
  return number;  

  procedure message_line
  (
    p_audit_message_id in number,
    p_text in varchar2
  );

  function get_value_kind
  (
    p_audit_execution_id in number,
    p_parameter_name in varchar2,
    p_parameter_kind in number,
    p_parameter_scope in number := null
  )
  return number;

  procedure set_external_audit_id
  (
    p_audit_execution_id in number,
    p_external_audit_id in varchar2
  ); 
  
  procedure set_request_audit_id
  (
    p_audit_execution_id in number,
    p_request_audit_id in varchar2
  ); 
  
  function get_audit_id
  (
    p_parent_audit_execution_id in number,
    p_external_audit_id in varchar2
  )
  return number; 
  
  function get_audit_id
  (
    p_parent_audit_execution_id in number,
    p_request_audit_id in varchar2
  )
  return number; 
  
  procedure set_scope_audit_execution_id
  (
    p_audit_execution_id in number,
    p_scope_audit_execution_id in number
  ); 
  
  function get_return_result_category
  (
    p_audit_execution_id in number
  )
  return number;
  
  function get_task
  (
    p_object_uoid varchar2,
    p_object_type_name varchar2,
    p_store_uoid varchar2,
    p_task_name varchar2,
    p_exec_store_uoid varchar2
  )
  return number;
  
  
  function get_hook(p_audit_execution_id number,
                    p_product_family varchar2
                   )
  return varchar2;

  function open_by_name
  (
    p_parent_audit_id in number,
    p_job_object_type_name in varchar2,
    p_job_object_name in varchar2,
    p_job_dep_location_name in varchar2,
    p_job_task_name in varchar2,
    p_job_exec_location_name in varchar2  
  )
  return number;
         
  procedure execute_in_background
  (
    p_audit_execution_id number
  );  
  
  procedure execute_task
  (
    p_job_audit_execution_id in number,
    p_job_object_type_name in varchar2,
    p_job_object_name in varchar2,
    p_job_dep_location_name in varchar2,
    p_activity_task_name in varchar2,
    p_activity_exec_location_name in varchar2,
    p_audit_execution_id out number,
    p_stream_id out number
  ); 
         
  procedure wait_for_task_then_close
  (
    p_audit_execution_id in number,
    p_stream_id in number     
  );  
         
  
  procedure set_workspace
  (
    p_workspace in varchar2,
    p_owner in varchar2
  );  
         
end wb_rti_workflow_util;
/
