begin

begin
execute immediate('CREATE OR REPLACE PROCEDURE WB_OLAP_LOAD_CUBE(olap_aw_owner VARCHAR2, olap_aw_name VARCHAR2, olap_cube_owner VARCHAR2, olap_cube_name VARCHAR2, olap_tgt_cube_name VARCHAR2) AS
  v varchar2(32); 
  l_charset varchar2(100); 
  BEGIN 
    BEGIN 
      DBMS_AWM.CREATE_AWCUBELOAD_SPEC(olap_cube_name, olap_cube_owner, olap_cube_name, ''LOAD_DATA''); 
    EXCEPTION WHEN OTHERS THEN NULL; 
    END;
    DBMS_AWM.REFRESH_AWCUBE(olap_aw_owner, olap_aw_name, olap_tgt_cube_name, olap_cube_name); 
    l_charset := DBMS_ASSERT.SIMPLE_SQL_NAME(olap_aw_owner);
    l_charset := DBMS_ASSERT.SIMPLE_SQL_NAME(olap_aw_name);
    DBMS_AW.EXECUTE(''upd ''||olap_aw_owner||''.''||olap_aw_name ||''; commit'');
    BEGIN 
      SELECT null into v from all_olap2_aw_cube_agg_specs where aw_owner=olap_aw_owner and aw_name=olap_aw_name and aw_cube_name=olap_tgt_cube_name and aw_aggspec_name=olap_cube_name; 
    EXCEPTION 
      WHEN OTHERS THEN RETURN; 
    END;
    DBMS_AWM.AGGREGATE_AWCUBE(olap_aw_owner, olap_aw_name, olap_tgt_cube_name, olap_cube_name); 
    EXCEPTION
      WHEN OTHERS THEN 
        RAISE; 
  END;');
exception when others then null;
end;

begin
execute immediate('CREATE OR REPLACE PROCEDURE WB_OLAP_LOAD_DIMENSION(olap_aw_owner VARCHAR2, olap_aw_name VARCHAR2, olap_dimension_owner VARCHAR2, olap_dimension_name VARCHAR2, olap_tgt_dimension_name VARCHAR2) AS 
  l_charset varchar2(100); 
  BEGIN 
    BEGIN 
      DBMS_AWM.CREATE_AWDIMLOAD_SPEC(olap_dimension_name, olap_dimension_owner, olap_dimension_name, ''FULL_LOAD''); 
    EXCEPTION WHEN OTHERS THEN NULL; 
    END;
    DBMS_AWM.SET_AWDIMLOAD_SPEC_PARAMETER(olap_dimension_name, olap_dimension_owner, olap_dimension_name, ''UNIQUE_RDBMS_KEY'',''Yes''); 
    DBMS_AWM.REFRESH_AWDIMENSION(olap_aw_owner, olap_aw_name, olap_tgt_dimension_name, olap_dimension_name); 
    l_charset := DBMS_ASSERT.SIMPLE_SQL_NAME(olap_aw_owner);
    l_charset := DBMS_ASSERT.SIMPLE_SQL_NAME(olap_aw_name);
    DBMS_AW.EXECUTE(''upd ''||olap_aw_owner||''.''||olap_aw_name ||''; commit''); 
  EXCEPTION 
    WHEN OTHERS THEN 
      RAISE; 
  END;');
exception when others then null;
end;

begin
execute immediate('CREATE OR REPLACE PROCEDURE WB_OLAP_LOAD_DIMENSION_GENUK(olap_aw_owner VARCHAR2, olap_aw_name VARCHAR2, olap_dimension_owner VARCHAR2, olap_dimension_name VARCHAR2, olap_tgt_dimension_name VARCHAR2) AS 
  l_charset varchar2(100); 
  BEGIN 
    BEGIN 
      DBMS_AWM.CREATE_AWDIMLOAD_SPEC(olap_dimension_name, olap_dimension_owner, olap_dimension_name, ''FULL_LOAD''); 
    EXCEPTION WHEN OTHERS THEN NULL; 
    END;
    DBMS_AWM.SET_AWDIMLOAD_SPEC_PARAMETER(olap_dimension_name, olap_dimension_owner, olap_dimension_name, ''UNIQUE_RDBMS_KEY'',''NO''); 
    DBMS_AWM.REFRESH_AWDIMENSION(olap_aw_owner, olap_aw_name, olap_tgt_dimension_name, olap_dimension_name); 
    l_charset := DBMS_ASSERT.SIMPLE_SQL_NAME(olap_aw_owner);
    l_charset := DBMS_ASSERT.SIMPLE_SQL_NAME(olap_aw_name);
    DBMS_AW.EXECUTE(''upd ''||olap_aw_owner||''.''||olap_aw_name ||''; commit''); 
  EXCEPTION 
    WHEN OTHERS THEN 
      RAISE;
  END;');
exception when others then null;
end;

begin
execute immediate('DROP TABLE OWB$$$_SOLVE_GROUP_IDS');
exception when others then
  dbms_output.put_line(SQLERRM);
end;

begin
execute immediate('CREATE TABLE OWB$$$_SOLVE_GROUP_IDS(CUBE_NAME VARCHAR2(30), MEASURE_NAME VARCHAR2(30), SOLVE_GROUP_ID VARCHAR2(1000))');
exception when others then
  dbms_output.put_line(SQLERRM);
end;

begin
execute immediate('CREATE OR REPLACE FUNCTION INTERACTIONEXECUTEBUILD(input CLOB) return varchar2 AUTHID CURRENT_USER as
  language java name
    ''oracle.AWAction.Interaction.ExecuteBuild(oracle.sql.CLOB) return java.lang.String'';'); 
exception when others then null;
end;

begin
execute immediate('CREATE OR REPLACE FUNCTION INTERACTIONEXECUTE(input CLOB) return varchar2 AUTHID CURRENT_USER as
  language java name
    ''oracle.AWAction.Interaction.Execute(oracle.sql.CLOB) return java.lang.String'';'); 
exception when others then null;
end;

begin
execute immediate('CREATE OR REPLACE PROCEDURE WB_OLAP_AW_SET_SOLVE_ID(p_cube_name VARCHAR2, p_measure_name VARCHAR2, p_solve_group_id VARCHAR2) AS
BEGIN
  EXECUTE IMMEDIATE 
  ''INSERT INTO OWB$$$_SOLVE_GROUP_IDS(CUBE_NAME, MEASURE_NAME, SOLVE_GROUP_ID) 
   VALUES(:a, :b, :c)'' 
   USING p_cube_name, p_measure_name, p_solve_group_id ;
  COMMIT;   
END WB_OLAP_AW_SET_SOLVE_ID;');
exception when others then null;
end;

begin
execute immediate('CREATE OR REPLACE PROCEDURE WB_OLAP_AW_REMOVE_SOLVE_ID(p_cube_name VARCHAR2) AS
BEGIN
  EXECUTE IMMEDIATE 
  ''DELETE FROM OWB$$$_SOLVE_GROUP_IDS WHERE CUBE_NAME = :a'' USING p_cube_name;
  COMMIT;
END WB_OLAP_AW_REMOVE_SOLVE_ID;');
exception when others then null;
end;

begin
execute immediate('CREATE OR REPLACE FUNCTION WB_OLAP_AW_GET_SOLVE_ID(p_cube_name VARCHAR2, p_measure_name VARCHAR2) RETURN VARCHAR2 AS
  l_solve_group_id VARCHAR2(1000);
BEGIN
  if (p_measure_name is null) then
    SELECT SOLVE_GROUP_ID INTO l_solve_group_id FROM OWB$$$_SOLVE_GROUP_IDS WHERE CUBE_NAME = p_cube_name AND MEASURE_NAME is null;
  else
    SELECT SOLVE_GROUP_ID INTO l_solve_group_id FROM OWB$$$_SOLVE_GROUP_IDS WHERE CUBE_NAME = p_cube_name AND MEASURE_NAME = p_measure_name;
  end if;
  RETURN l_solve_group_id;
EXCEPTION WHEN OTHERS THEN
  RETURN null;  -- If no data found, return null
END WB_OLAP_AW_GET_SOLVE_ID;');
exception when others then 
  dbms_output.put_line(SQLERRM);
end;

begin
execute immediate('CREATE OR REPLACE FUNCTION WB_OLAP_AW_PRECOMPUTE(p_aw_name VARCHAR2, 
                                                  p_cube_name VARCHAR2, 
                                                  p_measure_name VARCHAR2 DEFAULT NULL,
                                                  p_allow_parallel_solve BOOLEAN DEFAULT FALSE,
                                                  p_max_job_queues INTEGER DEFAULT 0) RETURN VARCHAR2 AUTHID CURRENT_USER AS
  -- Defined in owb/shiphome/owb/rtasst/wbolapplsql.sql
  xml_clob clob;                                                                                                    
  TYPE xml_line_array_type IS TABLE OF VARCHAR2(32767) INDEX BY BINARY_INTEGER;
  xml_lines xml_line_array_type;
  xml_lines_idx NUMBER := 0;
  l_solve_group_id VARCHAR2(1000);
  executeResult VARCHAR2(1000);
  l_current_schema VARCHAR2(30);
  l_full_aw_name VARCHAR2(200);
  l_build_type VARCHAR2(12);
  l_max_job_queues VARCHAR2(20);
  l_max_job_queues_tag VARCHAR2(100);
  
  -- local function to create clob from line array
  FUNCTION create_clob(lines xml_line_array_type) RETURN clob IS
    num_lines NUMBER := lines.COUNT;
    the_clob clob;
  BEGIN
    DBMS_LOB.CREATETEMPORARY(the_clob,TRUE);
    dbms_lob.open(the_clob, DBMS_LOB.LOB_READWRITE);

    FOR i IN 1..num_lines LOOP
      dbms_lob.writeappend(the_clob, LENGTH(lines(i)), lines(i));
    END LOOP;
    dbms_lob.close(the_clob);
    RETURN the_clob;
  END create_clob;

BEGIN                                                  

  -- Get the solve group id for the given cube and measure
  l_solve_group_id := WB_OLAP_AW_GET_SOLVE_ID(p_cube_name, p_measure_name);

  IF (l_solve_group_id IS NULL) OR (LENGTH(l_solve_group_id) = 0) THEN
    raise_application_error(-20100, ''Cannot find solve group name for cube '' || p_cube_name || '', measure '' || p_measure_name || ''.  If compression is turned on, then no solve groups will be generated.'');
  END IF;    
  
  SELECT SYS_CONTEXT(''userenv'', ''CURRENT_SCHEMA'') INTO l_current_schema from dual;
  l_full_aw_name := l_current_schema || ''.'' || p_aw_name;
  dbms_output.put_line(l_full_aw_name);
  
  IF p_allow_parallel_solve THEN
    l_build_type := ''BACKGROUND'';
  ELSE
    l_build_type := ''EXECUTE'';
  END IF;
  
  l_max_job_queues_tag := '''';
  if p_max_job_queues > 0 THEN
    l_max_job_queues_tag := '' MaxJobQueues="'' || TO_CHAR(p_max_job_queues) || ''"'';
  END IF;  
  
  IF p_allow_parallel_solve THEN
    xml_lines(1) := ''<?xml version = ''''1.0'''' encoding = ''''ISO-8859-1'''' ?>'';
    xml_lines(2) := ''<!-- <!DOCTYPE XMI SYSTEM ''''Model.dtd'''' > -->'';
    xml_lines(3) := ''<AWXML version = ''''1.0'''' timestamp = ''''Mon Feb 11 13:29:11 2002'''' >'';
    xml_lines(4) := ''<AWXML.content>'';
    xml_lines(5) := ''  <BuildDatabase  Id="Action2" AWName="'' || l_full_aw_name || ''" BuildType="'' || TRIM(l_build_type) || ''" RunSolve="true" CleanMeasures="false" CleanAttrs="false" CleanDim="false" TrackStatus="false"'' || l_max_job_queues_tag || ''>'';
    xml_lines(6) := ''    <BuildList XMLIDref="'' || TRIM(l_solve_group_id) || ''"/>'';
    xml_lines(7) := ''  </BuildDatabase>'';
    xml_lines(8) := ''</AWXML.content>'';
    xml_lines(9) := ''</AWXML>'';
  else
    xml_lines(1) := ''<?xml version = ''''1.0'''' encoding = ''''ISO-8859-1'''' ?>'';
    xml_lines(2) := ''<!-- <!DOCTYPE XMI SYSTEM ''''Model.dtd'''' > -->'';
    xml_lines(3) := ''<AWXML version = ''''1.0'''' timestamp = ''''Mon Feb 11 13:29:11 2002'''' >'';
    xml_lines(4) := ''<AWXML.content>'';
    xml_lines(5) := ''  <Attach  Id="Action1" AWName="'' || l_full_aw_name || ''"/>'';
    xml_lines(6) := ''  <BuildDatabase  Id="Action2" AWName="'' || l_full_aw_name || ''" BuildType="'' || TRIM(l_build_type) || ''" RunSolve="true" CleanMeasures="false" CleanAttrs="false" CleanDim="false" TrackStatus="false"'' || l_max_job_queues_tag || ''>'';
    xml_lines(7) := ''    <BuildList XMLIDref="'' || TRIM(l_solve_group_id) || ''"/>'';
    xml_lines(8) := ''  </BuildDatabase>'';
    xml_lines(9) := ''  <Commit  Id="Action3"/>'';
    xml_lines(10) := ''  <Detach  Id="Action4" AWName="'' || l_full_aw_name || ''"/>'';
    xml_lines(11) := ''</AWXML.content>'';
    xml_lines(12) := ''</AWXML>'';
  end if;

  xml_clob := create_clob(xml_lines);
  
  -- execute the solve group
  IF p_allow_parallel_solve THEN
    executeResult := interactionExecuteBuild(xml_clob);
  ELSE
    executeResult := interactionExecute(xml_clob);
  END IF;
  dbms_output.put_line(executeResult); -- if executing in sqlplus and "set serveroutput on" has been executed.

  COMMIT;
  RETURN executeResult;

END WB_OLAP_AW_PRECOMPUTE;');
exception when others then null;
end;

begin
execute immediate('CREATE OR REPLACE PROCEDURE WB_CREATE_DEFAULT_SURR_TBL AUTHID CURRENT_USER AS 
  l_table_name VARCHAR2(256);
BEGIN
  BEGIN
    SELECT TABLE_NAME INTO l_table_name FROM USER_TABLES WHERE TABLE_NAME = ''OWB$_DEFAULT_SURROGATE_IDS'';
  EXCEPTION WHEN OTHERS THEN
    l_table_name := NULL;
  END;
  IF l_table_name IS NULL THEN
    EXECUTE IMMEDIATE
    ''CREATE TABLE OWB$_DEFAULT_SURROGATE_IDS(DIM_LEVEL_NAME VARCHAR2(256), LEVEL_TABLE_NAME VARCHAR2(256), DEFAULT_ROW_ID VARCHAR2(256), DEFAULT_SURROGATE_ID NUMBER, CONSTRAINT OWB$_DEFAULT_SURROGATE_CONS UNIQUE (DIM_LEVEL_NAME, LEVEL_TABLE_NAME) ENABLE)'';
  END IF;    
END WB_CREATE_DEFAULT_SURR_TBL;
');
exception when others then
  dbms_output.put_line(SQLERRM);
end;

begin
execute immediate('CREATE OR REPLACE PROCEDURE WB_REMOVE_DEFAULT_SURROGATE_ID(p_dim_level_name VARCHAR2, p_level_table_name VARCHAR2) AUTHID CURRENT_USER AS
BEGIN
  EXECUTE IMMEDIATE 
  ''DELETE FROM OWB$_DEFAULT_SURROGATE_IDS WHERE DIM_LEVEL_NAME = :a AND LEVEL_TABLE_NAME = :b'' USING p_dim_level_name, p_level_table_name;
  COMMIT;
EXCEPTION WHEN OTHERS THEN
  dbms_output.put_line(''Cannot delete row from OWB$_DEFAULT_SURROGATE_IDS: '' || SQLERRM);
END WB_REMOVE_DEFAULT_SURROGATE_ID;
');
exception when others then null;
end;

begin
execute immediate('CREATE OR REPLACE PROCEDURE WB_INSERT_DEFAULT_SURROGATE_ID(p_dim_level_name VARCHAR2, p_level_table_name VARCHAR2, p_default_surrogate_id NUMBER) AUTHID CURRENT_USER AS
BEGIN
  WB_CREATE_DEFAULT_SURR_TBL;  -- Create the table in the target schema if not already created
  WB_REMOVE_DEFAULT_SURROGATE_ID(p_dim_level_name, p_level_table_name);  -- Remove old row if it exists
  EXECUTE IMMEDIATE 
  ''INSERT INTO OWB$_DEFAULT_SURROGATE_IDS(DIM_LEVEL_NAME, LEVEL_TABLE_NAME, DEFAULT_ROW_ID, DEFAULT_SURROGATE_ID) 
   VALUES(:a, :b, NULL, :c)'' USING p_dim_level_name, p_level_table_name, p_default_surrogate_id;
  COMMIT;   
END WB_INSERT_DEFAULT_SURROGATE_ID;
');
exception when others then null;
end;

begin
execute immediate('CREATE OR REPLACE FUNCTION WB_LOOKUP_DEFAULT_SURROGATE_ID(p_dim_level_name VARCHAR2, p_level_table_name VARCHAR2) RETURN NUMBER AUTHID CURRENT_USER AS
l_default_surrogate_id NUMBER := -1;
l_sql_stmt VARCHAR2(1000);
l_rownum NUMBER;
BEGIN
  BEGIN
    l_sql_stmt :=
    ''SELECT DEFAULT_SURROGATE_ID FROM OWB$_DEFAULT_SURROGATE_IDS 
      WHERE DIM_LEVEL_NAME = :a AND LEVEL_TABLE_NAME = :b''; 
    EXECUTE IMMEDIATE l_sql_stmt
      INTO l_default_surrogate_id USING p_dim_level_name, p_level_table_name;
  EXCEPTION WHEN OTHERS THEN
    dbms_output.put_line(l_sql_stmt);
    dbms_output.put_line(SQLERRM);
    dbms_output.put_line(''Cannot find default surrogate id, returning -1'');
    l_default_surrogate_id := -1;
  END;  
  RETURN l_default_surrogate_id;
END WB_LOOKUP_DEFAULT_SURROGATE_ID;
');
exception when others then 
  dbms_output.put_line(SQLERRM);
end;
  
begin
execute immediate('CREATE OR REPLACE FUNCTION WB_CHECK_DEFAULT_SURROGATE_ID(p_dim_level_name VARCHAR2, p_level_table_name VARCHAR2) RETURN NUMBER AUTHID CURRENT_USER AS
l_default_surrogate_id NUMBER := NULL;
l_default_row_id VARCHAR2(256);
l_sql_stmt VARCHAR2(1000);
l_rownum NUMBER;
l_charset VARCHAR2(100);
BEGIN
  dbms_output.put_line(''START WB_CHECK_DEFAULT_SURROGATE_ID'');
  BEGIN
    l_sql_stmt :=
    ''SELECT DEFAULT_SURROGATE_ID, DEFAULT_ROW_ID FROM OWB$_DEFAULT_SURROGATE_IDS 
      WHERE DIM_LEVEL_NAME = :a AND LEVEL_TABLE_NAME = :b''; 
    EXECUTE IMMEDIATE l_sql_stmt
      INTO l_default_surrogate_id, l_default_row_id USING p_dim_level_name, p_level_table_name;
  EXCEPTION WHEN OTHERS THEN
    dbms_output.put_line(l_sql_stmt);
    dbms_output.put_line(SQLERRM);
    l_default_surrogate_id := NULL;
  END;  
  IF (l_default_surrogate_id IS NOT NULL) THEN
    -- Make sure that the stored rowid exists in the level table
    BEGIN
      l_charset := DBMS_ASSERT.SQL_OBJECT_NAME(p_level_table_name);
      l_sql_stmt :=
        ''SELECT ROWNUM FROM '' || p_level_table_name || '' WHERE ROWID = :b'';
      EXECUTE IMMEDIATE l_sql_stmt
        INTO l_rownum USING l_default_row_id ;
    EXCEPTION WHEN OTHERS THEN
      dbms_output.put_line(l_sql_stmt);
      dbms_output.put_line(SQLERRM);
      -- remove default surrogate id table row since the default row no longer exists in the level table
      BEGIN
        WB_REMOVE_DEFAULT_SURROGATE_ID(p_dim_level_name, p_level_table_name);
      EXCEPTION WHEN OTHERS THEN
        dbms_output.put_line(SQLERRM);
        NULL;
      END;
      l_default_surrogate_id := NULL;
    END; 
  ELSE 
    l_default_surrogate_id := NULL;
  END IF;  
  dbms_output.put_line(''END WB_CHECK_DEFAULT_SURROGATE_ID return value = '' || TO_CHAR(l_default_surrogate_id));
  RETURN l_default_surrogate_id;
END WB_CHECK_DEFAULT_SURROGATE_ID;
');
exception when others then 
  dbms_output.put_line(SQLERRM);
end;

begin
execute immediate('CREATE OR REPLACE FUNCTION WB_GET_DEFAULT_SURROGATE_ID(p_dim_level_name VARCHAR2, p_level_table_name VARCHAR2, p_sequence_access_name VARCHAR2, p_lowest_level NUMBER) RETURN NUMBER AUTHID CURRENT_USER AS
l_default_surrogate_id NUMBER := NULL;
select_stmt VARCHAR2(1000);
l_seq VARCHAR2(30);
l_charset VARCHAR2(100);
BEGIN
  dbms_output.put_line(''START WB_GET_DEFAULT_SURROGATE_ID'');
  BEGIN  
    l_default_surrogate_id := WB_CHECK_DEFAULT_SURROGATE_ID(p_dim_level_name, p_level_table_name);
  EXCEPTION WHEN OTHERS THEN
    -- dbms_output.put_line(SQLERRM);
    l_default_surrogate_id := NULL;
  END;  
  IF l_default_surrogate_id IS NULL AND p_sequence_access_name IS NOT NULL THEN
    BEGIN
      -- If no previous default surrogate key defined, then create one using the provided sequence
      l_charset := DBMS_ASSERT.SQL_OBJECT_NAME(p_sequence_access_name);
      EXECUTE IMMEDIATE ''SELECT '' || p_sequence_access_name || ''.NEXTVAL FROM DUAL'' INTO l_default_surrogate_id;
      IF (p_lowest_level = 0) THEN
        l_default_surrogate_id := l_default_surrogate_id * -1;
      END IF;
    EXCEPTION WHEN OTHERS THEN
      dbms_output.put_line(''Cannot select from sequence '' || p_sequence_access_name);
    END;
    WB_INSERT_DEFAULT_SURROGATE_ID(p_dim_level_name, p_level_table_name, l_default_surrogate_id);
  END IF;  
  IF (l_default_surrogate_id IS NULL) THEN
    dbms_output.put_line(''No default surrogate id found, default surrogate id will be set to 1'');
    l_default_surrogate_id := 1;
    IF (p_lowest_level = 0) THEN
      l_default_surrogate_id := -1;
    END IF;
  END IF;  
  RETURN l_default_surrogate_id;
EXCEPTION WHEN OTHERS THEN
  dbms_output.put_line(SQLERRM);
  RETURN l_default_surrogate_id;
END WB_GET_DEFAULT_SURROGATE_ID;
');
exception when others then null;
end;

begin
execute immediate('CREATE OR REPLACE PROCEDURE WB_UPDATE_DEFAULT_ROW_ID(p_dim_level_name VARCHAR2, p_level_table_name VARCHAR2, p_dim_key_col VARCHAR2, p_surrogate_key_col VARCHAR2, p_default_surrogate_id NUMBER) AUTHID CURRENT_USER AS
l_rowid VARCHAR2(256);
l_select_stmt VARCHAR2(1000);
l_charset VARCHAR2(100);
BEGIN
  dbms_output.put_line(''STARTING WB_ADD_DEFAULT_ROW_ID'');
  BEGIN
    l_charset := DBMS_ASSERT.SQL_OBJECT_NAME(p_level_table_name);
    l_charset := DBMS_ASSERT.SIMPLE_SQL_NAME(p_dim_key_col);
    l_charset := DBMS_ASSERT.SIMPLE_SQL_NAME(p_surrogate_key_col);
    l_select_stmt :=
    ''SELECT ROWID FROM '' || p_level_table_name || '' WHERE '' || p_dim_key_col || '' = :a AND '' || p_surrogate_key_col || '' = :b'';
    EXECUTE IMMEDIATE l_select_stmt INTO l_rowid USING p_default_surrogate_id, p_default_surrogate_id;  
  EXCEPTION WHEN OTHERS THEN
    dbms_output.put_line(l_select_stmt);
    dbms_output.put_line(SQLERRM);
    l_rowid := NULL;
  END;  
  IF (l_rowid IS NOT NULL) THEN
    dbms_output.put_line(''found rowid='' || l_rowid);
    BEGIN
      EXECUTE IMMEDIATE 
      ''UPDATE OWB$_DEFAULT_SURROGATE_IDS SET DEFAULT_ROW_ID = :a WHERE
         DIM_LEVEL_NAME = :b AND LEVEL_TABLE_NAME = :c''
         USING l_rowid, p_dim_level_name, p_level_table_name;
      COMMIT;   
    EXCEPTION WHEN OTHERS THEN
      dbms_output.put_line(''Error updating row id: '' || SQLERRM);
    END;
  END IF;  
END;  
');
exception when others then null;
end;

--execute immediate('grant execute on WB_OLAP_LOAD_DIMENSION to public');
--execute immediate('grant execute on WB_OLAP_LOAD_DIMENSION_GENUK to public');
--execute immediate('grant execute on WB_OLAP_LOAD_CUBE to public');
--execute immediate('grant execute on WB_OLAP_AW_PRECOMPUTE to public');
--execute immediate('grant execute on WB_OLAP_AW_SET_SOLVE_ID to public');
--execute immediate('grant execute on WB_OLAP_AW_GET_SOLVE_ID to public');
--execute immediate('grant execute on WB_OLAP_AW_REMOVE_SOLVE_ID to public');
--execute immediate('grant execute on WB_CREATE_DEFAULT_SURR_TBL to public');
--execute immediate('grant execute on WB_INSERT_DEFAULT_SURROGATE_ID to public');
--execute immediate('grant execute on WB_GET_DEFAULT_SURROGATE_ID to public');
--execute immediate('grant execute on WB_UPDATE_DEFAULT_ROW_ID to public');
--execute immediate('grant execute on WB_LOOKUP_DEFAULT_SURROGATE_ID to public');
--execute immediate('grant execute on WB_REMOVE_DEFAULT_SURROGATE_ID to public');

begin
execute immediate('revoke execute on WB_OLAP_LOAD_DIMENSION from public');
exception when others then
 null;
end;
begin
execute immediate('revoke execute on WB_OLAP_LOAD_DIMENSION_GENUK from public');
exception when others then
 null;
end;
begin
execute immediate('revoke execute on WB_OLAP_LOAD_CUBE from public');
exception when others then
 null;
end;
begin
execute immediate('revoke execute on WB_OLAP_AW_PRECOMPUTE from public');
exception when others then
 null;
end;
begin
execute immediate('revoke execute on WB_OLAP_AW_SET_SOLVE_ID from public');
exception when others then
 null;
end;
begin
execute immediate('revoke execute on WB_OLAP_AW_GET_SOLVE_ID from public');
exception when others then
 null;
end;
begin
execute immediate('revoke execute on WB_OLAP_AW_REMOVE_SOLVE_ID from public');
exception when others then
 null;
end;
begin
execute immediate('revoke execute on WB_CREATE_DEFAULT_SURR_TBL from public');
exception when others then
 null;
end;
begin
execute immediate('revoke execute on WB_INSERT_DEFAULT_SURROGATE_ID from public');
exception when others then
 null;
end;
begin
execute immediate('revoke execute on WB_GET_DEFAULT_SURROGATE_ID from public');
exception when others then
 null;
end;
begin
execute immediate('revoke execute on WB_UPDATE_DEFAULT_ROW_ID from public');
exception when others then
 null;
end;
begin
execute immediate('revoke execute on WB_LOOKUP_DEFAULT_SURROGATE_ID from public');
exception when others then
 null;
end;
begin
execute immediate('revoke execute on WB_REMOVE_DEFAULT_SURROGATE_ID from public');
exception when others then
 null;
end;

end;
/

