begin
  declare
   flag NUMBER := 0;
  begin
    select count(*) into flag
    from product_component_version
    where instr(product,'Oracle8i') != 0 AND
          instr(version,'8.1.7') != 0;
    if flag = 1 then
      begin
        execute immediate('create public synonym "oracle/xml/sql/core/OracleXMLConvert"'||
          ' for SYS."oracle/xml/sql/core/OracleXMLConvert"');

        execute immediate('create public synonym "oracle/xml/sql/core/OracleXMLTimer"'||
          ' for SYS."oracle/xml/sql/core/OracleXMLTimer"');

        execute immediate('create public synonym "oracle/xml/sql/core/OracleXMLTime"'||
          ' for SYS."oracle/xml/sql/core/OracleXMLTime"');

        execute immediate ('create public synonym "oracle/xml/sql/core/OracleXMLUtil"'||
          ' for SYS."oracle/xml/sql/core/OracleXMLUtil"');

        execute immediate ('create public synonym "oracle/xml/sql/dataset/OracleXMLDataSet"'||
          ' for SYS."oracle/xml/sql/dataset/OracleXMLDataSet"');

        execute immediate ('create public synonym "oracle/xml/sql/dataset/OracleXMLDataSetExtJdbc"'||
          ' for SYS."oracle/xml/sql/dataset/OracleXMLDataSetExtJdbc"');

        execute immediate ('create public synonym "oracle/xml/sql/dataset/OracleXMLDataSetGenJdbc"'||
          ' for SYS."oracle/xml/sql/dataset/OracleXMLDataSetGenJdbc"');

        execute immediate ('create public synonym "oracle/xml/sql/docgen/OracleXMLDocGen"'||
          ' for SYS."oracle/xml/sql/docgen/OracleXMLDocGen"');

        execute immediate ('create public synonym "oracle/xml/sql/docgen/OracleXMLDocGenDOM"'||
          ' for SYS."oracle/xml/sql/docgen/OracleXMLDocGenDOM"');

        execute immediate ('create public synonym "oracle/xml/sql/docgen/OracleXMLDocGenLob"'||
          ' for SYS."oracle/xml/sql/docgen/OracleXMLDocGenLob"');

        execute immediate ('create public synonym "oracle/xml/sql/docgen/OracleXMLDocGenSAX"'||
          ' for SYS."oracle/xml/sql/docgen/OracleXMLDocGenSAX"');

        execute immediate ('create public synonym "oracle/xml/sql/docgen/OracleXMLDocGenString"'||
          ' for SYS."oracle/xml/sql/docgen/OracleXMLDocGenString"');

        execute immediate ('create public synonym "oracle/xml/sql/name/OracleColumnName"'||
        ' for SYS."oracle/xml/sql/name/OracleColumnName"');

        execute immediate ('create public synonym "oracle/xml/sql/name/OracleCursorName"'||
          ' for SYS."oracle/xml/sql/name/OracleCursorName"');

        execute immediate ('create public synonym "oracle/xml/sql/name/OracleADTName"'||
          ' for SYS."oracle/xml/sql/name/OracleADTName"');

        execute immediate ('create public synonym "oracle/xml/sql/name/OracleCollectionName"'||
          ' for SYS."oracle/xml/sql/name/OracleCollectionName"');

        execute immediate ('create public synonym "oracle/xml/sql/name/OracleScalarName"'||
          ' for SYS."oracle/xml/sql/name/OracleScalarName"');

        execute immediate ('create public synonym "oracle/xml/sql/query/OracleXMLQuery"'||
          ' for SYS."oracle/xml/sql/query/OracleXMLQuery"');

        execute immediate ('create public synonym "oracle/xml/sql/query/OracleXMLStaticQuery$MutableInt"'||
          ' for SYS."oracle/xml/sql/query/OracleXMLStaticQuery$MutableInt"');

        execute immediate ('create public synonym "oracle/xml/sql/query/OracleXMLStaticQuery$QueryCtx"'||
          ' for SYS."oracle/xml/sql/query/OracleXMLStaticQuery$QueryCtx"');

        execute immediate ('create public synonym "oracle/xml/sql/query/OracleXMLStaticQuery"'||
          ' for SYS."oracle/xml/sql/query/OracleXMLStaticQuery"');

        execute immediate ('create public synonym "oracle/xml/sql/dml/OracleXMLSave"'||
          ' for SYS."oracle/xml/sql/dml/OracleXMLSave"');

        execute immediate ('create public synonym "oracle/xml/sql/dml/OracleXMLStaticSave$MutableInt"'||
          ' for SYS."oracle/xml/sql/dml/OracleXMLStaticSave$MutableInt"');

        execute immediate ('create public synonym "oracle/xml/sql/dml/OracleXMLStaticSave$SaveCtx"'||
          ' for SYS."oracle/xml/sql/dml/OracleXMLStaticSave$SaveCtx"');

        execute immediate ('create public synonym "oracle/xml/sql/dml/OracleXMLStaticSave"'||
          ' for SYS."oracle/xml/sql/dml/OracleXMLStaticSave"');

        execute immediate ('create public synonym "oracle/xml/sql/OracleXMLSQLException"'||
          ' for SYS."oracle/xml/sql/OracleXMLSQLException"');

        execute immediate ('create public synonym "oracle/xml/sql/OracleXMLSQLNoRowsException"'||
          ' for SYS."oracle/xml/sql/OracleXMLSQLNoRowsException"');

        execute immediate ('create public synonym "oracle/xml/sql/XSUXSchemaHandler"'||
          ' for SYS."oracle/xml/sql/XSUXSchemaHandler"');

        execute immediate ('create public synonym "oracle/xml/sql/XSUMesg"'||
          ' for SYS."oracle/xml/sql/XSUMesg"');

        execute immediate ('create public synonym "oracle/xml/sql/mesg/XSUMessages.properties"'||
          ' for SYS."oracle/xml/sql/mesg/XSUMessages.properties"');

        execute immediate ('create public synonym "OracleXMLStore"'||
          ' for SYS."OracleXMLStore"');
      exception
        when others then
          null;
      end;
    end if;
  end;
end;
/


CREATE OR REPLACE PACKAGE OWBXMLTK AS 

  PROCEDURE INIT(controlInfo VARCHAR2); 
  PROCEDURE DISPOSE; 
  FUNCTION LOAD_ALL RETURN NUMBER; 
  FUNCTION LOAD(num NUMBER) RETURN NUMBER; 
  FUNCTION LOAD_NEXT_BATCH RETURN NUMBER; 
  PROCEDURE LOAD_CURRENT; 
  FUNCTION HAS_MORE_XML  RETURN BOOLEAN; 
  FUNCTION IS_MAX_LOADS_KNOWN RETURN BOOLEAN; 
  FUNCTION MAX_LOAD_COUNT RETURN NUMBER; 

END;
/


CREATE OR REPLACE PACKAGE BODY OWBXMLTK AS 

  FUNCTION i_init(controlInfo VARCHAR2) RETURN NUMBER 
  AS LANGUAGE JAVA 
  NAME 'oracle.wh.runtime.xml.PLSQLAdapter.init(java.lang.String) return int'; 

  FUNCTION i_load_all RETURN NUMBER AS LANGUAGE JAVA 
  NAME 'oracle.wh.runtime.xml.PLSQLAdapter.load() return int'; 

  FUNCTION i_load(num NUMBER) RETURN NUMBER AS LANGUAGE JAVA 
  NAME 'oracle.wh.runtime.xml.PLSQLAdapter.load(int) return int'; 

  FUNCTION i_loadNextBatch RETURN NUMBER AS LANGUAGE JAVA 
  NAME 'oracle.wh.runtime.xml.PLSQLAdapter.loadNextBatch() return int'; 

  FUNCTION i_loadCurrent RETURN NUMBER AS LANGUAGE JAVA 
  NAME 'oracle.wh.runtime.xml.PLSQLAdapter.loadCurrent() return int'; 

  FUNCTION i_hasMoreXML RETURN NUMBER AS LANGUAGE JAVA 
  NAME 'oracle.wh.runtime.xml.PLSQLAdapter.hasMoreXML() return int'; 

  FUNCTION MAX_LOAD_COUNT RETURN NUMBER AS LANGUAGE JAVA 
  NAME 'oracle.wh.runtime.xml.PLSQLAdapter.maxXMLLoadCount() return int'; 

  FUNCTION i_is_max_loads_known RETURN NUMBER AS LANGUAGE JAVA 
  NAME 'oracle.wh.runtime.xml.PLSQLAdapter.isMaxXMLLoadCountKnowInAdvance() return int'; 

  FUNCTION getLastErrorMessage RETURN VARCHAR2 AS LANGUAGE JAVA 
  NAME 'oracle.wh.runtime.xml.PLSQLAdapter.getLastErrorMessage() return java.lang.String'; 

  PROCEDURE checkForError(result NUMBER) IS 
  BEGIN 
    IF result < -20000 THEN 
      raise_application_error(result, getLastErrorMessage); 
    END IF; 
  END; 

  PROCEDURE INIT(controlInfo VARCHAR2) IS 
    result NUMBER; 
  BEGIN 
    result := i_init(controlInfo); 
    checkForError(result); 
  END; 

  PROCEDURE DISPOSE AS LANGUAGE JAVA 
  NAME 'oracle.wh.runtime.xml.PLSQLAdapter.dispose()'; 

  FUNCTION LOAD_ALL RETURN NUMBER IS 
    result NUMBER; 
  BEGIN 
    result := i_load_all; 
    checkForError(result); 
    RETURN result; 
  END; 

  FUNCTION LOAD(num NUMBER) RETURN NUMBER IS 
    result NUMBER; 
  BEGIN 
    result := i_load(num); 
    checkForError(result); 
    RETURN result; 
  END; 

  FUNCTION LOAD_NEXT_BATCH RETURN NUMBER IS 
    result NUMBER; 
  BEGIN 
    result := i_loadNextBatch; 
    checkForError(result); 
    RETURN result; 
  END; 

  PROCEDURE LOAD_CURRENT IS 
    result NUMBER; 
  BEGIN 
    result := i_loadCurrent; 
    checkForError(result); 
  END; 

  FUNCTION HAS_MORE_XML  RETURN BOOLEAN IS 
    result NUMBER; 
  BEGIN 
    result := i_hasMoreXML; 
    checkForError(result); 
    RETURN (result = 1); 
  END; 

  FUNCTION IS_MAX_LOADS_KNOWN RETURN BOOLEAN IS 
    result NUMBER; 
  BEGIN 
    result := i_is_max_loads_known; 
    checkForError(result); 
    RETURN (result = 1); 
  END; 

END;
/


CREATE OR REPLACE FUNCTION WB_XML_LOAD_F(control_info VARCHAR2) RETURN NUMBER AS 
  load_total NUMBER; 
BEGIN 

  OWBXMLTK.INIT(control_info); 
  load_total := OWBXMLTK.LOAD_ALL; 
  OWBXMLTK.DISPOSE; 
  RETURN load_total; 

EXCEPTION 
  WHEN OTHERS THEN 
    ROLLBACK; 
    OWBXMLTK.DISPOSE; 
    RAISE; 
END;
/


CREATE OR REPLACE PROCEDURE WB_XML_LOAD(control_info VARCHAR2) AS 
  load_total NUMBER; 
BEGIN 
  load_total := WB_XML_LOAD_F(control_info); 
END;
/


grant execute on OWBXMLTK to public;
grant execute on WB_XML_LOAD_F to public;
grant execute on WB_XML_LOAD to public;

