--
-- File
--   owbebs.sql
--
-- Purpose
--   Performs the necessary grants to a user in the Oracle Apps database 
--   for Oracle Warehouse Builder to extract metadata.
--
-- Prerequisites
--   #1 This script must be run by a DBA.
--   #2 The user must have been created by the DBA.
--
-- How to run
--   In SQL*Plus, do a START owbebs [<username>]
--

-- grant necessary privilege to the metadata extraction user
grant select_catalog_role to &1;
grant select on apps.fnd_application to &&1;
grant select on apps.fnd_application_vl to &&1;
grant select on apps.fnd_tables to &&1;
grant select on apps.fnd_views to &&1;
grant select on apps.fnd_sequences to &&1;
grant select on apps.fnd_columns to &&1;
grant select on apps.fnd_primary_keys to &&1;
grant select on apps.fnd_foreign_keys to &&1;
grant select on apps.fnd_primary_key_columns to &&1;
grant select on apps.fnd_foreign_key_columns to &&1;
grant select on apps.fnd_product_installations  to &&1;
grant select on apps.fnd_oracle_userid  to &&1;

-- create synonyms in the metadata extraction user's schema
create synonym &&1..fnd_application for apps.fnd_application;
create synonym &&1..fnd_application_vl for apps.fnd_application_vl;
create synonym &&1..fnd_tables for apps.fnd_tables;
create synonym &&1..fnd_views for apps.fnd_views;
create synonym &&1..fnd_sequences for apps.fnd_sequences;
create synonym &&1..fnd_columns for apps.fnd_columns;
create synonym &&1..fnd_primary_keys for apps.fnd_primary_keys;
create synonym &&1..fnd_foreign_keys for apps.fnd_foreign_keys;
create synonym &&1..fnd_primary_key_columns for apps.fnd_primary_key_columns;
create synonym &&1..fnd_foreign_key_columns for apps.fnd_foreign_key_columns;
create synonym &&1..fnd_product_installations for apps.fnd_product_installations;
create synonym &&1..fnd_oracle_userid for apps.fnd_oracle_userid;
