begin

declare
	procedure dyn_sql(p_sql in varchar2) 
	is
	begin
		execute immediate p_sql;
	exception
		when others then
			return;
	end;

begin

	        --|
		--|drop all tables
		--|

	begin
		for t in (select table_name from user_tables where table_NAME like 'OWB_UTIL_%' )    
                loop
                 dyn_sql('drop table '|| t.table_name || ' cascade constraints' );
                end loop;
	exception
		when others then
			return;
	end;	

		--|
		--|drop all views 
		--|

	begin
		for v in (select view_name from user_views where
		(VIEW_NAME like 'ALL_IV_%' or VIEW_NAME like 'OWBB%'
		or VIEW_NAME like 'WBA_IV_%') )
                loop
                 dyn_sql('drop view '|| v.view_name);
                end loop;
	exception
		when others then
			return;
	end;
	
		--|
		--|drop all packages
		--|

    --| Comment it out; it is done in drop_objects.
	--begin
		--for r in (select object_type, object_name from user_objects where object_type ='PACKAGE')
		--loop
			--dyn_sql('drop ' || r.object_type || ' ' || r.object_name);
		--end loop;
	--exception
		--when others then
			--return;
	--end;	

		--|
		--|drop all materialized views
		--|
		--|Commented out; will be done by object's owner
	--begin
		--for mv in (select name from user_snapshots)
		--loop
			--dyn_sql('drop materialized view '||mv.name);
		--end loop;
	--exception
		--when others then
			--return;
	--end;
	

end;

end;

