Rem
Rem $Header: owb_uprop.sql 15-apr-2008.14:18:40 xxzhang Exp $
Rem
Rem owb_uprop.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      owb_uprop.sql - OWB_UPROP package declaration
Rem
Rem    DESCRIPTION
Rem      Table functions providing optimized property meta/data retrieval
Rem
Rem    NOTES
Rem      See the last section of owb_uprop_views.sql for the queries supporting
Rem     these functions.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    xxzhang     04/15/08 - 
Rem    bjeffrie    02/18/06 - Created
Rem

-- WARNING! service/impl/assistant/RuntimeInstaller will throw exception if
-- these are enabled.
--SET ECHO ON
--SET FEEDBACK 1
--SET NUMWIDTH 10
--SET LINESIZE 80
--SET TRIMSPOOL ON
--SET TAB OFF
--SET PAGESIZE 100

CREATE OR REPLACE PACKAGE owb_uprop AS

  TYPE fqPusageDef_set_t IS TABLE OF SUB_FQ_PUSAGE_DEF%ROWTYPE;
  TYPE fqPusage_set_t    IS TABLE OF ALL_IV_EXT_OBJECT_PROPERTIES%ROWTYPE;

  -- cdefTypeName is processed with LIKE, not '=' so wilcards are OK.
  -- send 'true' for includeHidden if you want the hidden properties also
  FUNCTION getFqPropertyUsageDefinitions(cdefTypeName  IN VARCHAR2,
                                         includeHidden IN VARCHAR2 DEFAULT 'false')
    RETURN fqPusageDef_set_t PIPELINED;

  -- elementId is the id of the element you want property definitions for
  -- send 'true' for includeHidden if you want the hidden properties also
  FUNCTION getFqPropertyUsageDefinitions(elementId     IN NUMBER,
                                         includeHidden IN VARCHAR2 DEFAULT 'false')
    RETURN fqPusageDef_set_t PIPELINED;

  -- propertyType is one of  'CONFIG', 'LOGICAL', 'USERDEF'
  FUNCTION getProperties(objectId IN NUMBER,
                         configurationId IN NUMBER DEFAULT 0,
                         propertyType1 IN VARCHAR2 DEFAULT 'LOGICAL',
                         propertyType2 IN VARCHAR2 DEFAULT 'DUMMY',
                         propertyType3 IN VARCHAR2 DEFAULT 'DUMMY',
                         includeHidden IN VARCHAR2 DEFAULT 'false')
    RETURN fqPusage_set_t PIPELINED;
  
END owb_uprop;
/

