create table owb_uprop_nls (
  key varchar2(128) not null,
  language_id varchar2(3) not null,
  text varchar2(2000),
  constraint IDX_NLSKEY primary key (key, language_id) using index tablespace %tndex
);

create table OWB_UTIL_CONFIGPARAMS ( 
paramkey varchar2(128) not null, 	
paramname varchar2(64) not null, 	
groupkey varchar2(128) not null, 	
language varchar2(64) not null,
defaultvalue varchar2(128),
nlskey varchar2(64), 	
constraint IDX_UTILPARAMKEY primary key (paramkey, language) using index tablespace %tndex 
);

create table OWB_UTIL_CONFIGGROUPS (
groupkey varchar2(128) not null,        
foldername varchar2(64) not null,        
instancename varchar2(64),        
grouptype number(1) not null, 	
language varchar2(64) not null,
logicaltypes varchar2(128), 
parentkey varchar2(128),        
nlskey varchar2(64),   --key for folder name
constraint IDX_UTILGROUPKEY primary key (groupkey, language) using index tablespace %tndex 
);

create table OWB_UTIL_LANGUAGES ( 
language_id varchar2(128) not null, 	
name varchar2(64) not null
);

insert into OWB_UTIL_LANGUAGES values ('ar', 'Arabic');
insert into OWB_UTIL_LANGUAGES values ('ar_AE', 'Arabic_United');
insert into OWB_UTIL_LANGUAGES values ('ar_BH', 'Arabic_Bahrain');
insert into OWB_UTIL_LANGUAGES values ('ar_DZ', 'Arabic_Algeria');
insert into OWB_UTIL_LANGUAGES values ('ar_EG', 'Arabic_Egypt');
insert into OWB_UTIL_LANGUAGES values ('ar_IQ', 'Arabic_Iraq');
insert into OWB_UTIL_LANGUAGES values ('ar_JO', 'Arabic_Jordan');
insert into OWB_UTIL_LANGUAGES values ('ar_KW', 'Arabic_Kuwait');
insert into OWB_UTIL_LANGUAGES values ('ar_LB', 'Arabic_Lebanon');
insert into OWB_UTIL_LANGUAGES values ('ar_LY', 'Arabic_Libya');
insert into OWB_UTIL_LANGUAGES values ('ar_MA', 'Arabic_Morocco');
insert into OWB_UTIL_LANGUAGES values ('ar_OM', 'Arabic_Oman');
insert into OWB_UTIL_LANGUAGES values ('ar_QA', 'Arabic_Qatar');
insert into OWB_UTIL_LANGUAGES values ('ar_SA', 'Arabic_Saudi');
insert into OWB_UTIL_LANGUAGES values ('ar_SD', 'Arabic_Sudan');
insert into OWB_UTIL_LANGUAGES values ('ar_SY', 'Arabic_Syria');
insert into OWB_UTIL_LANGUAGES values ('ar_TN', 'Arabic_Tunisia');
insert into OWB_UTIL_LANGUAGES values ('ar_YE', 'Arabic_Yemen');
insert into OWB_UTIL_LANGUAGES values ('be', 'Byelorussian');
insert into OWB_UTIL_LANGUAGES values ('be_BY', 'Byelorussian_Belarus');
insert into OWB_UTIL_LANGUAGES values ('bg', 'Bulgarian');
insert into OWB_UTIL_LANGUAGES values ('bg_BG', 'Bulgarian_Bulgaria');
insert into OWB_UTIL_LANGUAGES values ('ca', 'Catalan');
insert into OWB_UTIL_LANGUAGES values ('ca_ES', 'Catalan_Spain');
insert into OWB_UTIL_LANGUAGES values ('cs', 'Czech');
insert into OWB_UTIL_LANGUAGES values ('cs_CZ', 'Czech_Czech');
insert into OWB_UTIL_LANGUAGES values ('da', 'Danish');
insert into OWB_UTIL_LANGUAGES values ('da_DK', 'Danish_Denmark');
insert into OWB_UTIL_LANGUAGES values ('de', 'German');
insert into OWB_UTIL_LANGUAGES values ('de_AT', 'German_Austria');
insert into OWB_UTIL_LANGUAGES values ('de_CH', 'German_Switzerland');
insert into OWB_UTIL_LANGUAGES values ('de_DE', 'German_Germany');
insert into OWB_UTIL_LANGUAGES values ('de_LU', 'German_Luxembourg');
insert into OWB_UTIL_LANGUAGES values ('el', 'Greek');
insert into OWB_UTIL_LANGUAGES values ('el_GR', 'Greek_Greece');
insert into OWB_UTIL_LANGUAGES values ('en', 'English');
insert into OWB_UTIL_LANGUAGES values ('en_AU', 'English_Australia');
insert into OWB_UTIL_LANGUAGES values ('en_CA', 'English_Canada');
insert into OWB_UTIL_LANGUAGES values ('en_GB', 'English_United');
insert into OWB_UTIL_LANGUAGES values ('en_IE', 'English_Ireland');
insert into OWB_UTIL_LANGUAGES values ('en_NZ', 'English_New');
insert into OWB_UTIL_LANGUAGES values ('en_US', 'English_United');
insert into OWB_UTIL_LANGUAGES values ('en_ZA', 'English_South');
insert into OWB_UTIL_LANGUAGES values ('es', 'Spanish');
insert into OWB_UTIL_LANGUAGES values ('es_AR', 'Spanish_Argentina');
insert into OWB_UTIL_LANGUAGES values ('es_BO', 'Spanish_Bolivia');
insert into OWB_UTIL_LANGUAGES values ('es_CL', 'Spanish_Chile');
insert into OWB_UTIL_LANGUAGES values ('es_CO', 'Spanish_Colombia');
insert into OWB_UTIL_LANGUAGES values ('es_CR', 'Spanish_Costa');
insert into OWB_UTIL_LANGUAGES values ('es_DO', 'Spanish_Dominican');
insert into OWB_UTIL_LANGUAGES values ('es_EC', 'Spanish_Ecuador');
insert into OWB_UTIL_LANGUAGES values ('es_ES', 'Spanish_Spain');
insert into OWB_UTIL_LANGUAGES values ('es_GT', 'Spanish_Guatemala');
insert into OWB_UTIL_LANGUAGES values ('es_HN', 'Spanish_Honduras');
insert into OWB_UTIL_LANGUAGES values ('es_MX', 'Spanish_Mexico');
insert into OWB_UTIL_LANGUAGES values ('es_NI', 'Spanish_Nicaragua');
insert into OWB_UTIL_LANGUAGES values ('es_PA', 'Spanish_Panama');
insert into OWB_UTIL_LANGUAGES values ('es_PE', 'Spanish_Peru');
insert into OWB_UTIL_LANGUAGES values ('es_PR', 'Spanish_Puerto');
insert into OWB_UTIL_LANGUAGES values ('es_PY', 'Spanish_Paraguay');
insert into OWB_UTIL_LANGUAGES values ('es_SV', 'Spanish_El');
insert into OWB_UTIL_LANGUAGES values ('es_UY', 'Spanish_Uruguay');
insert into OWB_UTIL_LANGUAGES values ('es_VE', 'Spanish_Venezuela');
insert into OWB_UTIL_LANGUAGES values ('et', 'Estonian');
insert into OWB_UTIL_LANGUAGES values ('et_EE', 'Estonian_Estonia');
insert into OWB_UTIL_LANGUAGES values ('fi', 'Finnish');
insert into OWB_UTIL_LANGUAGES values ('fi_FI', 'Finnish_Finland');
insert into OWB_UTIL_LANGUAGES values ('fr', 'French');
insert into OWB_UTIL_LANGUAGES values ('fr_BE', 'French_Belgium');
insert into OWB_UTIL_LANGUAGES values ('fr_CA', 'French_Canada');
insert into OWB_UTIL_LANGUAGES values ('fr_CH', 'French_Switzerland');
insert into OWB_UTIL_LANGUAGES values ('fr_FR', 'French_France');
insert into OWB_UTIL_LANGUAGES values ('fr_LU', 'French_Luxembourg');
insert into OWB_UTIL_LANGUAGES values ('hr', 'Croatian');
insert into OWB_UTIL_LANGUAGES values ('hr_HR', 'Croatian_Croatia');
insert into OWB_UTIL_LANGUAGES values ('hu', 'Hungarian');
insert into OWB_UTIL_LANGUAGES values ('hu_HU', 'Hungarian_Hungary');
insert into OWB_UTIL_LANGUAGES values ('is', 'Icelandic');
insert into OWB_UTIL_LANGUAGES values ('is_IS', 'Icelandic_Iceland');
insert into OWB_UTIL_LANGUAGES values ('it', 'Italian');
insert into OWB_UTIL_LANGUAGES values ('it_CH', 'Italian_Switzerland');
insert into OWB_UTIL_LANGUAGES values ('it_IT', 'Italian_Italy');
insert into OWB_UTIL_LANGUAGES values ('iw', 'Hebrew');
insert into OWB_UTIL_LANGUAGES values ('iw_IL', 'Hebrew_Israel');
insert into OWB_UTIL_LANGUAGES values ('ja', 'Japanese');
insert into OWB_UTIL_LANGUAGES values ('ja_JP', 'Japanese_Japan');
insert into OWB_UTIL_LANGUAGES values ('ko', 'Korean');
insert into OWB_UTIL_LANGUAGES values ('ko_KR', 'Korean_South');
insert into OWB_UTIL_LANGUAGES values ('lt', 'Lithuanian');
insert into OWB_UTIL_LANGUAGES values ('lt_LT', 'Lithuanian_Lithuania');
insert into OWB_UTIL_LANGUAGES values ('lv', 'Latvian');
insert into OWB_UTIL_LANGUAGES values ('lv_LV', 'Latvian');
insert into OWB_UTIL_LANGUAGES values ('mk', 'Macedonian');
insert into OWB_UTIL_LANGUAGES values ('mk_MK', 'Macedonian_Macedonia');
insert into OWB_UTIL_LANGUAGES values ('nl', 'Dutch');
insert into OWB_UTIL_LANGUAGES values ('nl_BE', 'Dutch_Belgium');
insert into OWB_UTIL_LANGUAGES values ('nl_NL', 'Dutch_Netherlands');
insert into OWB_UTIL_LANGUAGES values ('no', 'Norwegian');
insert into OWB_UTIL_LANGUAGES values ('no_NO', 'Norwegian_Norway');
insert into OWB_UTIL_LANGUAGES values ('pl', 'Polish');
insert into OWB_UTIL_LANGUAGES values ('pl_PL', 'Polish_Poland');
insert into OWB_UTIL_LANGUAGES values ('pt', 'Portuguese');
insert into OWB_UTIL_LANGUAGES values ('pt_BR', 'Portuguese_Brazil');
insert into OWB_UTIL_LANGUAGES values ('pt_PT', 'Portuguese_Portugal');
insert into OWB_UTIL_LANGUAGES values ('ro', 'Romanian');
insert into OWB_UTIL_LANGUAGES values ('ro_RO', 'Romanian_Romania');
insert into OWB_UTIL_LANGUAGES values ('ru', 'Russian');
insert into OWB_UTIL_LANGUAGES values ('ru_RU', 'Russian_Russia');
insert into OWB_UTIL_LANGUAGES values ('sh', 'Serbo_Croatian');
insert into OWB_UTIL_LANGUAGES values ('sh_YU', 'Serbo_Croatian_Yugoslavia');
insert into OWB_UTIL_LANGUAGES values ('sk', 'Slovak');
insert into OWB_UTIL_LANGUAGES values ('sk_SK', 'Slovak_Slovakia');
insert into OWB_UTIL_LANGUAGES values ('sl', 'Slovenian');
insert into OWB_UTIL_LANGUAGES values ('sl_SI', 'Slovenian_Slovenia');
insert into OWB_UTIL_LANGUAGES values ('sq', 'Albanian');
insert into OWB_UTIL_LANGUAGES values ('sq_AL', 'Albanian_Albania');
insert into OWB_UTIL_LANGUAGES values ('sr', 'Serbian');
insert into OWB_UTIL_LANGUAGES values ('sr_YU', 'Serbian_Yugoslavia');
insert into OWB_UTIL_LANGUAGES values ('sv', 'Swedish');
insert into OWB_UTIL_LANGUAGES values ('sv_SE', 'Swedish_Sweden');
insert into OWB_UTIL_LANGUAGES values ('th', 'Thai');
insert into OWB_UTIL_LANGUAGES values ('th_TH', 'Thai_Thailand');
insert into OWB_UTIL_LANGUAGES values ('tr', 'Turkish');
insert into OWB_UTIL_LANGUAGES values ('tr_TR', 'Turkish_Turkey');
insert into OWB_UTIL_LANGUAGES values ('uk', 'Ukrainian');
insert into OWB_UTIL_LANGUAGES values ('uk_UA', 'Ukrainian_Ukraine');
insert into OWB_UTIL_LANGUAGES values ('zh', 'Chinese');
insert into OWB_UTIL_LANGUAGES values ('zh_CN', 'Chinese_China');
insert into OWB_UTIL_LANGUAGES values ('zh_HK', 'Chinese_Hong');
insert into OWB_UTIL_LANGUAGES values ('zh_TW', 'Chinese_Taiwan');


create table OWB_UTIL_SCRIPTING_TYPES ( 
object_type varchar2(128) not null, 	
scripting_type varchar2(128) not null
);

insert into OWB_UTIL_SCRIPTING_TYPES values ('ActivityTemplate', 'ACTIVITY_TEMPLATE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('ActivityTemplateFolder','ACTIVITY_TEMPLATE_FOLDER');
insert into OWB_UTIL_SCRIPTING_TYPES values ('AdvancedQueue', 'ADVANCED_QUEUE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('ApplicationServerModule', 'APPLICATION_SERVER_MODULE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('BusinessArea', 'BUSINESS_AREA');
insert into OWB_UTIL_SCRIPTING_TYPES values ('CatalogFolder','CATALOG_FOLDER');
insert into OWB_UTIL_SCRIPTING_TYPES values ('Collection','COLLECTION');
insert into OWB_UTIL_SCRIPTING_TYPES values ('ConfigTemplateSet','CONFIGURATION_TEMPLATE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('Condition','CONDITION');
insert into OWB_UTIL_SCRIPTING_TYPES values ('Cube','CUBE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('CustomerApplicationModule','CUSTOMER_APPLICATION_MODULE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('DB2GatewayModule','GATEWAY_MODULE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('DRDAGatewayModule','GATEWAY_MODULE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('DataAuditor','DATA_AUDITOR');
insert into OWB_UTIL_SCRIPTING_TYPES values ('DataProfile','DATA_PROFILE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('DataRule','DATA_RULE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('DataRuleModule','DATA_RULE_MODULE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('DataWarehouse','ORACLE_MODULE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('Dimension','DIMENSION');
insert into OWB_UTIL_SCRIPTING_TYPES values ('DimensionDrillPath','DRILL_PATH');
insert into OWB_UTIL_SCRIPTING_TYPES values ('DrillLevel','DRILL_LEVEL');
insert into OWB_UTIL_SCRIPTING_TYPES values ('DrillLevelKey','DRILL_LEVEL_KEY');
insert into OWB_UTIL_SCRIPTING_TYPES values ('DrillPath','DRILL_PATH');
insert into OWB_UTIL_SCRIPTING_TYPES values ('DrillToDetail','DRILL_TO_DETAIL');
insert into OWB_UTIL_SCRIPTING_TYPES values ('Expert','EXPERT');
insert into OWB_UTIL_SCRIPTING_TYPES values ('ExpertModule','EXPERT_MODULE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('ExternalTable','EXTERNAL_TABLE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('File','FLAT_FILE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('FileModule','FLAT_FILE_MODULE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('Function','FUNCTION');
insert into OWB_UTIL_SCRIPTING_TYPES values ('FunctionLibrary','PACKAGE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('CustomerDatabaseModule','GENERIC_ACCESS_MODULE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('IconSet','ICONSET');
insert into OWB_UTIL_SCRIPTING_TYPES values ('InformixGatewayModule','GATEWAY_MODULE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('Item','ITEM');
insert into OWB_UTIL_SCRIPTING_TYPES values ('ItemFolder','ITEM_FOLDER');
insert into OWB_UTIL_SCRIPTING_TYPES values ('Join','JOIN');
insert into OWB_UTIL_SCRIPTING_TYPES values ('JoinComponent','JOIN_COMPONENT');
insert into OWB_UTIL_SCRIPTING_TYPES values ('ListOfValues','LIST_OF_VALUES');
insert into OWB_UTIL_SCRIPTING_TYPES values ('LogicalTable','LOGICAL_TABLE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('MaterializedView','MATERIALIZED_VIEW');
insert into OWB_UTIL_SCRIPTING_TYPES values ('NestedTable','NESTED_TABLE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('NestedTableType','PLSQL_TABLE_TYPE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('ODBCGatewayModule','GATEWAY_MODULE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('ObjectType','OBJECT_TYPE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('OracleBIModule', 'OBIEE_BUSINESS_DEFINITION_MODULE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('OracleDiscovererModule', 'BUSINESS_DEFINITION_MODULE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('OracleEBusinessSuiteApplication','ORACLE_APPLICATION');
insert into OWB_UTIL_SCRIPTING_TYPES values ('OtherGatewayModule','GATEWAY_MODULE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('PLSQLType','PLSQL_RECORD_TYPE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('PluggableMap','PLUGGABLE_MAPPING');
insert into OWB_UTIL_SCRIPTING_TYPES values ('PluggableMapFolder','PLUGGABLE_MAPPING_FOLDER');
insert into OWB_UTIL_SCRIPTING_TYPES values ('PreDefinedModule','PREDEFINED_MODULE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('Procedure','PROCEDURE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('Process','PROCESS_FLOW');
insert into OWB_UTIL_SCRIPTING_TYPES values ('ProcessActivity','ACTIVITY');
insert into OWB_UTIL_SCRIPTING_TYPES values ('ProcessModule','PROCESS_FLOW_MODULE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('ProcessPackage','PROCESS_FLOW_PACKAGE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('ProfileObject','PROFILE_REFERENCE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('Project','PROJECT');
insert into OWB_UTIL_SCRIPTING_TYPES values ('QueueCapture','QUEUE_CAPTURE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('QueuePropagation','QUEUE_PROPAGATION');
insert into OWB_UTIL_SCRIPTING_TYPES values ('QueueTable','QUEUE_TABLE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('RDBGatewayModule','GATEWAY_MODULE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('RegisteredFunction','REGISTERED_FUNCTION');
insert into OWB_UTIL_SCRIPTING_TYPES values ('SAPApplication','SAP_MODULE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('SQLCollection','SQL_COLLECTION');
insert into OWB_UTIL_SCRIPTING_TYPES values ('Schedule','CALENDAR');
insert into OWB_UTIL_SCRIPTING_TYPES values ('ScheduleModule','CALENDAR_MODULE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('Sequence','SEQUENCE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('SqlserverGatewayModule','GATEWAY_MODULE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('StreamsQueue','STREAMS_QUEUE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('SybaseGatewayModule','GATEWAY_MODULE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('TMSchema','TRANSPORTABLE_MODULE_SCHEMA');
insert into OWB_UTIL_SCRIPTING_TYPES values ('TMTablespace','TRANSPORTABLE_MODULE_TABLESPACE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('Table','TABLE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('TableFunction','TABLE_FUNCTION');
insert into OWB_UTIL_SCRIPTING_TYPES values ('TeradataGatewayModule','GATEWAY_MODULE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('TransformMap','MAPPING');
insert into OWB_UTIL_SCRIPTING_TYPES values ('TransformMapComponent','OPERATOR');
insert into OWB_UTIL_SCRIPTING_TYPES values ('TransportableModule','TRANSPORTABLE_MODULE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('UserDefinedModule','USER_DEFINED_MODULE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('Varray','VARYING_ARRAY');
insert into OWB_UTIL_SCRIPTING_TYPES values ('View','VIEW');
insert into OWB_UTIL_SCRIPTING_TYPES values ('Hierarchy','HIERARCHY');
insert into OWB_UTIL_SCRIPTING_TYPES values ('Level','LEVEL');
insert into OWB_UTIL_SCRIPTING_TYPES values ('LevelAttribute','LEVEL_ATTRIBUTE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('Measure','MEASURE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('Column','COLUMN');
insert into OWB_UTIL_SCRIPTING_TYPES values ('FunctionParameter','PARAMETER');
insert into OWB_UTIL_SCRIPTING_TYPES values ('Record','RECORD');
insert into OWB_UTIL_SCRIPTING_TYPES values ('Field','FIELD');
insert into OWB_UTIL_SCRIPTING_TYPES values ('ForeignKey','FOREIGN_KEY');
insert into OWB_UTIL_SCRIPTING_TYPES values ('Key','UNIQUE_KEY');
insert into OWB_UTIL_SCRIPTING_TYPES values ('EntityMap','GROUP');
insert into OWB_UTIL_SCRIPTING_TYPES values ('TransformMapComponentParameter','ATTRIBUTE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('RefCursorType','PLSQL_REF_CURSOR_TYPE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('MIVModule','CMI_MODULE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('ExternalColumn','COLUMN');
insert into OWB_UTIL_SCRIPTING_TYPES values ('LogicalLocation','LOCATION');
insert into OWB_UTIL_SCRIPTING_TYPES values ('ControlCenter','CONTROL_CENTER');
insert into OWB_UTIL_SCRIPTING_TYPES values ('Connector','CONNECTOR');
insert into OWB_UTIL_SCRIPTING_TYPES values ('MIVDefinition','CMI_DEFINITION');
insert into OWB_UTIL_SCRIPTING_TYPES values ('Role','ROLE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('User','USER');
insert into OWB_UTIL_SCRIPTING_TYPES values ('ChangeSet','SNAPSHOT');
insert into OWB_UTIL_SCRIPTING_TYPES values ('Configuration','CONFIGURATION');
insert into OWB_UTIL_SCRIPTING_TYPES values ('Unknown','UNKNOWN');
insert into OWB_UTIL_SCRIPTING_TYPES values ('RecordField','OBJECT_TYPE_ATTRIBUTE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('PeopleSoftApplication','PEOPLESOFT_APPLICATION');
insert into OWB_UTIL_SCRIPTING_TYPES values ('WebService','WEB_SERVICE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('WebServicePackage','WEB_SERVICE_PACKAGE');
insert into OWB_UTIL_SCRIPTING_TYPES values ('MappingModule','MAPPING_MODULE');
