begin
  declare
    procedure grant_object_privilege
    (
      p_privilege in varchar2,
      p_object_name in varchar2,    
      p_schema in varchar2
    )
    is
    begin
      begin
         execute immediate('grant ' || p_privilege || ' on ' || p_object_name || ' to ' || p_schema);
      exception when others then
         null;
      end;
    end grant_object_privilege;
  begin
    execute immediate('create or replace view wb_rt_adapter_store_view as ' ||
                      'select da.deployment_adapter_id, da.adapter_name, st.store_type_name, st.store_type_version ' ||
                      'from wb_rt_def_deployment_adapters da, wb_rt_def_store_types st ' ||
                      'where st.store_type_id=da.store_type_id');

    grant_object_privilege('select', 'wb_rt_adapter_store_view', 'owbsys');
    grant_object_privilege('select', 'wb_rt_def_store_types', 'owbsys');
    grant_object_privilege('select', 'wb_rt_def_execution_operators', 'owbsys');
    grant_object_privilege('select', 'wb_rt_def_execution_adapters', 'owbsys');
    grant_object_privilege('select', 'wb_rt_def_file_types', 'owbsys');
    grant_object_privilege('select', 'wb_rt_def_system_parameters', 'owbsys');
    grant_object_privilege('select', 'wb_rt_def_deployment_adapters', 'owbsys');
    grant_object_privilege('select', 'wb_rt_def_object_types', 'owbsys');
  
    grant_object_privilege('select', 'wb_rt_audit', 'owbsys');
    grant_object_privilege('select', 'wb_rt_audit_amounts', 'owbsys');
    grant_object_privilege('select', 'wb_rt_audit_custom_parameters', 'owbsys');
    grant_object_privilege('select', 'wb_rt_audit_deployments', 'owbsys');
    grant_object_privilege('select', 'wb_rt_audit_detail', 'owbsys');
    grant_object_privilege('select', 'wb_rt_audit_executions', 'owbsys');
    grant_object_privilege('select', 'wb_rt_audit_files', 'owbsys');
    grant_object_privilege('select', 'wb_rt_audit_messages', 'owbsys');
    grant_object_privilege('select', 'wb_rt_audit_message_lines', 'owbsys');
    grant_object_privilege('select', 'wb_rt_audit_message_parameters', 'owbsys');
    grant_object_privilege('select', 'wb_rt_audit_objects', 'owbsys');
    grant_object_privilege('select', 'wb_rt_audit_parameters', 'owbsys');
    grant_object_privilege('select', 'wb_rt_audit_parameter_defaults', 'owbsys');
    grant_object_privilege('select', 'wb_rt_audit_scripts', 'owbsys');
    grant_object_privilege('select', 'wb_rt_audit_script_runs', 'owbsys');
    grant_object_privilege('select', 'wb_rt_audit_tasks', 'owbsys');
    grant_object_privilege('select', 'wb_rt_audit_units', 'owbsys');
    grant_object_privilege('select', 'wb_rt_errors', 'owbsys');
    grant_object_privilege('select', 'wb_rt_error_rows', 'owbsys');
    grant_object_privilege('select', 'wb_rt_error_sources', 'owbsys');
    grant_object_privilege('select', 'wb_rt_feedback', 'owbsys');
    grant_object_privilege('select', 'wb_rt_operator', 'owbsys');
    grant_object_privilege('select', 'wb_rt_stores', 'owbsys');
    grant_object_privilege('select', 'wb_rt_store_parameters', 'owbsys');
    grant_object_privilege('select', 'wb_rt_tasks', 'owbsys');
    grant_object_privilege('select', 'wb_rt_task_custom_parameters', 'owbsys');
    grant_object_privilege('select', 'wb_rt_task_parameter_defaults', 'owbsys');
    grant_object_privilege('select', 'wb_rt_platform_files', 'owbsys');
    grant_object_privilege('select', 'wb_rt_state_variables', 'owbsys');
    grant_object_privilege('select', 'wb_rt_user_values', 'owbsys');
    grant_object_privilege('select', 'wb_rt_audit_struct', 'owbsys');
    grant_object_privilege('select', 'wb_rt_warehouse_objects', 'owbsys');

    grant_object_privilege('select', 'wb_rt_audit_amounts_seq', 'owbsys');
    grant_object_privilege('select', 'wb_rt_audit_seq', 'owbsys');
    grant_object_privilege('select', 'wb_rt_errors_seq', 'owbsys');
    grant_object_privilege('select', 'wb_rt_error_rows_seq', 'owbsys');
    grant_object_privilege('select', 'wb_rt_error_sources_seq', 'owbsys');
    grant_object_privilege('select', 'wb_rt_feedback_seq', 'owbsys');
    grant_object_privilege('select', 'wb_rt_map_audit_detail_seq', 'owbsys');
    grant_object_privilege('select', 'wb_rt_map_audit_seq', 'owbsys');
    grant_object_privilege('select', 'wb_rt_map_audit_struct_seq', 'owbsys');
    grant_object_privilege('select', 'wb_rt_operator_seq', 'owbsys');
    grant_object_privilege('select', 'wb_rt_platform_catalog_seq', 'owbsys');
    grant_object_privilege('select', 'wb_rt_platform_file_seq', 'owbsys');
    grant_object_privilege('select', 'wb_rt_platform_properties_seq', 'owbsys');
    grant_object_privilege('select', 'wb_rt_platform_task_seq', 'owbsys');
    grant_object_privilege('select', 'wb_rt_rowkey_seq', 'owbsys');
    grant_object_privilege('select', 'wb_rt_system_metadata_seq', 'owbsys');
  end;
end;
/


