begin
  declare
    procedure revoke_object_privilege
    (
      p_privilege in varchar2,
      p_object_name in varchar2,    
      p_schema in varchar2
    )
    is
    begin
      begin
         execute immediate('revoke ' || p_privilege || ' on ' || p_object_name || ' from ' || p_schema);
      exception when others then
         null;
      end;
    end revoke_object_privilege;
  begin
    revoke_object_privilege('select', 'wb_rt_def_store_types', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_def_execution_operators', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_def_execution_adapters', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_def_file_types', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_def_system_parameters', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_def_deployment_adapters', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_def_object_types', 'owbsys');
  
    revoke_object_privilege('select', 'wb_rt_audit', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_audit_amounts', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_audit_custom_parameters', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_audit_deployments', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_audit_detail', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_audit_executions', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_audit_files', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_audit_messages', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_audit_message_lines', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_audit_message_parameters', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_audit_objects', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_audit_parameters', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_audit_parameter_defaults', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_audit_scripts', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_audit_script_runs', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_audit_tasks', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_audit_units', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_errors', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_error_rows', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_error_sources', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_feedback', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_operator', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_stores', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_store_parameters', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_tasks', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_task_custom_parameters', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_task_parameter_defaults', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_platform_files', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_state_variables', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_user_values', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_audit_struct', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_warehouse_objects', 'owbsys');

    revoke_object_privilege('select', 'wb_rt_audit_amounts_seq', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_audit_seq', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_errors_seq', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_error_rows_seq', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_error_sources_seq', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_feedback_seq', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_map_audit_detail_seq', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_map_audit_seq', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_map_audit_struct_seq', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_operator_seq', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_platform_catalog_seq', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_platform_file_seq', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_platform_properties_seq', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_platform_task_seq', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_rowkey_seq', 'owbsys');
    revoke_object_privilege('select', 'wb_rt_system_metadata_seq', 'owbsys');

    revoke_object_privilege('select', 'wb_rt_adapter_store_view', 'owbsys');
    execute immediate('drop view wb_rt_adapter_store_view');
  end;
end;
/


