begin
  declare
    l_error number;
    l_count number;
    l_first_err varchar2(650);
    
    function getErrorM return varchar2
    is
       l_message varchar2(512);
    begin
       for e in (
         select text from user_errors order by line
       )
       loop
         if (length(l_message)+length(e.text)<512) then
            l_message := l_message || e.text;
         else
            l_message := l_message || substr(e.text, 1, 512-length(e.text)-length(l_message));
         end if;
       end loop;
       return l_message;
    end getErrorM;
    
  begin
    l_error := 0;
    l_count := 0;
    for p in (
      select 
        object_name 
      from 
        user_objects where object_type='PACKAGE' and status ='INVALID'
    )
    loop
      l_count := l_count+1;
      begin
        execute immediate 'alter package ' || p.object_name || ' compile';
      exception
       when others then
         l_error := l_error+1;
         if (l_error = 1) then
            l_first_err := 'Package ' || p.object_name || ' spec failed with "' || getErrorM || '"';
         end if;
      end;
    end loop;
    
    for p in (
      select 
        object_name 
      from 
        user_objects where object_type='PACKAGE BODY' and status ='INVALID'
    )
    loop
      l_count := l_count+1;
      begin
        execute immediate 'alter package ' || p.object_name || ' compile body';
      exception
       when others then
         l_error := l_error+1;
         if (l_error = 1) then
            l_first_err := 'Package ' || p.object_name || ' body failed with "' || getErrorM || '"';
         end if;
      end;
    end loop;    
    if l_error!=0 then
      raise_application_error(-20123, 'Error compiling ' || l_error ||
              ' out of ' || l_count || ' invalid package component(s). e.g. ' || l_first_err );
    end if;
  end;
end;
/
