begin
declare
  l_cursor number;
  l_java_query varchar2(100);
  l_numrows integer;
  l_name varchar2(200);
  l_classname varchar2(200);
begin

  l_cursor := dbms_sql.open_cursor;
  l_java_query := 'select name from java$class$md5$table where name like ''oracle/wh/%''';

  begin
  
     dbms_sql.parse(l_cursor, l_java_query, DBMS_SQL.V7);
     dbms_sql.define_column(l_cursor, 1, l_name, 200);
     l_numrows := dbms_sql.execute(l_cursor);
     
     loop
        if dbms_sql.fetch_rows(l_cursor) = 0 then
           exit;
        end if;
        
        dbms_sql.column_value(l_cursor, 1, l_classname);
        dbms_java.dropjava(l_classname);
        
     end loop;
     
     dbms_sql.close_cursor(l_cursor);
     
  exception
     when others then
      begin
        for j in (
          select 
            name
          from
            user_java_classes
          where
             name like 'oracle/wh/%'
        )
        loop
           dbms_java.dropjava(j.name);
        end loop;
      exception
        when others
         then
           null;
      end; 
  end;

end;
end;
/


