#!/bin/sh

######################################################################################################
# global configuration (only applied to Application Server)
# make sure you have permissions to write to AS_HOME
# ??? can we get info from test.cfg now??? since test.cfg is generated from the page, then we should 
#     be able to get the info.
# ??? which info are needed??? "app name" for install jrt, "repos_host, repos_port, repos_serivce" 
#     for install AuditDS
######################################################################################################
AS_HOME="/scratch/swu/download/OracleAS"
SETUP_HOME="$OWB_HOME/owb/misc/setup_as"
AS_USER="oc4jadmin"
deploy_uri="deployer:oc4j:opmn://localhost:6004/home"
jrt_application="jrt"
audit_uri="localhost:1521/ora111.us.oracle.com"
secure_web_port="4445"
if [ $# -eq 1 ]
then
  echo "the parameter will be used as password, others will use default value!"
  AS_PSWD=$1
elif [ $# -eq 8 ]
then
  echo "get values from parameters!"
  AS_HOME=$1
  SETUP_HOME=$2
  AS_USER=$3
  AS_PSWD=$4
  deploy_uri=$5
  jrt_application=$6
  audit_uri=$7
  secure_web_port=$8
else
  echo "wrong parameters! either provide 1 parameter for \"AS_PSWD\" or provide 8 parameters for \"AS_HOME SETUP_HOME AS_USER AS_PSWD deploy_uri jrt_application audit_uri secure_web_port\""
  exit 1
fi

ORACLE_HOME="$ADE_VIEW_ROOT/oracle"
LD_LIBRARY_PATH="$ORACLE_HOME/lib"
JAVA_HOME="$OWB_HOME/jdk"
jrt_ear="$OWB_HOME/owb/jrt/applications/jrt.ear"


######################################################################################################
# clean environment
# make sure files are not modified and make sure opmn is up
######################################################################################################
# stop opmn
echo "@@@@@@@@@@@@@@@@@@@@stop opmn if it is running"
cd $AS_HOME/opmn/bin
./opmnctl shutdown
# restore opmn/conf
if [ -e $AS_HOME/opmn/conf.tar ]
then
  echo "@@@@@@@@@@@@@@@@@@@@restore opmn/conf"
  cd $AS_HOME/opmn/conf
  rm -rf *
  cp ../conf.tar .
  tar xvf conf.tar
  rm conf.tar
fi
# restore j2ee/home/config
if [ -e $AS_HOME/j2ee/home/config.tar ]
then
  echo "@@@@@@@@@@@@@@@@@@@@restore j2ee/home/config"
  cd $AS_HOME/j2ee/home/config
  rm -rf *
  cp ../config.tar .
  tar xvf config.tar
  rm config.tar
fi
# restore j2ee/home/application-deployments
if [ -e $AS_HOME/j2ee/home/application-deployments.tar ]
then
  echo "@@@@@@@@@@@@@@@@@@@@restore j2ee/home/application-deployments"
  cd $AS_HOME/j2ee/home/application-deployments
  rm -rf *
  cp ../application-deployments.tar .
  tar xvf application-deployments.tar
  rm application-deployments.tar
fi
# restore j2ee/home/log
if [ -e $AS_HOME/j2ee/home/log.tar ]
then
  echo "@@@@@@@@@@@@@@@@@@@@restore j2ee/home/log"
  cd $AS_HOME/j2ee/home/log
  rm -rf *
  cp ../log.tar .
  tar xvf log.tar
  rm log.tar
fi
# restore applib
echo "@@@@@@@@@@@@@@@@@@@@restore applib"
cd $AS_HOME/j2ee/home/applib
rm -rf *.jar *.zip
# restart opmn
echo "@@@@@@@@@@@@@@@@@@@@start opmn"
cd $AS_HOME/opmn/bin
./opmnctl startall
# clean audit table
echo "@@@@@@@@@@@@@@@@@@@@clean audit table"
cd $ORACLE_HOME/bin
./sqlplus OWBSYS/OWBSYS@$audit_uri @$SETUP_HOME/clean_audit_table.sql


######################################################################################################
#0, copy jdbc drivers and jython jars
######################################################################################################
echo "@@@@@@@@@@@@@@@@@@@@copy necessary jar files to applib"
cd $AS_HOME/j2ee/home/applib
cp $OWB_HOME/owb/lib/non_ship/ext_copy/*.jar .
cp $OWB_HOME/owb/lib/int/jython_lib.zip .
cp $OWB_HOME/owb/lib/int/jython_owblib.jar .


######################################################################################################
#1, modify opmn.xml and set PATH (different if OC4J not AS)
######################################################################################################
echo "@@@@@@@@@@@@@@@@@@@@modify opmn.xml to set variables and jython library"
    cd $AS_HOME/opmn/conf
    /bin/tar cvf conf.tar *
    mv conf.tar ../
    cp $SETUP_HOME/env_variables.xml .
    sed -e 's/AppendRatio=3/AppendRatio=3 -Doracle.j2ee.home=$ORACLE_HOME\/j2ee\/home -Dpython.path=$ORACLE_HOME\/j2ee\/home\/applib\/jython_lib.zip:$ORACLE_HOME\/j2ee\/home\/applib\/jython_owblib.jar/g' opmn.xml > opmn.xml.v1
    sed -e 's=\$ORACLE_HOME='"$AS_HOME"'=g' opmn.xml.v1 > opmn.xml
    sed -e '/ias-component id=\"default_group\"/r env_variables.xml' opmn.xml > opmn.xml.v1
    sed -e 's=\$ORACLE_HOME='"$ORACLE_HOME"'=g' opmn.xml.v1 > opmn.xml


######################################################################################################
#2, modify j2ee-logging.xml
######################################################################################################
echo "@@@@@@@@@@@@@@@@@@@@add jrt log handler"
cd $AS_HOME/j2ee/home/config
/bin/tar cvf config.tar *
mv config.tar ../
cp $SETUP_HOME/log_handler.xml $SETUP_HOME/logger.xml .
sed -e '/[^/]log_handlers/r log_handler.xml' j2ee-logging.xml > j2ee-logging.xml.v1
sed -e '/[^/]loggers/r logger.xml' j2ee-logging.xml.v1 > j2ee-logging.xml
echo "@@@@@@@@@@@@@@@@@@@@backup application-deployments"
cd $AS_HOME/j2ee/home/application-deployments
/bin/tar cvf application-deployments.tar *
mv application-deployments.tar ../
echo "@@@@@@@@@@@@@@@@@@@@backup logs"
cd $AS_HOME/j2ee/home/log
/bin/tar cvf log.tar *
mv log.tar ../


######################################################################################################
#3, copy km_permission.properties
######################################################################################################
echo "@@@@@@@@@@@@@@@@@@@@copy ct_permissions.properties to j2ee/home/config"
cp $OWB_HOME/owb/bin/non_ship/ct_permissions.properties $AS_HOME/j2ee/home/config/


######################################################################################################
#4, set up security roles
######################################################################################################
echo "@@@@@@@@@@@@@@@@@@@@add security roles and users"
$JAVA_HOME/bin/java -jar $AS_HOME/j2ee/home/jazn.jar -user $AS_USER -password $AS_PSWD -addrole "jazn.com" "OWB_J2EE_EXECUTOR"
$JAVA_HOME/bin/java -jar $AS_HOME/j2ee/home/jazn.jar -user $AS_USER -password $AS_PSWD -addrole "jazn.com" "OWB_J2EE_OPERATOR"
$JAVA_HOME/bin/java -jar $AS_HOME/j2ee/home/jazn.jar -user $AS_USER -password $AS_PSWD -grantrole "OWB_J2EE_EXECUTOR" "jazn.com" -role "OWB_J2EE_OPERATOR"
$JAVA_HOME/bin/java -jar $AS_HOME/j2ee/home/jazn.jar -user $AS_USER -password $AS_PSWD -grantrole "oc4j-administrators" "jazn.com" -role "OWB_J2EE_OPERATOR"
$JAVA_HOME/bin/java -jar $AS_HOME/j2ee/home/jazn.jar -user $AS_USER -password $AS_PSWD -addrole "jazn.com" "OWB_J2EE_ADMINISTRATOR"
$JAVA_HOME/bin/java -jar $AS_HOME/j2ee/home/jazn.jar -user $AS_USER -password $AS_PSWD -grantrole "OWB_J2EE_EXECUTOR" "jazn.com" -role "OWB_J2EE_ADMINISTRATOR"
$JAVA_HOME/bin/java -jar $AS_HOME/j2ee/home/jazn.jar -user $AS_USER -password $AS_PSWD -grantrole "OWB_J2EE_OPERATOR" "jazn.com" -role "OWB_J2EE_ADMINISTRATOR"
$JAVA_HOME/bin/java -jar $AS_HOME/j2ee/home/jazn.jar -user $AS_USER -password $AS_PSWD -grantrole "OWB_J2EE_ADMINISTRATOR" "jazn.com" "oc4jadmin"
$JAVA_HOME/bin/java -jar $AS_HOME/j2ee/home/jazn.jar -user $AS_USER -password $AS_PSWD -grantrole "oc4j-app-administrators" "jazn.com" "oc4jadmin"
$JAVA_HOME/bin/java -jar $AS_HOME/j2ee/home/jazn.jar -user $AS_USER -password $AS_PSWD -addrole "jazn.com" "OWB_INTERNAL_USERS"


######################################################################################################
#5, create jms queques (here, AS should be up)
######################################################################################################
echo "@@@@@@@@@@@@@@@@@@@@create owbQueue and owb_abortQueue"
$JAVA_HOME/bin/java -jar $AS_HOME/j2ee/home/admin_client.jar $deploy_uri $AS_USER $AS_PSWD -addDestination -domain "QUEUE" -name "owbQueue" -jndiLocation "jms/owbQueue"
$JAVA_HOME/bin/java -jar $AS_HOME/j2ee/home/admin_client.jar $deploy_uri $AS_USER $AS_PSWD -addDestination -domain "QUEUE" -name "owb_abortQueue" -jndiLocation "jms/owb_abortQueue"


######################################################################################################
#6, set up audit table data source (here, AS should be up)
######################################################################################################
echo "@@@@@@@@@@@@@@@@@@@@setup audit table data source"
$JAVA_HOME/bin/java -jar $AS_HOME/j2ee/home/admin_client.jar $deploy_uri $AS_USER $AS_PSWD -addDataSourceConnectionPool -applicationName "default" -name "OWBSYS Audit Connection Pool" -factoryClass "oracle.jdbc.pool.OracleDataSource" -dbUser "owbsys_audit" -dbPassword "owbsys_audit" -url "jdbc:oracle:thin:@//$audit_uri"
$JAVA_HOME/bin/java -jar $AS_HOME/j2ee/home/admin_client.jar $deploy_uri $AS_USER $AS_PSWD -addManagedDataSource -applicationName "default" -name "AuditDS" -jndiLocation "jdbc/AuditDS" -connectionPoolName "OWBSYS Audit Connection Pool"


######################################################################################################
#7, create secure-web-site
######################################################################################################
echo "@@@@@@@@@@@@@@@@@@@@add secure web site"
cd $AS_HOME/j2ee/home/config
cp $OWB_HOME/owb/jrt/config/serverkeystore.jks .
cp $SETUP_HOME/secure-web-site.tpl .
sed -e 's=\$AS_HOME='"$AS_HOME"'=g' secure-web-site.tpl > secure-web-site.xml.v1
sed -e 's=\$secure_web_port='"$secure_web_port"'=g' secure-web-site.xml.v1 > secure-web-site.xml
sed -e '/default-web-site.xml/ a \<web-site path=\"./secure-web-site.xml\" \/\>' server.xml > server.xml.v1
cp server.xml.v1 server.xml


######################################################################################################
#8, restart AS to make the changes take effect (different if OC4J not AS)
######################################################################################################
echo "@@@@@@@@@@@@@@@@@@@@restart opmn"
    cd $AS_HOME/opmn/bin
    ./opmnctl stopall
    ./opmnctl startall


######################################################################################################
#9, install jrt to AS
# !!! problems!!!, sqlldr needed info, secure-web-port range needed in opmn.xml
# !!! problems!!!, how about if the application.ear is not removed, and re-deploy it???
######################################################################################################
echo "@@@@@@@@@@@@@@@@@@@@install jrt.ear"
$JAVA_HOME/bin/java -jar $AS_HOME/j2ee/home/admin_client.jar $deploy_uri $AS_USER $AS_PSWD -deploy -file $jrt_ear -deploymentName $jrt_application
echo "@@@@@@@@@@@@@@@@@@@@bind to web site"
$JAVA_HOME/bin/java -jar $AS_HOME/j2ee/home/admin_client.jar $deploy_uri $AS_USER $AS_PSWD -bindWebApp -appName $jrt_application -webModuleName "jrtws" -contextRoot "/$jrt_application"
