#!/bin/sh
#
# $Header: patch_paris_repos.sh 14-mar-2006.10:35:02 jfklein Exp $
#
# patch_paris_repos.sh
#
# Copyright (c) 2006, Oracle. All rights reserved.  
#
#    NAME
#      patch_paris_repos.sh - upgrade OWB repository to current version
#
#    DESCRIPTION
#      This script can be used to patch a repository for the latest build. It
#    assumes that the base repository version is 10.1.2.5.44 or later.
#
#    NOTES
#      USAGE:
#        Change default directory to <OWB-HOME>/owb/UnifiedRepos
#        ./patch_paris_repos.sh
#            <host> <port> <svcName> <dbaUsr> <dbaPwd> <owbUsr> <owbPwd>
#        Where::
#          <host>/<port>/<svcName> - Connection information for Oracle
#                                   instance containing the OWB repository to
#                                   be upgraded.
#          <dbaUsr>/<dbaPwd> - Name/Password for user with dba priviledges.
#                             This user will be logged on AS SYSDBA to execute
#                             the patch_paris_repos_sys.sql script.
#          <owbUsr>/<owbPwd> - Name/Password for OWB repository owner. This
#                             user will be logged on to execute the
#                             patch_paris_repos.sql script and also to execute
#                             the owb_uprop_nls table load in this script.
#      CUSTOMIZATION:
#        The nls translation set for each language is fairly large and this
#      script defaults to installing all of them. (This is to match the
#      behavior of the standard repository installation.) The execution time
#      of this script can be improved by removing any non-required language
#      sets in the OWB_UPROP_NLS_FILES variable declaration. Tests on linux
#      with a local database show savings of approximately 2.5min/language.
#      (Initial run with just base (en) = 3:11, 2nd run adding de = 5:53,
#       3rd run with all languages = 23min)
#
#
#
#    MODIFIED   (MM/DD/YY)
#    jfklein     03/14/06 - 
#    bjeffrie    02/24/06 - Creation
#

echo =======================================
echo ===== patch_paris_repos Executing =====
echo =======================================
echo

HOST=$1
PORT=$2
SVCNAME=$3
DBAUSR=$4
DBAPWD=$5
OWBUSR=$6
OWBPWD=$7

CURDIR=`pwd`
EXEDIR=../bin/unix
cd $EXEDIR

eval `cat ../unix/setowbenv.sh`

# Note: All external files referenced from EXEDIR
PATCH_FILES_DIR=../../UnifiedRepos
# Note: sql files must have final 'exit;'
DBA_PATCH_FILE=$PATCH_FILES_DIR/patch_paris_repos_sys.sql
OWB_PATCH_FILE=$PATCH_FILES_DIR/patch_paris_repos.sql

NLS_FILES_DIR=../../browserasst/views
# REQUIRED!
OWB_UPROP_NLS_FILES=$NLS_FILES_DIR/owb_uprop_nls.xml
# Optional, may comment out those not needed.
OWB_UPROP_NLS_FILES=$OWB_UPROP_NLS_FILES $NLS_FILES_DIR/owb_uprop_nls_de.xml
OWB_UPROP_NLS_FILES=$OWB_UPROP_NLS_FILES $NLS_FILES_DIR/owb_uprop_nls_es.xml
OWB_UPROP_NLS_FILES=$OWB_UPROP_NLS_FILES $NLS_FILES_DIR/owb_uprop_nls_fr.xml
OWB_UPROP_NLS_FILES=$OWB_UPROP_NLS_FILES $NLS_FILES_DIR/owb_uprop_nls_it.xml
OWB_UPROP_NLS_FILES=$OWB_UPROP_NLS_FILES $NLS_FILES_DIR/owb_uprop_nls_ja.xml
OWB_UPROP_NLS_FILES=$OWB_UPROP_NLS_FILES $NLS_FILES_DIR/owb_uprop_nls_ko.xml
OWB_UPROP_NLS_FILES=$OWB_UPROP_NLS_FILES $NLS_FILES_DIR/owb_uprop_nls_pt_BR.xml
OWB_UPROP_NLS_FILES=$OWB_UPROP_NLS_FILES $NLS_FILES_DIR/owb_uprop_nls_zh_CN.xml


${ORACLE_HOME}/bin/sqlplus ${DBAUSR}/${DBAPWD} AS SYSDBA@${HOST}:${PORT}/${SVCNAME} @${DBA_PATCH_FILE}

${ORACLE_HOME}/bin/sqlplus ${OWBUSR}/${OWBPWD}@${HOST}:${PORT}/${SVCNAME} @${OWB_PATCH_FILE}

echo
echo ========================================
echo ===== load owb_uprop_nls Executing =====
echo ========================================

./jvm.sh -classpath ../../../lib/transx.zip:../../../lib/xschema.jar:../../../lib/xsu12.jar:../../../rdbms/jlib/xdb.jar:../../lib/int/rtpplatform.jar:../../lib/int/rtpcommon.jar:../../../jdbc/lib/ojdbc14.jar:../../../lib/xmlparserv2.jar:../../../sqlj/lib/runtime12.jar:../../../jdk/jre/lib/rt.jar oracle.xml.transx.loader  "(DESCRIPTION=(ADDRESS=(PROTOCOL=TCP)(HOST=${HOST})(PORT=${PORT}))(CONNECT_DATA=(SERVICE_NAME=${SVCNAME})))" ${OWBUSR} ${OWBPWD} ${OWB_UPROP_NLS_FILES}

echo ========================================
echo ===== load owb_uprop_nls Finished  =====
echo ========================================
echo

cd $CURDIR
echo =======================================
echo ===== patch_paris_repos Finished  =====
echo =======================================
