#!/bin/csh

# $Header: wfjvlsnr.sbs 26.5 2005/11/10 22:09:32 viksingh noship $
#
# Workflow JAVA Execution Agent Startup script.
#
# ENVIRONMENT
#
# HISTORY
#   20 Oct 2000  S Mayze     Created
#   30 Nov 2000  M Craig     Modified to use classpath in JRE
#   02 Jul 2001  S Mayze     Modified to support new charset syntax

#
# Usage
#
#    wfjvlsnr <user>/<passwd>@<dbconn> [charset]
#    wfjvlsnr "<user> <passwd> <dbconn> [oci8]" [charset]
#    wfjvlsnr "<user> <passwd> <dbconn> thin" [charset]
#  where <dbconn> is host:port:sid for thin
#

set PROG=$0
set PROG=$PROG:t
echo "Workflow JAVA Execution Agent"
if ($#argv < 1) then
  echo "Usage: $PROG <user>/<pwd>@<database>"
  exit 1;
endif

#
# Set the character set if one has
# been specified
#
set WF_CHARSET=
if ("$2" != "") then
   set WF_CHARSET="-DCHARSET=$2"
endif

#
# Log file
#
set LOG=$PROG:r.log
cat <<END >> $LOG
Workflow JAVA Execution Agent Log
END
if ($status != 0) then
  echo "Error:  can't write log file"
  exit 1
endif

#
# Execute the JAVA Execution Agent 
#
set WF_CLASSPATH=%ORACLE_HOME%/jdk/jre/lib/rt.jar:%ORACLE_HOME%/wf/java:%ORACLE_HOME%/jlib/wfjava.jar:%ORACLE_HOME%/lib/xmlparserv2.jar:%ORACLE_HOME%/jlib/fndctx.jar:%ORACLE_HOME%/jlib/wfapi.jar:%ORACLE_HOME%/wf/lib/ojdbc14.jar:%ORACLE_HOME%/jlib/share.jar:%ORACLE_HOME%/jlib/ewt3.jar:%ORACLE_HOME%/jlib/ewt3-nls.jar:%ORACLE_HOME%/jlib/swingall-1_1_1.jar:%ORACLE_HOME%/jlib/orai18n-collation.jar:%ORACLE_HOME%/jlib/orai18n-mapping.jar

"%ORACLE_HOME%/jdk/bin/java" -classpath "$WF_CLASSPATH" $WF_CHARSET oracle.apps.fnd.wf.WFFALsnr $1 | tee -a $LOG

