create or replace package wmp_api_administration as

	TNSNAME varchar(10) := 'TNSNAME';
	HOSTINFO varchar2(10) := 'HOSTINFO';
	EDIT varchar2(10) := 'EDIT';
	NEW varchar2(10) := 'NEW';
	UPD varchar2(10) := 'UPDATE';
	DEL varchar2(10) := 'DELETE';
	CONT varchar2(10) := 'CONTENT';

	function repository_version(p_dblink in varchar2) return varchar2;

	procedure purge_users;
	
	function register_repository
	(
		p_name in varchar2,
		p_host_name in varchar2 := null,
		p_db_sid in varchar2 := null,
		p_repos_schema in varchar2 := null,
		p_dblink_name in varchar2,
		p_description in varchar2 := null
	) return number;
	
	procedure modify_repository
	(
		p_repository_id in number,
		p_name in varchar2,
		p_host_name in varchar2 := null,
		p_db_sid in varchar2 := null,
		p_repos_schema in varchar2 := null,
		p_dblink_name in varchar2,
		p_description in varchar2
	);

	procedure unregister_repository
	(
		p_repository_id in number
	);
	
	procedure grant_repository_to_user
	(
		p_repository_id in number,
		p_user_id in number
	);

	procedure revoke_repository_from_user
	(
		p_repository_id in number,
		p_user_id in number
	);
	
	procedure grant_role_to_user
	(
		p_role_name in varchar2,
		p_user_id in number
	);

	procedure revoke_role_from_user
	(
		p_role_name in varchar2,
		p_user_id in number
	);
	
	procedure grant_portlet_to_user
	(
		p_portlet_name in varchar2,
		p_user_id in number
	);
	
	procedure revoke_portlet_from_user
	(
		p_portlet_name in varchar2,
		p_user_id in number
	);
	
	procedure grant_repository_to_group
	(
		p_repository_id in number,
		p_group_id in number
	);

	procedure revoke_repository_from_group
	(
		p_repository_id in number,
		p_group_id in number
	);
	
	procedure grant_role_to_group
	(
		p_role_name in varchar2,
		p_group_id in number
	);

	procedure revoke_role_from_group
	(
		p_role_name in varchar2,
		p_group_id in number
	);
	
	procedure grant_portlet_to_group
	(
		p_portlet_name in varchar2,
		p_group_id in number
	);
	
	procedure revoke_portlet_from_group
	(
		p_portlet_name in varchar2,
		p_group_id in number
	);
	
	function register_custom_report
	(
		p_repository_id in varchar2,
		p_report_display_name in varchar2,
		p_type_name in varchar2,
		p_report_helper in varchar2
	) return number;
	
	procedure modify_custom_report
	(
		p_report_id number,
		p_repository_id in varchar2,
		p_report_display_name in varchar2,
		p_type_name in varchar2,
		p_report_helper in varchar2
	);
	
	procedure unregister_custom_report
	(
		p_report_id number
	);
	
	procedure add_custom_report_to_role
	(
		p_report_id in number,
		p_role_name in varchar2
	);
	
	procedure remove_custom_report_from_role
	(
		p_report_id in number,
		p_role_name in varchar2
	);
		
	function administration_url return varchar2;
	function administration_hlink(p_text in varchar2, p_force_reload in boolean := false ,
					is_full_page in boolean := false) return varchar2;
	

end wmp_api_administration;