create or replace package wmp_api_favorites as

	procedure add_navigation_favorite (
		p_repository_id in number
		,p_role in varchar2
		,p_type_name in varchar2
		,p_id in number
		,p_redirect_url in varchar2
	);

	procedure add_report_favorite (
		p_repository_id number
		,p_role varchar2
		,p_report_id number
		,p_id number
		,p_redirect_url in varchar2
	);

	procedure delete_navigation_favorite (
		p_favorite_id in number
		,p_redirect_url in varchar2
		,p_reference_path in varchar2 := null
		,p_back_url in varchar2 := null
	);

	procedure delete_report_favorite (
		p_favorite_id number
		,p_redirect_url in varchar2
		,p_reference_path in varchar2 := null
		,p_back_url in varchar2 := null 
	);

	procedure edit_favorite (
		p_favorite_id in number
		,p_request in varchar2
		,p_desc in varchar2
		,p_redirect_url in varchar2 := null
		,p_reference_path in varchar2 := null
		,p_back_url in varchar2 := null
	);

	function favorites_url return varchar2;
	function favorites_hlink(p_text in varchar2, p_force_reload in boolean := false) return varchar2;

	function add_navigation_favorite_url(p_repository_id in number, p_role_name in varchar2,
		p_type_name in varchar2, p_id in number, p_redirect_url in varchar2) return varchar2;
	function add_report_favorite_url(p_repository_id number, p_role_name varchar2, p_report_id number,
		p_id number, p_redirect_url in varchar2) return varchar2;

	function add_navigation_favorite_hlink(p_text in varchar2, p_repository_id in number, p_role_name in varchar2,
		p_type_name in varchar2, p_id in number, p_redirect_url in varchar2) return varchar2;
	function add_report_favorite_hlink(p_text in varchar2, p_repository_id number, p_role_name varchar2, p_report_id number,
		p_id number, p_redirect_url in varchar2) return varchar2;

	function del_navigation_favorite_hlink(p_text in varchar2, p_favorite_id in number, 
						p_redirect_url in varchar2
						,p_reference_path in varchar2 := null
						,p_back_url in varchar2 := null ) return varchar2;
						
	function del_report_favorite_hlink(p_text in varchar2, p_favorite_id in number, 
						p_redirect_url in varchar2
						,p_reference_path in varchar2 := null
						,p_back_url in varchar2 := null ) return varchar2;

	function edit_navigation_favorite_hlink(p_text in varchar2, p_favorite_id in number, 
	 p_redirect_url in varchar2, p_reference_path in varchar2 := null, 
	 p_back_url in varchar2 := null) return varchar2;
	
	function edit_report_favorite_hlink(p_text in varchar2, p_favorite_id in number,
	 p_redirect_url in varchar2, p_reference_path in varchar2 := null, 
	 p_back_url in varchar2 := null) return varchar2;


	function get_object_name(p_repository_id in number, p_role in varchar2, p_type_name in varchar2, p_id in number) return varchar2;
	function get_favorite_type(p_favorite_id in number) return varchar2;
	function favorites_customize_url return varchar2;

end wmp_api_favorites;