create or replace package wmp_api_nls as
 
	WM_DOMAIN	VARCHAR2(128) := 'wm';
	GENERIC		VARCHAR2(128) := '10000';
	NLSLANGUAGE	VARCHAR2(128) := 'nlslanguage';
	NLSPATH		VARCHAR2(128) := 'wm.nls';
	ENGLISH		VARCHAR2(128) := 'us';

	BYPORTAL	varchar2(20) := 'S';
	BYGROUP		varchar2(20) := 'G';
	BYUSER		varchar2(20) := 'U';

	ORACLE		varchar2(20) := 'Oracle';
	JAVA		varchar2(20) := 'Java';
	MS		varchar2(20) := 'Microsoft';

	function get_language (p_setting in varchar2 default null)
	return varchar2;

	function get_nls_language (p_vendor in varchar2 default null)
	return varchar2;

	function get_string (
		p_name in varchar2,
		p_sub_domain varchar2 default null,
		p_language in varchar2 default null,
		p_setting in varchar2 default null,
		p0 in varchar2 default null,
		p1 in varchar2 default null,
		p2 in varchar2 default null,
		p3 in varchar2 default null,
		p4 in varchar2 default null,
		p5 in varchar2 default null,
		p6 in varchar2 default null,
		p7 in varchar2 default null,
		p8 in varchar2 default null,
		p9 in varchar2 default null
		)
	return varchar2;

	function get_string_of_location (
		p_location_type in varchar2,
		p_sub_domain varchar2 default null,
		p_language in varchar2 default null,
		p_setting in varchar2 default null,
		p0 in varchar2 default null,
		p1 in varchar2 default null,
		p2 in varchar2 default null,
		p3 in varchar2 default null,
		p4 in varchar2 default null,
		p5 in varchar2 default null,
		p6 in varchar2 default null,
		p7 in varchar2 default null,
		p8 in varchar2 default null,
		p9 in varchar2 default null
		)
	return varchar2;

	function get_string_of_functionlibrary (
		p_functionlib_type in varchar2,
		p_sub_domain varchar2 default null,
		p_language in varchar2 default null,
		p_setting in varchar2 default null,
		p0 in varchar2 default null,
		p1 in varchar2 default null,
		p2 in varchar2 default null,
		p3 in varchar2 default null,
		p4 in varchar2 default null,
		p5 in varchar2 default null,
		p6 in varchar2 default null,
		p7 in varchar2 default null,
		p8 in varchar2 default null,
		p9 in varchar2 default null
		)
	return varchar2;

	function get_string_of_function (
		p_function_type in varchar2,
		p_sub_domain varchar2 default null,
		p_language in varchar2 default null,
		p_setting in varchar2 default null,
		p0 in varchar2 default null,
		p1 in varchar2 default null,
		p2 in varchar2 default null,
		p3 in varchar2 default null,
		p4 in varchar2 default null,
		p5 in varchar2 default null,
		p6 in varchar2 default null,
		p7 in varchar2 default null,
		p8 in varchar2 default null,
		p9 in varchar2 default null
		)
	return varchar2;

	function get_string_of_activity (
		p_activity_type in varchar2,
		p_sub_domain varchar2 default null,
		p_language in varchar2 default null,
		p_setting in varchar2 default null,
		p0 in varchar2 default null,
		p1 in varchar2 default null,
		p2 in varchar2 default null,
		p3 in varchar2 default null,
		p4 in varchar2 default null,
		p5 in varchar2 default null,
		p6 in varchar2 default null,
		p7 in varchar2 default null,
		p8 in varchar2 default null,
		p9 in varchar2 default null
		)
	return varchar2;

	function get_string_of_key (
		p_is_primary in varchar2,
		p_sub_domain varchar2 default null,
		p_language in varchar2 default null,
		p_setting in varchar2 default null,
		p0 in varchar2 default null,
		p1 in varchar2 default null,
		p2 in varchar2 default null,
		p3 in varchar2 default null,
		p4 in varchar2 default null,
		p5 in varchar2 default null,
		p6 in varchar2 default null,
		p7 in varchar2 default null,
		p8 in varchar2 default null,
		p9 in varchar2 default null
		)
	return varchar2;

	function get_string_of_operator (
		p_operator_type in varchar2,
		p_sub_domain varchar2 default null,
		p_language in varchar2 default null,
		p_setting in varchar2 default null,
		p0 in varchar2 default null,
		p1 in varchar2 default null,
		p2 in varchar2 default null,
		p3 in varchar2 default null,
		p4 in varchar2 default null,
		p5 in varchar2 default null,
		p6 in varchar2 default null,
		p7 in varchar2 default null,
		p8 in varchar2 default null,
		p9 in varchar2 default null
		)
	return varchar2;

	function translate_string (
		p_text in varchar2,
		p_sub_domain varchar2 default null,
		p_language in varchar2 default null,
		p_setting in varchar2 default null
		)
	return varchar2;

	function is_existing_string (
		p_name in varchar2,
		p_sub_domain varchar2,
		p_language in varchar2
		)
	return boolean;

	function add_string (
		p_name in varchar2, 
		p_value in varchar2, 
		p_language in varchar2 default ENGLISH,
		p_sub_domain in varchar2 default null,
		p_domain in varchar2 default WM_DOMAIN
		)
	return number;

end wmp_api_nls;