create or replace package wmp_api_session as

	type option_array is table of varchar2(2000) index by binary_integer;

	PREFERENCESOWBPATH varchar2(256) := 'wm.preferences.owb';
	MLSOPTION varchar2(20) := 'mls';

	FAVORITES	varchar2(20) :=	'10235';
	FAVORITESDISPLAYPATH varchar2(256) := 'wm.favorites.display';
	FAVORITESPORTLETPATH varchar2(256) := 'wm.favorites.portlet';
	FAVORITESPREVIEWPATH varchar2(256) := 'wm.favorites.preview';

	NAVIGATION	varchar2(20) :=	'10268';
	NAVIGATIONDISPLAYPATH varchar2(256) := 'wm.navigation.display';
	NAVIGATIONPORTLETPATH varchar2(256) := 'wm.navigation.portlet';
	NAVIGATIONPREVIEWPATH varchar2(256) := 'wm.navigation.preview';

	REPORTSPORTLETPATH varchar2(256) := 'wm.reports.portlet';
	REPORTSPREVIEWPATH varchar2(256) := 'wm.reports.preview';

	ADMINISTRATIONPORTLETPATH varchar2(256) := 'wm.administration.portlet';
	ADMINISTRATIONPREVIEWPATH varchar2(256) := 'wm.administration.preview';

  SESSIONPATH varchar2(256) := 'wm.session';

	CUSTOMIZE	varchar2(20) :=	'10223';
	REPORT		varchar2(20) := '10295';
	APPLY		varchar2(20) := '10211';
	CANCEL		varchar2(20) := '10214';
	REVERT		varchar2(20) := '10302';
	OK		varchar2(20) := '10274';
	YES		varchar2(20) := '10322';
	NO		varchar2(20) := '10271';
	ALLOPTS		varchar2(20) := '10210';
	LIMIT		varchar2(20) := '10259';
	PREVIOUS	varchar2(20) := '10283';
	NEXT		varchar2(20) := '10270';
	Top		varchar2(20) := '10311';
	LAST		varchar2(20) := '10256';
	FIRST		varchar2(20) := '10238';
	CLOSE		varchar2(20) := '10215';
	SHEET		varchar2(20) := 'Sheet';
	ID		varchar2(20) := 'ID';
	IS_PORTLET	varchar2(20) := '10271';
	ADMIN_BACK_URL	varchar2(20) := 'back_url';
	EDIT		varchar2(20) := '10352';
	ADD		varchar2(20) := 'Add';
	DEL	varchar2(20) := 'Remove';
	
	BACK_URL	varchar2(2000) := 'back_url';
	BACKURL	varchar2(2000) := 'backurl';
	URL		varchar2(2000) := 'url';
	GROUPID	varchar2(2000) := 'groupid';
	ACTION	varchar2(2000) := 'action';
	

	REPOSITORY	varchar2(20) := '10300';
	ROLE		varchar2(20) := '10303';
	OBJECTTYPE	varchar2(20) := '10312';
	SEARCH	varchar2(20) := '10323';
	ISPUBLIC	varchar2(20) := 'Public';
	ISACTION	varchar2(20) := 'Action';
	REFRESHOPTION varchar2(20) := 'Refresh';

	SEARCH_REPOSITORY_DEFAULT	varchar2(20) := '';
	SEARCH_ROLE_DEFAULT		varchar2(20) := '';
	SEARCH_OBJECTTYPE_DEFAULT	varchar2(20) := '';
	SEARCH_DEFAULT		varchar2(20) := '';

	NAVIGATION_ROLE_DEFAULT		varchar2(20) := 'wmp_user';
  
	HELPER		varchar2(40) := 'wmp_rh_generic_report';
	CATEGORY		varchar2(20) :='';

	DISPLAY		varchar2(20) := '10230';
	DISPLAYCOUNT	varchar2(20) := 'DisplayCount';
	DISPLAYLIMIT	varchar2(20) := 'DisplayLimit';
	DISPLAYDESC		varchar2(20) := 'DisplayDesc';
	DISPLAYPATH		varchar2(20) := 'DisplayPath';

	DISPLAYCOUNT_DEFAULT	varchar2(20) 	:= ALLOPTS;
	DISPLAYLIMIT_DEFAULT 	varchar2(20)	:= '5';
	DISPLAYDESC_DEFAULT	varchar2(20) 	:= YES;
	DISPLAYPATH_DEFAULT	varchar2(20) 	:= YES;

	NAVIGATIONSTART	varchar2(20) 	:= 'NavigationStart';
	REPORTSTART	varchar2(20) 	:= 'ReportStart';

	NAVIGATIONSTART_DEFAULT		varchar2(20) 	:= '1';
	REPORTSTART_DEFAULT		varchar2(20) 	:= '1';

	MINIMIZENAVIGATION	varchar2(20) 	:= 'MinimizeNavigation';
	MINIMIZEREPORT		varchar2(20) 	:= 'MinimizeReport';

	MINIMIZENAVIGATION_DEFAULT	varchar2(20) 	:= '10271';	--No
	MINIMIZEREPORT_DEFAULT		varchar2(20) 	:= '10271';	--No
	
	LATEST_DBLINK_VERSION		varchar2(20)	:= '9.2';
	
	OWBBEXECUTABLE	varchar2(200)	:= '@OWBB:exec:';

	procedure save_display_options (
		p_session in varchar2 ,
		P_DISPLAY_COUNT in varchar2 := null,
		P_DISPLAY_LIMIT in varchar2 := null,
		P_DISPLAY_DESC in varchar2 := null,
		P_DISPLAY_PATH in varchar2 := null,
		P_navigation_start in varchar2 := null,
		P_report_start in varchar2 := null,
		P_minimize_navigation in varchar2 := null,
		P_minimize_report in varchar2 := null,
		p_repository in varchar2 := null,
		p_role_name in varchar2 := null,
		p_type in varchar2 := null,
		p_search in varchar2 := null,
		p_is_portlet in varchar2 := null,
		p_back_url in varchar2 := null, 
		p_reference_path in varchar2 := null
		);

	procedure reset_display_options (
		p_session in varchar2,
		p_sheet in number := null,
		p_is_portlet in varchar2 := null,
		p_back_url in varchar2 := null, 
		p_reference_path in varchar2 := null
		);

	procedure get_display_options (
		p_session in varchar2 ,
		P_DISPLAY_COUNT out varchar2,
		P_DISPLAY_LIMIT out varchar2,
		P_DISPLAY_DESC out varchar2,
		P_DISPLAY_PATH out varchar2,
		P_navigation_start out varchar2,
		P_report_start out varchar2,
		P_minimize_navigation out varchar2,
		P_minimize_report out varchar2,
		p_repository out varchar2,
		p_role_name out varchar2,
		p_type out varchar2,
		p_search out varchar2,
		p_is_portlet in varchar2 := null,
		p_back_url in varchar2 := null, 
		p_reference_path in varchar2 := null
		);

	procedure load_display_options (
		p_session in varchar2,
		p_sheet in number := null
		);

	procedure get_sheet_options (
		p_session in varchar2,
		p_sheet in number,
		P_navigation_start out varchar2,
		p_is_portlet in varchar2 := null,
		p_back_url in varchar2 := null, 
		p_reference_path in varchar2 := null
		);

	function help_language return varchar2;
	
	function is_9i_version return boolean;

end wmp_api_session;