create or replace package wmp_api_ui as
	
	type CurType is ref cursor;
	
	function font(p_class in varchar2, p_text in varchar2, p_style_file in varchar2 := null) return varchar2;
	function font(p_face in varchar2, p_color in varchar2, p_size in varchar2, p_text in varchar2) return varchar2;
	function blink(p_text in varchar2) return varchar2;
	function bold(p_text in varchar2) return varchar2;
	function italic(p_text in varchar2) return varchar2;
	function new_line(p_count in number := 1) return varchar2;
	function rule return varchar2;

	function image(p_image_name in varchar2,
		p_size_category in varchar2,
		p_alt in varchar2 := null,
		p_height in varchar2 := null,
		p_width in varchar2 := null,
		p_horiz_space in number := null,
		p_vert_space in number := null,
		p_align in varchar2 := null,
		p_tool_tip in varchar2 := null,
		p_border in number := null) return varchar2;

	function image_of_location(p_location_type in varchar2,
		p_size_category in varchar2,
		p_alt in varchar2 := null,
		p_height in varchar2 := null,
		p_width in varchar2 := null,
		p_horiz_space in number := null,
		p_vert_space in number := null,
		p_align in varchar2 := null,
		p_tool_tip in varchar2 := null,
		p_border in number := null) return varchar2;

	function image_of_functionlibrary(p_functionlib_type in varchar2,
		p_size_category in varchar2,
		p_alt in varchar2 := null,
		p_height in varchar2 := null,
		p_width in varchar2 := null,
		p_horiz_space in number := null,
		p_vert_space in number := null,
		p_align in varchar2 := null,
		p_tool_tip in varchar2 := null,
		p_border in number := null) return varchar2;

	function image_of_function(p_function_type in varchar2,
		p_size_category in varchar2,
		p_alt in varchar2 := null,
		p_height in varchar2 := null,
		p_width in varchar2 := null,
		p_horiz_space in number := null,
		p_vert_space in number := null,
		p_align in varchar2 := null,
		p_tool_tip in varchar2 := null,
		p_border in number := null) return varchar2;

	function image_of_activity(p_activity_type in varchar2,
		p_size_category in varchar2,
		p_alt in varchar2 := null,
		p_height in varchar2 := null,
		p_width in varchar2 := null,
		p_horiz_space in number := null,
		p_vert_space in number := null,
		p_align in varchar2 := null,
		p_tool_tip in varchar2 := null,
		p_border in number := null) return varchar2;

	procedure render_page_header(p_title in varchar2,
		p_style_file in varchar2,
		p_show_date in boolean := false,
		p_show_logout_hlink in boolean := false,
		p_show_favorites_hlink in boolean := false,
		p_add_to_favorites_url in varchar2 := null,
		p_show_favorites_customize in boolean := false,
		p_show_favorites_display in boolean := false,
		p_show_favorites_close in boolean := false,
		p_show_navigation_customize in boolean := false,
		p_show_full_page in boolean := false,
		p_show_full_page_url in varchar2 := null,
		p_repository_id in number := null, 
		p_role in varchar2 := null, 
		p_sheet in number := null, 
		p_type_name in varchar2 := null, 
		p_id in number := null,
		p_is_portlet in varchar2 := null,
		p_is_report_customize in varchar2 :=null,
		p_reference_path in varchar2 := null,
		p_back_url in varchar2 := null,
		p_show_reports_customize_close in boolean := false,
		p_show_admin_full_page in boolean := false,
		p_show_report_full_page in boolean := false,
		p_show_ora_wizard in boolean := false,
		p_help_html in varchar2 := null,
		p_favorites_close_url in varchar2 := null	
	);

	procedure render_page_footer(p_is_portlet in varchar2 := null);

	procedure render_table(p_cursor_id in number,
		p_layout in varchar2 := null,
		p_cell_border in number := 0,
		p_cell_spacing in number := 0,
		p_row_spacing in number := 0,
		p_table_width in number := 100,
		p_has_header in boolean := true,
		p_hidden_column_char in char := null,
		p_caption in varchar2 := null,
		p_caption_text_class in varchar2 := 'PortletHeading2',
		p_even_row_bgcolor_class in varchar2 := 'PortletBodyColor',
		p_even_row_text_class in varchar2 := 'PortletText2',
		p_odd_row_bgcolor_class in varchar2 := 'PortletSubheaderColor',
		p_odd_row_text_class in varchar2 := 'PortletText2',
		p_heading_bgcolor_class in varchar2 := 'TabBackgroundColor', 
		p_heading_text_class in varchar2 := 'PortletHeading2', 
		p_help_file in varchar2 := null,
		p_session in varchar2 := null,
		p_group_id in varchar2 := null,
		p_display_count in varchar2 := null,
		p_action in varchar2 := null,
		p_display_start in number := null,
		p_display_limit in number := null,
		p_display_helper in varchar2 := null,
		p_translate_header in boolean := false,
		p_nls_language in varchar2 := null,
		p_is_portlet in varchar2 := null,
		p_back_url in varchar2 := null, 
		p_reference_path in varchar2 := null,
		p_style_file in varchar2 := null
	);

	procedure render_row(p_cursor_id in number,
		p_layout in varchar2 := null,
		p_cell_border in number := 0,
		p_cell_spacing in number := 0,
		p_row_spacing in number := 0,
		p_table_width in number := 100,
		p_has_header in boolean := true,
		p_names_bold in boolean := false,
		p_names_italic in boolean := false,
		p_caption in varchar2 := null,
		p_caption_text_class in varchar2 := 'PortletHeading2',
		p_even_row_bgcolor_class in varchar2 := 'PortletBodyColor',
		p_even_row_text_class in varchar2 := 'PortletText2',
		p_odd_row_bgcolor_class in varchar2 := 'PortletSubheaderColor',
		p_odd_row_text_class in varchar2 := 'PortletText2',
		p_heading_bgcolor_class in varchar2 := 'TabBackgroundColor', 
		p_heading_text_class in varchar2 := 'PortletHeading2', 
		p_help_file in varchar2 := null,
		p_translate_header in boolean := false,
		p_nls_language in varchar2 := null,
		p_style_file in varchar2 := null
	);

	procedure render_extended_properties(p_cursor_id in number,
		p_layout in varchar2 := null,
		p_cell_border in number := 0,
		p_cell_spacing in number := 0,
		p_row_spacing in number := 0,
		p_table_width in number := 100,
		p_has_header in boolean := true,
		p_names_bold in boolean := false,
		p_names_italic in boolean := false,
		p_caption in varchar2 := null,
		p_caption_text_class in varchar2 := 'PortletHeading1',
		p_even_row_bgcolor_class in varchar2 := 'PortletBodyColor',
		p_even_row_text_class in varchar2 := 'PortletText2',
		p_odd_row_bgcolor_class in varchar2 := 'PortletSubheaderColor',
		p_odd_row_text_class in varchar2 := 'PortletText2',
		p_heading_bgcolor_class in varchar2 := 'TabBackgroundColor', 
		p_heading_text_class in varchar2 := 'PortletHeading1', 
		p_help_file in varchar2 := null,
		p_translate_header in boolean := false,
		p_nls_language in varchar2 := null,
		p_style_file in varchar2 := null
	);

	procedure render_value(p_cursor_id in number,
		p_cell_border in number := 0,
		p_cell_width in number := 100,
		p_bgcolor_class in varchar2 := 'PortletBodyColor',
		p_text_class in varchar2 := 'PortletText2',
		p_help_file in varchar2 := null,
		p_style_file in varchar2 := null
	);

	procedure render_wizard_header(
		p_title in varchar2,
		p_help_url in varchar2 := null,
		p_help_image in varchar2 := null,
		p_help_alt in varchar2 := 'Help',
		p_action in varchar2 := null,
		p_wizard_image in varchar2 := null,
		p_revert in boolean := false,
		p_apply in boolean := false,
		p_ok in boolean := false,
		p_cancel in boolean := false,
		p_close in boolean := false,
		p_method in varchar2 := 'POST',
		p_attributes in varchar2 := null,
		p_help_file in varchar2 := null	
		);

	procedure render_wizard_footer;

	procedure render_css(
		p_style_id in number := null
		);

	procedure render_content_type;

	procedure render_document_type;

	procedure render_page_info(
		p_style_id in number := null
		);

	procedure render_about_page(
		p_back_url in varchar2 := null
		);
	
	procedure render_executable(
		p_execute_statement in varchar2
		);

end wmp_api_ui;