REM dbdrv: none
REM +=======================================================================+
REM |        Copyright (c) 1996, 2004, Oracle. All rights reserved.         |
REM +=======================================================================+
REM | FILENAME                                                              |
REM |   AFASAPIS.pls                                                        |
REM |                                                                       |
REM | DESCRIPTION     							    |
REM |   Specification for API global datatypes, constants and utilities.    |
REM |   This is a stub for Workflow Standalone to define only the constants.| 
REM +=======================================================================+

set verify off;
whenever sqlerror exit failure rollback;
whenever oserror exit failure rollback;

CREATE or REPLACE PACKAGE FND_API AS
/* $Header: AFASAPIS.pls 26.0 2004/04/21 10:09:53 vshanmug noship $ */

--  Global constants that represent missing values. These constants
--  are used as default values for PL/SQL procedures and functions
--  parameters to distinguish between parameters that are passed and
--  have a value of NULL and those which are not passed to the procedure.

G_MISS_NUM  	CONSTANT    NUMBER  	:= 9.99E125;
G_MISS_CHAR   	CONSTANT    VARCHAR2(1) := chr(0);
G_MISS_DATE    	CONSTANT    DATE    	:= TO_DATE('1','j');

--  API return status
--
--  G_RET_STS_SUCCESS means that the API was successful in performing
--  all the operation requested by its caller.
--
--  G_RET_STS_ERROR means that the API failed to perform one or more
--  of the operations requested by its caller.
--
--  G_RET_STS_UNEXP_ERROR means that the API was not able to perform
--  any of the operations requested by its callers because of an
--  unexpected error.

G_RET_STS_SUCCESS       CONSTANT    VARCHAR2(1) :=  'S';
G_RET_STS_ERROR         CONSTANT    VARCHAR2(1) :=  'E';
G_RET_STS_UNEXP_ERROR   CONSTANT    VARCHAR2(1) :=  'U';

--  API error exceptions.
--  G_EXC_ERROR :   Is used within API bodies to indicate an error,
--                  this exception should always be handled within the
--                  API body and p_return_status shoul;d be set to
--                  error. An API should never return this exception.
--  G_EXC_UNEXPECTED_ERROR :
--                  Is raised by APIs when encountering an unexpected
--                  error.

G_EXC_ERROR             EXCEPTION;
G_EXC_UNEXPECTED_ERROR  EXCEPTION;

--  Global constants representing TRUE and FALSE.

G_TRUE      CONSTANT    VARCHAR2(1) := 'T';
G_FALSE     CONSTANT    VARCHAR2(1) := 'F';

end FND_API;
/
commit;
exit;

