/*=======================================================================+
 |  Copyright (c) 1993 Oracle Corporation Redwood Shores, California, USA|
 |                          All rights reserved.                         |
 +=======================================================================+
 | FILENAME
 |      AFCPUTLB.pls
 |
 | DESCRIPTION
 |      PL/SQL body for package :  FND_CONCURRENT
 |      Dummy package FND_CONCURRENT
 |
 | HISTORY
 |      XX/XX/93    R Bhoopalam    Created
 |      03/01/01    D Lam          Modified for WF standalone version
 |
 *=======================================================================*/
whenever sqlerror exit failure rollback;

create or replace package body FND_CONCURRENT as
/* $Header: AFCPUTLB.pls 26.0 2001/03/03 23:42:03 dlam ship $ */
--
-- Package
--   FND_CONCURRENT
-- Purpose
--   Concurrent processing related utilities
-- History
--   XX/XX/93	Ram Bhoopalam	Created
--
  --
  -- PUBLIC VARIABLES
  --

  -- Exceptions

  -- Exception Pragmas

  --
  -- PUBLIC FUNCTIONS
  --

  PROCEDURE SET_PREFERRED_RBS
  is
    sql_stmt varchar2(101);
  begin
    if Fnd_Concurrent.RBS is not Null then
      sql_stmt := 'Set Transaction Use Rollback Segment '||Fnd_Concurrent.RBS;
      commit;
      execute immediate sql_stmt;
    end if;
    return;

  exception
    when OTHERS then
      return;
  end SET_PREFERRED_RBS;

 end FND_CONCURRENT;
/


REM ================================================================
commit;
exit;

/
REM ================================================================








