REM dbdrv: sql ~PROD ~PATH ~FILE none none none package &phase=pls \
REM dbdrv: checkfile:~PROD:~PATH:~FILE
rem *======================================================================+
rem |  Copyright (c) 1992 Oracle Corporation Belmont, California, USA      |
rem |                          All rights reserved.                        |
rem +======================================================================+
rem | FILENAME
rem |     AFNLMSGS.pls
rem |
rem | DESCRIPTION
rem |     PL/SQL specification for package:  FND_MESSAGE
rem |
rem | NOTES
rem |     called by AutoInstall (afplss.drv) for install and upgrade;
rem |     grant/synonym for this package is created by FNDSCGSO.
rem |
rem | HISTORY
rem |  3/23/93    T Morrow    Created
rem |  5/27/93    G Buzsaki   Updated to new 10.x spec
rem | 11/27/01    P Walker(HRMS) Added GET_TOKEN function
rem | 01/27/02    C Clark       Added -FETCH_SQL_TOKEN (ATG only) 
rem | 05/06/02    C Clark       2287073- Added -SET_TOKEN_SQL, now public
rem +======================================================================*

SET VERIFY OFF;
whenever sqlerror exit failure rollback;


create or replace package FND_MESSAGE AUTHID DEFINER as
/* $Header: AFNLMSGS.pls 115.0 2003/01/31 07:41:52 ndivakar noship $ */


    /*
    ** SET_NAME - sets the message name
    */
    procedure SET_NAME(APPLICATION in varchar2, NAME in varchar2);
    pragma restrict_references(SET_NAME, WNDS);

    /*
    ** SET_TOKEN - defines a message token with a value
    */
    procedure SET_TOKEN(TOKEN     in varchar2,
                        VALUE     in varchar2,
                        TRANSLATE in boolean default false);
    pragma restrict_references(SET_TOKEN, WNDS);

    /*
    ** SET_TOKEN_SQL - define a message token with a SQL query value
    **
    ** Description:
    **   Like SET_TOKEN, except here the value is a SQL statement which
    **   returns a single varchar2 value.  (e.g. A translated concurrent
    **   manager name.)  This statement is run when the message text is
    **   resolved, and the result is used in the token substitution.
    **
    ** Arguments:
    **   token - Token name
    **   value - Token value.  A SQL statement
    **
    */ 
    procedure SET_TOKEN_SQL (TOKEN in varchar2,
                             VALUE in varchar2);

    /*
    ** RETRIEVE - gets the message and token data, clears message buffer
    */
    procedure RETRIEVE(MSGOUT out varchar2);
    pragma restrict_references(RETRIEVE, WNDS);

    /*
    ** CLEAR - clears the message buffer
    */
    procedure CLEAR;
    pragma restrict_references(CLEAR, WNDS);

    /*
    **	GET_STRING- get a particular translated message 
    **       from the message dictionary database. 
    ** 
    **  This is a one-call interface for when you just want to get a
    **  message without doing any token substitution.  
    **  Returns NULL if the message cannot be found.
    */	
    function GET_STRING(APPIN in varchar2, 
	      NAMEIN in varchar2) return varchar2;
    pragma restrict_references(GET_STRING, WNDS, WNPS);

    /*
    **  FETCH_SQL_TOKEN- get the value for a SQL Query token
    **     This procedure is only to be called by the ATG 
    **     not for external use 
    */
    function FETCH_SQL_TOKEN(TOK_VAL in varchar2) return varchar2;
    pragma restrict_references(FETCH_SQL_TOKEN, WNDS);

    /*
    **	GET_NUMBER- get the message number of a particular message. 
    ** 
    **  Returns 0 if the message has no message number, 
    **         or if its message number is zero.
    **       NULL if the message can't be found.
    */	
    function GET_NUMBER(APPIN in varchar2, 
	      NAMEIN in varchar2) return NUMBER;
    pragma restrict_references(GET_NUMBER, WNDS, WNPS);

    /*
    **	GET- get a translated and token substituted message 
    **       from the message dictionary database. 
    **       Returns NULL if the message cannot be found.
    */	
    function GET return varchar2;
    pragma restrict_references(GET, WNDS);

    /*
    ** GET_ENCODED- Get an encoded message from the message stack.
    */
    function GET_ENCODED return varchar2;
    pragma restrict_references(GET_ENCODED, WNDS);

    /* 
    ** PARSE_ENCODED- Parse the message name and application short name
    **                out of a message in "encoded" format.
    */
    procedure PARSE_ENCODED(ENCODED_MESSAGE IN varchar2,
			APP_SHORT_NAME  OUT varchar2,
			MESSAGE_NAME    OUT varchar2);
    pragma restrict_references(PARSE_ENCODED, WNDS, WNPS);

    /*
    ** SET_ENCODED- Set an encoded message onto the message stack
    */
    procedure SET_ENCODED(ENCODED_MESSAGE IN varchar2);
    pragma restrict_references(SET_ENCODED, WNDS);

    /*
    ** raise_error - raises the error to the calling entity
    **               via raise_application_error() prodcedure
    */
    procedure RAISE_ERROR;
    pragma restrict_references(RAISE_ERROR, WNDS, WNPS);

    /*
    **  GET_TOKEN- Obtains the value of a named token from the
    **             current message.
    **         IN: TOKEN- the name of the token that was passed to SET_TOKEN
    **             REMOVE_FROM_MESSAGE- default NULL means 'N'
    **              'Y'- Remove the token value from the current message 
    **              'N'- Leave the token value on the current message
    **    RETURNs: the token value that was set previously with SET_TOKEN
    */
    function GET_TOKEN(TOKEN IN VARCHAR2
            ,REMOVE_FROM_MESSAGE IN VARCHAR2 default NULL /* NULL means 'N'*/
            ) return varchar2;

end fnd_message;
.
/


REM ================================================================
commit;
exit;
