/*=======================================================================+
 |  Copyright (c) 1993 Oracle Corporation Redwood Shores, California, USA|
 |                            All rights reserved.                       |
 +=======================================================================+
 | FILENAME
 |      AFPFPROB.pls
 |
 | DESCRIPTION
 |      PL/SQL body for package:  FND_PROFILE
 |
 |      Maintains the server side cache of profile options.
 |
 | NOTES
 |     This module is to be used by Oracle Workflow Standalone only.
 |     It replaces the FND_PROFILE package.
 |
 | HISTORY
 |        11/23/00    S Mayze    Created
 *=======================================================================*/

whenever sqlerror exit failure rollback;


create or replace package body FND_PROFILE as
/* $Header: AFPFPROB.pls 26.2 2002/09/11 11:02:49 vshanmug ship $ */


    /*
    ** value - get profile value, return as function value
    */
    function VALUE(NAME in varchar2) return varchar2 is
    username varchar2(320);
    begin
        -- if the profile is WF_SIG_TEXT_ONLY return Y by default 
        if (name = 'WF_SIG_TEXT_ONLY') then
            wfa_sec.GetSession(username);
            username := upper(username);
            return (wf_pref.get_pref(username, 'WF_SIG_TEXT_ONLY'));
        else
            -- Always return NULL in the standalone case.
            return ('');
        end if;
    end;

    /*
    ** VALUE_SPECIFIC - returns the value of a profile option for a 
    ** specified user, responsibility, or application.
    */

    function VALUE_SPECIFIC ( NAME 	          in   VARCHAR2,
			      USER_ID		  in   NUMBER   default NULL,
			      RESPONSIBILITY_ID   in   NUMBER   default NULL,
			      APPLICATION_ID	  in   NUMBER   default NULL)
     return varchar2 is
     BEGIN
        -- Always return NULL in the standalone case.
       return('');
     
     END;

end FND_PROFILE;
/
REM show errors PACKAGE BODY FND_PROFILE 

REM ================================================================
commit;
exit ;
