/*=======================================================================+
 |  Copyright (c) 1993 Oracle Corporation Redwood Shores, California, USA|
 |                            All rights reserved.                       |
 +=======================================================================+
 | FILENAME
 |      AFPFPROS.pls
 |
 | DESCRIPTION
 |      PL/SQL specification for package:  FND_PROFILE
 |
 |      Maintains the server side cache of profile options.
 |
 | NOTES
 |      This module is indended for Oracle Workflow standalone only.
 |      It replaces the FN_PROFILE package.
 |
 | HISTORY
 |        11/23/00    S Mayze    Created
 *=======================================================================*/

whenever sqlerror exit failure rollback; 


create or replace package FND_PROFILE as
/* $Header: AFPFPROS.pls 26.3 2002/09/11 11:02:37 vshanmug ship $ */

    /*
    ** VALUE - returns the value of a profile options
    */
    function  VALUE(NAME in varchar2) return varchar2;
    -- pragma restrict_references(VALUE, WNDS);

    /*
    ** VALUE_SPECIFIC - returns the value of a profile option for a 
    ** specified user, responsibility, or application.
    */

    function VALUE_SPECIFIC ( NAME 	          in   VARCHAR2,
			      USER_ID		  in   NUMBER   default NULL,
			      RESPONSIBILITY_ID   in   NUMBER   default NULL,
			      APPLICATION_ID	  in   NUMBER   default NULL)
     return varchar2;

end FND_PROFILE;

/

REM ================================================================
commit;
exit;
