REM dbdrv: sql ~PROD ~PATH ~FILE none none none package &phase=pls checkfile:~PROD:~PATH:~FILE
REM +=======================================================================+
REM |    Copyright (c) 2003 Oracle Corporation, Redwood Shores, CA, USA     |
REM |                         All rights reserved.                          |
REM +=======================================================================+
REM | FILENAME                                                              |
REM |     AFSOCTKS.pls                                                      |
REM |                                                                       |
REM | DESCRIPTION                                                           |
REM |     SSWA session management                                           |
REM |                                                                       |
REM | NOTES                                                                 |
REM |                                                                       |
REM | HISTORY                                                               |
REM | 27-AUG-03 nlbarlow 3043733 Created based on work by Andy Philips      |
REM +=======================================================================+

set verify off
whenever sqlerror exit failure rollback;
whenever oserror exit failure rollback;

CREATE OR REPLACE PACKAGE fnd_crypto AS
/* $Header: AFSOCTKS.pls 115.2 2003/12/07 15:32:53 nlbarlow noship $ */

    -- Hash Functions
    HASH_MD5           CONSTANT PLS_INTEGER      :=     2;

    -- MAC Functions
    HMAC_MD5           CONSTANT PLS_INTEGER      :=     1;
    HMAC_CRC           CONSTANT PLS_INTEGER      :=     4;

    -- Block Ciphers
    DES_CBC_PKCS5      CONSTANT PLS_INTEGER      :=  4353;
    DES3_CBC_PKCS5     CONSTANT PLS_INTEGER      :=  4355;

    -- Encoding Formats
    ENCODE_B64         CONSTANT PLS_INTEGER      :=     1;  -- Base 64
    ENCODE_URL         CONSTANT PLS_INTEGER      :=     2;  -- URL 64
    ENCODE_ORC         CONSTANT PLS_INTEGER      :=     3;  -- URL 64 drop bits

    -- Conversion formats
    CONVERT_ICX_STYLE  CONSTANT PLS_INTEGER      :=     1;  -- icx.CRC style


    ----------------------------- EXCEPTIONS ----------------------------------
    -- Invalid Cipher Suite
    InvalidCipherSuite EXCEPTION;
    PRAGMA EXCEPTION_INIT(InvalidCipherSuite, -28827);


    ---------------------- FUNCTIONS AND PROCEDURES ------------------------

    ------------------------------------------------------------------------
    --
    -- NAME:  Encrypt
    --
    -- DESCRIPTION:
    --
    --   Encrypt plain text data using stream or block cipher with user
    --   supplied key and optional iv.
    --
    -- PARAMETERS
    --
    --   plaintext   - Plaintext data to be encrypted
    --   crypto_type - Stream or block cipher type plus modifiers
    --   key         - Key to be used for encryption
    --   iv          - Optional IV for block ciphers.  Default all zeros.
    --
    ------------------------------------------------------------------------
    FUNCTION Encrypt (plaintext   IN RAW,
                      crypto_type IN PLS_INTEGER  DEFAULT DES3_CBC_PKCS5,
                      key         IN RAW,
                      iv          IN RAW          DEFAULT NULL)
      RETURN RAW;


    ------------------------------------------------------------------------
    --
    -- NAME:  Decrypt
    --
    -- DESCRIPTION:
    --
    --   Decrypt crypt text data using stream or block cipher with user
    --   supplied key and optional iv.
    --
    -- PARAMETERS
    --
    --   cryptext    - Crypt text data to be decrypted
    --   crypto_type - Stream or block cipher type plus modifiers
    --   key         - Key to be used for encryption
    --   iv          - Optional IV for block ciphers.  Default all zeros.
    --
    ------------------------------------------------------------------------
    FUNCTION Decrypt (cryptext    IN RAW,
                      crypto_type IN PLS_INTEGER DEFAULT DES3_CBC_PKCS5,
                      key         IN RAW,
                      iv          IN RAW          DEFAULT NULL)
      RETURN RAW;


    ------------------------------------------------------------------------
    --
    -- NAME:  Hash
    --
    -- DESCRIPTION:
    --
    --   Hash source data by cryptographic hash type.
    --
    -- PARAMETERS
    --
    --   source    - Source data to be hashed
    --   hash_type - Hash algorithm to be used
    --
    -- USAGE NOTES:
    --   SHA-1 (HASH_SH1) is recommended.  Consider encoding returned
    --   raw value to hex or base64 prior to storage.
    --
    ------------------------------------------------------------------------
    FUNCTION Hash (source    IN RAW,
                   hash_type IN PLS_INTEGER default HASH_MD5)
      RETURN RAW;


    ------------------------------------------------------------------------
    --
    -- NAME:  Mac
    --
    -- DESCRIPTION:
    --
    --   Message Authentication Code algorithms provide keyed message
    --   protection.
    --
    -- PARAMETERS
    --
    --   source   - Source data to be mac-ed
    --   mac_type - Mac algorithm to be used
    --   key      - Key to be used for mac
    --
    -- USAGE NOTES:
    --   Callers should consider encoding returned raw value to hex or
    --   base64 prior to storage.
    --
    ------------------------------------------------------------------------
    FUNCTION Mac (source   IN RAW,
                  mac_type IN PLS_INTEGER default HMAC_MD5,
                  key      IN RAW)
      RETURN RAW;


    ------------------------------------------------------------------------
    --
    -- NAME:  RandomBytes
    --
    -- DESCRIPTION:
    --
    --   Returns a raw value containing a pseudo-random sequence of
    --   bytes.
    --
    -- PARAMETERS
    --
    --   number_bytes - Number of pseudo-random bytes to be generated.
    --
    -- USAGE NOTES:
    --   number_bytes should not exceed maximum RAW length.
    --
    ------------------------------------------------------------------------
    FUNCTION RandomBytes (number_bytes IN POSITIVE)
      RETURN RAW;


    ------------------------------------------------------------------------
    --
    -- NAME:  RandomNumber
    --
    -- DESCRIPTION:
    --
    --   Returns a random NUMBER, 16 bytes.
    --
    -- PARAMETERS
    --
    --  None.
    --
    ------------------------------------------------------------------------
    FUNCTION RandomNumber
      RETURN NUMBER;

    ------------------------------------------------------------------------
    --
    -- NAME:  SmallRandomNumber
    --
    -- DESCRIPTION:
    --
    --   Returns a small random NUMBER, 4 bytes.
    --
    -- PARAMETERS
    --
    --  None.
    --
    ------------------------------------------------------------------------
    FUNCTION SmallRandomNumber
      RETURN NUMBER;

    ------------------------------------------------------------------------
    --
    -- NAME:  Encode
    --
    -- DESCRIPTION:
    --
    --   Encodes a RAW into specified format (ENCODE_*).
    --
    -- PARAMETERS
    --
    --   source   - Source data to be endoded.
    --   fmt_type - Encoding type for raw to varchar2.
    --
    ------------------------------------------------------------------------
    FUNCTION Encode (source   IN RAW,
                     fmt_type IN PLS_INTEGER)
      RETURN VARCHAR2;


    ------------------------------------------------------------------------
    --
    -- NAME:  Decode
    --
    -- DESCRIPTION:
    --
    --   Decodes a VARCHAR2 into RAW using the specified format (ENCODE_*).
    --
    -- PARAMETERS
    --
    --   source   - Source data to be endoded.
    --   fmt_type - Encoding type for varchar2 to raw.
    --
    ------------------------------------------------------------------------
    FUNCTION Decode (source   IN VARCHAR2,
                     fmt_type IN PLS_INTEGER)
      RETURN RAW;


END fnd_crypto;
/
commit;
exit;

