/*=======================================================================+
 |  Copyright (c) 1997 Oracle Corporation Redwood Shores, California, USA|
 |                            All rights reserved.                       |
 +=======================================================================+
 | FILENAME
 | DESCRIPTION
 |   PL/SQL spec for package:  FND_SVC_COMP_REQUESTS_H_PKG
 *=======================================================================*/
SET VERIFY OFF
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;

REM Added for ARU db drv auto generation
REM dbdrv: sql ~PROD ~PATH ~FILE none none none package &phase=pls \
REM dbdrv: checkfile:~PROD:~PATH:~FILE

create or replace package FND_SVC_COMP_REQUESTS_H_PKG authid current_user as
/* $Header: AFSVCHTS.pls 26.2 2002/12/10 21:11:18 ankung ship $ */

procedure INSERT_ROW (
  X_ROWID in out nocopy VARCHAR2,
  X_REQUEST_HISTORY_ID in NUMBER,
  X_COMPONENT_ID in NUMBER,
  X_EVENT_NAME in VARCHAR2,
  X_REQUEST_STATUS in VARCHAR2,
  X_REQUESTED_BY_USER in VARCHAR2,
  X_COMPLETION_DATE in DATE,
  X_COMPONENT_NAME in VARCHAR2,
  X_COMPONENT_STATUS in VARCHAR2,
  X_COMPONENT_TYPE in VARCHAR2,
  X_CONTAINER_TYPE in VARCHAR2,
  X_CONTAINER_NAME in VARCHAR2,
  X_EVENT_PARAMS in VARCHAR2,
  X_OBJECT_VERSION_NUMBER in NUMBER default 1,
  X_CREATION_DATE in DATE default sysdate,
  X_CREATED_BY in NUMBER,
  X_LAST_UPDATE_DATE in DATE default sysdate,
  X_LAST_UPDATED_BY in NUMBER,
  X_LAST_UPDATE_LOGIN in NUMBER
);

procedure LOCK_ROW (
  X_REQUEST_HISTORY_ID in NUMBER,
  X_COMPONENT_ID in NUMBER,
  X_EVENT_NAME in VARCHAR2,
  X_REQUEST_STATUS in VARCHAR2,
  X_REQUESTED_BY_USER in VARCHAR2,
  X_COMPLETION_DATE in DATE,
  X_COMPONENT_NAME in VARCHAR2,
  X_COMPONENT_STATUS in VARCHAR2,
  X_COMPONENT_TYPE in VARCHAR2,
  X_CONTAINER_TYPE in VARCHAR2,
  X_CONTAINER_NAME in VARCHAR2,
  X_EVENT_PARAMS in VARCHAR2,
  X_OBJECT_VERSION_NUMBER in NUMBER
);

procedure UPDATE_ROW (
  X_REQUEST_HISTORY_ID in NUMBER,
  X_COMPONENT_ID in NUMBER,
  X_EVENT_NAME in VARCHAR2,
  X_REQUEST_STATUS in VARCHAR2,
  X_REQUESTED_BY_USER in VARCHAR2,
  X_COMPLETION_DATE in DATE,
  X_COMPONENT_NAME in VARCHAR2,
  X_COMPONENT_STATUS in VARCHAR2,
  X_COMPONENT_TYPE in VARCHAR2,
  X_CONTAINER_TYPE in VARCHAR2,
  X_CONTAINER_NAME in VARCHAR2,
  X_EVENT_PARAMS in VARCHAR2,
  X_OBJECT_VERSION_NUMBER in NUMBER,
  X_LAST_UPDATE_DATE in DATE default sysdate,
  X_LAST_UPDATED_BY in NUMBER,
  X_LAST_UPDATE_LOGIN in NUMBER
);

procedure DELETE_ROW (
  X_REQUEST_HISTORY_ID in NUMBER
);

END fnd_svc_comp_requests_h_pkg;

/

commit;
exit;







