/*=======================================================================+
 |  Copyright (c) 1997 Oracle Corporation Redwood Shores, California, USA|
 |                            All rights reserved.                       |
 +=======================================================================+
 | FILENAME
 | DESCRIPTION
 |   PL/SQL spec for package:  FND_SVC_COMP_REQUESTS_PKG
 *=======================================================================*/
SET VERIFY OFF
WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;

REM Added for ARU db drv auto generation
REM dbdrv: sql ~PROD ~PATH ~FILE none none none package &phase=pls \
REM dbdrv: checkfile:~PROD:~PATH:~FILE

create or replace package FND_SVC_COMP_REQUESTS_PKG authid current_user as
/* $Header: AFSVCRTS.pls 26.2 2003/01/17 20:47:28 ankung ship $ */

procedure INSERT_ROW (
  X_ROWID in out nocopy VARCHAR2,
  X_COMPONENT_REQUEST_ID in NUMBER,
  X_COMPONENT_ID in NUMBER,
  X_EVENT_NAME in VARCHAR2,
  X_EVENT_DATE in DATE,
  X_REQUESTED_BY_USER in VARCHAR2,
  X_JOB_ID in NUMBER,
  X_EVENT_PARAMS in VARCHAR2,
  X_EVENT_FREQUENCY in NUMBER,
  X_OBJECT_VERSION_NUMBER in NUMBER default 1,
  X_CREATION_DATE in DATE default sysdate,
  X_CREATED_BY in NUMBER,
  X_LAST_UPDATE_DATE in DATE default sysdate,
  X_LAST_UPDATED_BY in NUMBER,
  X_LAST_UPDATE_LOGIN in NUMBER);

procedure LOCK_ROW (
  X_COMPONENT_REQUEST_ID in NUMBER,
  X_COMPONENT_ID in NUMBER,
  X_EVENT_NAME in VARCHAR2,
  X_EVENT_DATE in DATE,
  X_REQUESTED_BY_USER in VARCHAR2,
  X_JOB_ID in NUMBER,
  X_EVENT_PARAMS in VARCHAR2,
  X_EVENT_FREQUENCY in NUMBER,
  X_OBJECT_VERSION_NUMBER in NUMBER
);

procedure UPDATE_ROW (
  X_COMPONENT_REQUEST_ID in NUMBER,
  X_COMPONENT_ID in NUMBER,
  X_EVENT_NAME in VARCHAR2,
  X_EVENT_DATE in DATE,
  X_REQUESTED_BY_USER in VARCHAR2,
  X_JOB_ID in NUMBER,
  X_EVENT_PARAMS in VARCHAR2,
  X_EVENT_FREQUENCY in NUMBER,
  X_OBJECT_VERSION_NUMBER in NUMBER,
  X_LAST_UPDATE_DATE in DATE default sysdate,
  X_LAST_UPDATED_BY in NUMBER,
  X_LAST_UPDATE_LOGIN in NUMBER
);

procedure DELETE_ROW (
  X_COMPONENT_REQUEST_ID in NUMBER
);

procedure LOAD_ROW (
  X_COMPONENT_NAME in VARCHAR2,
  X_EVENT_NAME in VARCHAR2,
  X_EVENT_DATE in DATE,
  X_REQUESTED_BY_USER in VARCHAR2,
  X_EVENT_PARAMS in VARCHAR2,
  X_EVENT_FREQUENCY in NUMBER,
  X_OBJECT_VERSION_NUMBER in NUMBER,
  X_OWNER in VARCHAR2
);  

end FND_SVC_COMP_REQUESTS_PKG;
/


commit;
exit;




