REM dbdrv: sql ~PROD ~PATH ~FILE none none none package &phase=plb \
REM dbdrv: checkfile:~PROD:~PATH:~FILE
/*=======================================================================+
 |  Copyright (c) 1998 Oracle Corporation Redwood Shores, California, USA|
 |                            All rights reserved.                       |
 +=======================================================================+
 | FILENAME                                                              |
 |    AFTZONEB.pls                                                       |
 |                                                                       |
 | DESCRIPTION                                                           |
 |    Server side FND_TIMEZONES package - used to handle timezones       |
 |                                                                       |
 | NOTES                                                                 |
 |    This package was created to support timezones                      |
 |                                                                       |
 | HISTORY                                                               |
 |  02/20/02 P Sloan created                                             |
 |                                                                       |
 *=======================================================================*/
SET VERIFY OFF
whenever sqlerror exit failure rollback;
WHENEVER OSERROR EXIT FAILURE ROLLBACK;

CREATE OR REPLACE PACKAGE BODY fnd_timezones AS
/* $Header: AFTZONEB.pls 26.0 2003/11/27 12:14:57 smayze noship $ */

  -- returns the code for a given id
  function get_code(tz_id in number) return varchar2
  as
  begin
     return null;
  end;

  -- returns the translated name for a given code
  function get_name(tz_code in varchar2) return varchar2
  as
  begin
     return null;
  end;

  -- returns the server timezone_code
  function get_server_timezone_code return varchar2
  as
  begin
     return null;
  end;
  -- returns the client timezone_code
  function get_client_timezone_code return varchar2
  as
  begin
     return null;
  end;

  -- returns 'Y' or 'N' if timezones should be enabled or not
  function get_timezone_enabled_flag return varchar2
  as
  begin
     return 'N';
  end;

  -- returns 'Y' is the master switch for TZ is on and both the
  -- server/client timzone_id's are not null
  function timezones_enabled  RETURN VARCHAR2
  as
  begin
     return 'N';
  end;

END fnd_timezones;
/

commit;
exit;
