REM dbdrv: none
/*=======================================================================+
 |  Copyright (c) 1993 Oracle Corporation Redwood Shores, California, USA|
 |                            All rights reserved.                       |
 +=======================================================================+
 | FILENAME
 |      AFUTLOGS.pls
 |
 | DESCRIPTION
 |      PL/SQL specification for package:  FND_LOG
 |      A public interface designed for logging trace and non-user error
 |      messages at runtime.
 |
 | NOTES
 |      Stub implementation of FND_LOG Package for Workflow Standalone till
 |      FND_LOG is available standalone.
 |
 *=======================================================================*/

set verify off;
whenever sqlerror exit failure rollback;
whenever oserror exit failure rollback;

create or replace package FND_LOG as
/* $Header: AFUTLOGS.pls 26.1 2004/08/20 08:25:28 rosthoma noship $ */

   /* This global allows callers to avoid a function call if a log message is
      not for the current level. Since there is no implementation of FND_LOG
      in Standalone, this will be populated by WF_LOG_PKG.Init at the time of
      initializing the logging globals for that particular session.

      Most callers should not need it (they can just call TEST directly) but
      very tight loops that need to run at peak efficiency can save function
      call overhead when logging is turned off for the current level, by
      checking this global first. 

      Here is an example of how to achieve maximum performance with 
      this, assuming that you want to log a message at EXCEPTION level 
      in a tight loop, and that you need to use TEST since it takes a 
      significant amount of time to create your debug message: 

      if((WF_LOG_PKG.LEVEL_EXCEPTION >= FND_LOG.G_CURRENT_RUNTIME_LEVEL)) then
        if(WF_LOG_PKG.TEST(FND_LOG.LEVEL_EXCEPTION, 
               'fnd.wf.plsql.ABCDEFGH.PACKAGEA.FUNCTIONB.firstlabel')) then
           dbg_msg := create_lengthy_debug_message(...);
           FND_LOG.STRING(WF_LOG_PKG.LEVEL_EXCEPTION, 
              'fnd.wf.plsql.ABCDEFGH.PACKAGEA.FUNCTIONB.firstlabel', dbg_msg);
        end if; 
      end if; */

   G_CURRENT_RUNTIME_LEVEL NUMBER := 6;

end FND_LOG;
/
REM show errors package FND_LOG;
commit;
exit;

