rem *======================================================================+
rem |  Copyright (c) 1998 Oracle Corporation Belmont, California, USA      |
rem |                          All rights reserved.                        |
rem +======================================================================+
rem | FILENAME
rem |     AFWBCFGB.pls
rem |
rem | DESCRIPTION
rem |     PL/SQL spec for package:  FND_WEB_CONFIG
rem |
rem | NOTES
rem |     This module is for use with Oracle Workflow Standalone only.
rem |     It replaces the FND_WEB_CONFIG package.
rem |
rem | HISTORY
rem |  11/23/00    S Mayze     Created
rem +======================================================================*

whenever sqlerror exit failure rollback;

create or replace package FND_WEB_CONFIG as
/* $Header: AFWBCFGS.pls 26.1 2002/09/18 04:28:38 vshanmug ship $ */

/* DATABASE_ID- get the database host id
**
** Returns the database host id, lowercased.
**
** The implementation will return an identifier which forms a unique
** database identifier, suitable as a filename for the dbc file.
**
*/
function DATABASE_ID return VARCHAR2; 

/* PLSQL_AGENT- get the name of the PLSQL web agent
**
** Returns the value of the APPS_WEB_AGENT profile, with
** a guaranteed trailing slash.
**
** Note: if this routine fails, it will return NULL, and
** there will be an error message on the message stack.
** The caller is responsible for either displaying the message
** or clearing the message stack upon failure.
**
** IN:
**   help_mode - Look for HELP_WEB_AGENT profile over-ride
**               'APPS' - Use APPS_WEB_AGENT
**               'HELP' - Use HELP_WEB_AGENT
**
*/
function PLSQL_AGENT (help_mode in varchar2 default 'APPS') return VARCHAR2;

END FND_WEB_CONFIG;
/

REM ================================================================
commit;
exit;
