/*=======================================================================+
 |  Copyright (c) 1997 Oracle Corporation Redwood Shores, California, USA|
 |                            All rights reserved.                       |
 +=======================================================================+
 | FILENAME
 |      AFSCFNSB.pls
 | DESCRIPTION
 |      PL/SQL body for package:  FND_FUNCTION
 |      
 |      This package is pseudo package in standalone install.
 |      The real FND_FUNCTION would be used in Apps install.
 +======================================================================*/
whenever oserror exit failure rollback;
whenever sqlerror exit failure rollback;

create or replace package body FND_FUNCTION as
/* $Header: AFWFSFNB.pls 26.2 2004/01/16 07:03:08 dlam ship $ */

--
-- TEST
--   Test if function is accessible under current responsibility.
-- IN
--   function_name - function to test
-- RETURNS
--  TRUE if function is accessible
--
function TEST(function_name in varchar2) return boolean
is
  function_id number;
begin
  -- In standalone case, always returns false
  return(FALSE);
end TEST;

--
-- Function get_function_id
--      returns the function id for a function name.
-- in: p_function_name- the developer function name to look up
-- returns: the function id, or NULL if it can't be found.
------------------------------
Function get_function_id(p_function_name in varchar2
                       ) return number
is
begin
  -- In standalone case, always returns null
  return to_number(null);
end GET_FUNCTION_ID;

end FND_FUNCTION;
/
commit;
exit;



